The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).

[4.6.4] - 27 January, 2026

- Added: Translations for Spanish, French, and Italian languages. #2139
- Changed: Tooltip wording update for Filtered Post Types. #2150
- Changed: Wording update for Permissions Settings. #2151
- Fixed: "Create Revision" permission could allow Revisors to edit posts in certain configurations. #2131
- Fixed: Status lock mechanism now handles autosave correctly to avoid corrupting post drafts. #2130
- Removed: Default Visibility feature (functionality replaced by Statuses plugin). #2129
- Removed: Status Control module completely (functionality replaced by Statuses plugin). #2146

[4.6.3] - 30 December, 2025

- Updated: French, Spanish, and Italian translations to improve wording accuracy and completeness. #2101
- Updated: Teaser editor layout by moving option boxes section to the top for better usability. #2117

[4.6.2] - 18 December, 2025

- Added: New custom field support for the Pro version to extend permission configuration options. #2078
- Added: Additional field in the Edit Permissions screen to provide more granular control. #2075
- Fixed: Plain-text export issues affecting admin columns. #2069
- Fixed: Capability handling that incorrectly required type-specific capabilities for editing in some cases. #2074
- Updated: Improved wording for the Enable metabox option in Settings and corrected its default checked state. #2086
- Updated: Improved the visual design of informational messages inside the user profile for better readability. #2077
- Updated: Small wording adjustment in the General tab to improve clarity. #2070
- Updated: Removed Bulk Actions dropdown from the Permissions tab to simplify the interface. #2071
- Updated: Consolidated and cleaned up extra translation files related to hints. #2072
- Updated: French, Spanish, and Italian translations for the Free version. #2073
- Updated: Removed Post Permissions column to reduce unnecessary clutter. #2076

[4.6.1] - 3 December, 2025

- Fixed: WordPress 6.9 - Non-Administrators could not list or edit other user's posts #2057

[4.6.0] - 3 December, 2025

- Added: Implement new UI for Teaser. #2029
- Added: Configuration options to show/hide metaboxes per post type and in the Permissions screen. #2008
- Updated: Translations for Spanish, French, and Italian languages. #2007
- Fixes: Admin column export handling to prevent PHP errors. #2028
- Fixed: PHP errors when exporting admin columns. #2028
- Fixed: Various warnings, notices, and deprecated messages. #2012
- Fixed: Incorrect text domain in ErrorNotice.php. #2009

[4.5.2] - 27 October, 2025

- Added: Checkbox options for statuses in the Editing tab to provide more granular control. #1985
- Added: Skip Module mechanism to selectively disable modules for better performance and flexibility. #1980
- Added: Limited Editing Elements feature for refined access and editing restrictions. #1984
- Updated: Removed the “Most Used” tab from the Permissions screen to simplify the interface. #1983
- Updated: Settings tab now stays active after saving changes, improving workflow. #1982
- Updated: Moved “Advanced” tab for a more intuitive settings layout. #1979
- Updated: Renamed “Add Selected” button to “Add Selected Permissions” for clarity. #1975
- Updated: Spanish, Italian, Brazilian Portuguese, and French translations. #1973, #1974
- Updated: Remove User Posts menu #2000
- Fixed: Untranslated “None” caption in term selection box on Edit Permissions screen. #1981
- Fixed: Function errors in `AgentPermissions.php` that affected permission handling. #1962
- Fixed: Broken metaboxes compatibility issue with WooCommerce Google Product Feed plugin. #1969
- Fixed: Access failure issue with GiveWP integration. #1964

[4.5.1] - 1 October, 2025

- Added: Added a **User Page Promo tab** to highlight key features. #1926
- Compat: PublishPress Statuses - list, list_other capabilities were not effective where post editing requires status-specific capabilities
- Fixed: Corrected an issue where **PublishPress Statuses list capabilities** were ineffective if a post required status-specific editing capabilities. #1924

[4.5.0] - 10 September, 2025

- Added: Added filter hook to allow custom sanitization of settings. #1902
- Added: License key input box widened to support longer keys. #1901
- Fixed: Conflict with the PublishPress Statuses plugin that caused an "out of memory" error during login. #1873
- Fixed: Editing defaults now correctly applies only to new posts, not existing posts. #1870
- Fixed: Corrected text domain issues for proper localization. #1898
- Fixed: Corrected string translation issues in `SettingsTabEditing.php`. #1897
- Updated: Improved Features tab with capability cards for better design and clarity. #1886
- Updated: Improved checkbox hints on **Settings > Media Library** for clearer guidance. #1885
- Updated: Improved the "Features" tab design and layout for promotional content. #1869
- Updated: `.pot` translation file refreshed. #1903

[4.4.3] - 18 August, 2025

- Added: Description text in the Media Library settings for better clarity. #1866
- Fixed: Bug with default visibility and content lock feature not working correctly. #1859
- Fixed: Permissions now correctly applied to post revisions. #1837
- Fixed: Non-administrators can now properly edit new posts created with Crocoblock JetThemeCore. #1841
- Fixed: Adjusted integration tab count colors for better visibility. #1851
- Fixed: Updated text color in integration promos for better readability. #1855
- Fixed: Removed "Free" plugin listings from the Integrations tab to avoid confusion. #1852
- Updated: Improved captions for the Media Library tab in the settings screen. #1857
- Updated: Pro Settings tabs are now displayed at the end for a more organized layout.

[4.4.2] - 5 August, 2025

- Fixed: Prevented warning or error when handling fake post IDs. #1814
- Fixed: Conflict resolved between Select2 library and other plugins. #1812
- Fixed: PHP warning caused by invalid `map_meta_cap` parameters. #1810
- Fixed: `series_grouping` value in `getEnabledPostType()` could return null and cause a REST API error. #1813
- Updated: Tab color improvements for Pro features. #1815

[4.4.1] - 30 July, 2025

- Added: New UI Promotions Compatibility Pack in the free version to be integration tab. #1789
- Updated: Changed terminology from "Groups" to "Permissions" in various UI elements for better clarity. #1790

[4.4.0] - 9 July, 2025

- Fixed: Resolved a mismatch count exception when saving groups. #1747
- Fixed: Prevented roles from appearing for disabled post types on the Edit Permissions screen.
- Fixed: Resolved database query error on the WooCommerce Products screen. #1755
- Fixed: Improved exception handling to maintain consistent sorting of groups before and after saving. #1741
- Updated: Improved tooltip content and layout for term permissions (View / Edit / Assign) and sub-page permissions. #1740, #1745
- Updated: Adjusted button and datepicker UI on Memberships screen for better usability. #1761
- Updated: Enhanced settings UI to match future PublishPress visual style. #1763
- Updated: Adjusted CSS styling for the File Access feature. #1748
- Updated: Removed the "Display PublishPress Branding in Admin" option. #1744
- Updated: Composer dependencies updated and code cleanup for better performance and compatibility.

[4.3.2] - 11 June, 2025

- Fixed: Some Permissions list filters (Group Type, etc.) were not correct #1713
- Fixed: Permissions screen listed Permissions for deactivated statuses #1733
- Fixed: Screen Options for hidden columns on WordPress Users screen did not save #1719
- Fixed: Resolved a fatal error (E_ERROR) when managing user permissions in the WordPress admin area #1732
- Updated: Hide Specific Permissions column by default on WordPress Users screen #1720
- Updated: Remove filter links from custom columns on WordPress Users screen #1721
- Updated: Larger default sort icons for Permissions columns #1715

[4.3.1] - 3 June, 2025

- Updated: Adjust icon size for proper UI

[4.3.0] - 3 June, 2025

- Added: Tables in the Edit Permissions screen are now sortable for improved usability. #1580
- Added: New "Users" tab in the Permissions screen for filtering and managing user-based permissions. #1367
- Added: "Back to Normal View" button on Permissions screen to ease return from filtered views. #1640
- Added: With Edit Permissions screen, show a corresponding Permissions submenu. #1634
- Updated: Improved UI feedback by animating the "Save" button on Permissions save. #1563
- Updated: Removed redundant “New Group created” message. #1579
- Updated: Reorder columns in Permissions table, showing "Permissions" before "Roles". #1561
- Updated: Renamed “Sync Posts” to “User Pages” for clarity. #1507
- Updated: Changed page title and tab captions in Permissions screen for clarity. #1562
- Updated: Replaced "Read" with "View" in various labels for consistency. #1491
- Updated: Supplemental Roles are now labeled as “Extra Roles.” #1637
- Updated: Layout and text improvements across the Edit Permissions interface for clarity and accessibility.
- Updated: Composer dependencies updated and code cleanup for better performance and compatibility.
- Updated: Language `.pot` file updated with latest translation strings.
- Fixed: Menu color now adapts better to WordPress admin themes. #1638
- Fixed: Tooltips are more clear and informative across various screens.
- Fixed: PHP warning when updating a post under certain conditions. #1628
- Fixed: Uncompleted regex when editing Permissions. #1635
- Compat: The Events Calendar - Event category creation now works correctly. #1653
- Compat: PublishPress Capabilities - Use new `cme_capability_descriptions` filter for a more informative plugin capabilities tab. #1639
- Improved: Dashicons in Add Permissions screen have improved spacing. #1643
- Improved: Captions in Permissions > Settings now more clearly describe advanced links and capabilities.
- Improved: On initial Permissions plugin installation, create `pp_group_members` table with primary key for cleaner group-member relationships. #1646

[4.2.2] - 6 May, 2025

- Fixed: Restored the "Select Other" option for authors in the Classic Editor. #1540
- Fixed: Ensured proper HTML escaping when adding new user groups. #1567
- Fixed: Recaption "Add Permissions > Post Type > All Statuses" to "All Post Types" #1559
- Fixed: The "All Statuses" label is now correctly translated. #1609
- Fixed: Reduce white space for Group Members selection #1616
- Fixed: Membership module's Current Selections list is too narrow #1621
- Fixed: Circles module generated PHP warning if Post is null #1617
- Updated: Added missing Brazilian Portuguese translation. #1608

[4.2.1] - 2 May, 2025

- Fixed: Group Permissions on the Edit User screen now display with the correct formatting. #1601
- Fixed: Resolved an uncaught error that occurred on the Edit Group screen under certain conditions. #1598

[4.2.0] - 1 May, 2025

- Improved: Edit Permissions screen reorganized for easier access. #1319
- Improved: Stored Permissions interface redesigned for a more intuitive and flexible editing experience. #1573
- Fixed: "Select Other" option in Author metabox works properly again. #1540
- Fixed: Renamed sidebar menu label to “Permissions” for better clarity. #754
- Fixed: Sidebar Permissions menu item stays highlighted on the Edit Permissions screen, improving navigation clarity. #1510
- Fixed: Permissions Settings - If hints are enabled, they are displayed without requiring user interaction. #1530
- Fixed: Tooltip links are now easier to read with larger font size. #1526
- Compat: PublishPress Checklists - Icon in Select2 search box is now visible and aligned correctly. #1542
- Fixed: Dropdown menu using Select2 no longer covers the entire screen. #1519
- Updated: Group membership selection is now done by Select2 for improved usability. #1511
- Fixed: Permission Groups bulk actions now displayed when listing custom roles. #1548
- Fixed: Group names now display correctly when no name was set. #1568
- Fixed: Groups defined by PublishPress Revisions are now excluded from group count if the Revisions plugin is not active. #1500
- Fixed: Duplicate role-based user groups are no longer created during setup. #1545
- Updated: Permissions metaboxes now show both User display name and user_login for easier identification. #1529
- Fixed: Permissions metabox for Parent selection is now hidden on Term Edit screen for non-hierarchical taxonomies. #1509
- Fixed: Permissions metaboxes on Term Edit screen no longer disappear when using Yoast SEO. #1554
- Updated: Term Edit - When editing as a universal tag, some captions are adjusted to say "for All Post Types". #1508
- Lang: Refined translation files for improved accuracy. #1532
- Lang: Language translations updated for Spanish, French, Italian, and Brazilian Portuguese. #1532, #1528
- Updated: Composer dependencies refreshed for better compatibility and stability. #1574

[4.1.4] - 1 April, 2025

- Updated: Menu link renamed to "Permissions" for better clarity. #754
- Updated: Moved the "Tags" option to the Advanced tab. #1250
- Updated: Moved explanatory text into a tooltip for cleaner UI. #1217
- Updated: Display a message when no Groups or Users are available in Select2 fields. #1500
- Updated: Integrated Select2 for Group and User selection for improved usability. #1196
- Removed: Unnecessary message on Tags screen. #1327
- Fixed: Double "Update" button issue. #1496
- Fixed: Notes item was incorrectly shown in the Core tab. #1251
- Fixed: Incomplete string escaping in CSA. #1494
- Lang: Updated translations for 4.1.3 release. #1493

[4.1.3] - 6 March, 2025

- Added: Media tab to permissions settings. #1328
- Added: Classified `pp_assign_bulk_roles` capability on the Capabilities tab and documented it in Permissions > Settings. #1450
- Fixed: Pagination issue in specific areas. #1351
- Fixed: Database error caused by duplicate key. #1455
- Fixed: Tooltip position issue. #1468
- Fixed: Tooltip display issue in media settings. #1332
- Removed: Header elements on the Permissions screen. #1355
- Fixed: Removed media option for users who are not logged in. #1331
- Fixed: "Show all available constants" checkbox in Advanced Settings was not working. #1454
- Fixed: PHP Warning on the Edit Term screen. #1453
- Fixed: Posts query error on Multisite setups with abnormal site switching. #1451
- Updated: Logged-in user description updated for better clarity. #1330
- Removed: Messages on the category screen. #1326
- Updated: Improved "None" text for better clarity. #1349
- Feature: Category archive restriction now also applies to custom taxonomy archives. #1452
- Fixed: On Post update, numerically named category was created incorrectly. #1448
- Fixed: ACF Taxonomy Field did not include subcategories. #1395
- Fixed: Fatal error with some third party plugins. #1486
- Updated: Moved "Set Permissions" tab to be the first tab. #1354
- Updated: Moved "View All" tab for better accessibility. #1350
- Updated: Permissions text for better readability in groups. #1352
- Updated: Promo banner content. #1470
- Updated: Edit Permissions - Design fixes in Specific Permissions area #1353
- Lang: Translations for Spanish, French, and Italian. #1446
- Updated: Composer dependencies.

[4.1.2] - 10 February, 2025

- Added: Template function for the Teaser module (Pro). #1423
- Fixed: "Limit to" permissions for Revision Submission were blocking draft post editing. #1407
- Feature: Option to apply Category restrictions to archive page (Settings > Advanced > Front End) #1425
- Fixed: User Profile issue preventing removal of a user from all groups. #1403
- Fixed: If a role has a Specific Permissions assigned as "Limit to > (none)", the default post editor metabox selection for new posts was "Unblocked" #1401
- Fixed: Invalid classname in User/Groups selection. #1421
- Fixed: Role Usage could not update role's setting. #1420
- Fixed: PHP Warning for undefined variable `$item_status`. #1419
- Fixed: Parentheses removed from editor metaboxes for cleaner display. #1387
- Compat: PublishPress Revisions - Avoid conflict with implementation of list_others_revisions, preview_others_revisions capabilities (with Revisions 3.6.1)
- Compat: PublishPress Revisions - "Limit to" permissions for Revision Submission also blocked the editing of regular draft posts
- Updated: Settings > Advanced to clarify the effect of "Display all advanced options". #1435, #1437
- Updated: Access Circles: Allow Administrators to be added to a group. #1399
- Compat: PublishPress Revisions - Support reduced filtering for certain use cases. #1407
- Lang: .pot and .mo, including FR translations. #1392
- Updated: Composer dependencies.

[4.1.1] - 30 January, 2025

- Updated: Cleaner, better organized plugin settings tabs
- Updated: Sizing of Settings tabs for smaller screns
- Updated: Sizing, positioning for Settings screen right sidebar
- Fixed: Fatal error if other code filters pre_tax_input incorrectly. #1348
- Fixed: PHP Notice when deleting a group. #1338
- Fixed: PHP error under certain configurations. #1318
- Fixed: PHP warning for undefined array index in Permissions settings under some conditions. #1340
- Fixed: Media items were selectable even when media permissions were not enabled. #1323
- Updated: Renamed "Collaborative Editing" to align with updated terminology. #1307
- Updated: Moved "Statuses" to the Advanced area for better organization. #1255
- Removed: Purple color from the menu for a cleaner design. #1306
- Removed: "Import" option from the interface. #1295
- Lang: Translations for Spanish, French, and Italian text strings. #1316
- Updated: Project dependencies for improved compatibility and security.

[4.1.0] - 19 Dec, 2024

- Compat: PublishPress Statuses Pro - Support upcoming integration. #1286
- Updated: Improved design for editing groups. #1257
- Updated: White space removed from group list screen. #1245
- Updated: Edit Permissions - Button caption and message text for Permissions clone. #1258
- Updated: Permissions options moved to the "Advanced" settings area. #1247
- Updated: Tab "Modules" moved to the end and renamed to "Features." #1246
- Updated: Hide the "ID" column by default. #1244
- Added: New sidebar promotion area on plugin screens. #944
- Fixed: Poor query performance on highly populated sites using PublishPress Authors. #1269
- Fixed: Posts query errors on multisite installs with abnormal site switching/caching. #1271
- Fixed: PHP warning in the post editor under specific site configurations. #1265
- Fixed: Fatal error with miniOrange SSO during new post creation. #1263
- Fixed: Fatal error under some conditions when post types are abnormally registered. #1242
- Fixed: PHP warning for undefined variable. #1201
- Fixed: Non-Administrators cannot add new post on some sites #1303
- Fixed: Multisite - Database error in posts query on installations with abnormal site switching / caching
- Fixed: Multisite + PHP 8.2 - Fatal error on sub-sites created prior to Permissions install
- Compat: miniOrange SSO - Fatal error when adding a new post
- Compat: PublishPress Authors - poor front end query performance on highly populated sites
- Updated: Edit Permissions - Styling of Specific Permission selections. #1218
- Updated: Edit Permissions - Styling of Supplemental Role selections. #1257
- Removed: Redundant text from Plugins screen. #1214
- Updated: Normalized whitespace for cleaner codebase.
- Lang: Updated and refined translations. #1239, #1246
- Lang: .pot and .mo files with new and improved translations.

[4.0.34] - 14 Nov, 2024

- Fixed: Changes to Permissions metaboxes in Post editor were not saved

[4.0.33] - 13 Nov, 2024

- Fixed: Warning for early execution of load_plugin_textdomain() in WP 6.7 #1227
- Fixed: WP 6.6 - Updating a page caused propagated permissions to be cleared under some configurations
- Fixed: Specific Permissions for page editing caused incorrect page permalink to be output on Posts / Pages screen, under some configurations
- Fixed: Updating a page could clear propagated permissions in specific configurations #1223
- Updated: Captions for "Add Group" button #1195
- Removed: Outdated message about Status Control module #1200
- Updated: Changed wording of "Add New" button to "Add New Group" #1194
- Removed: Social links in footer #1193
- Removed: Penguin logo in headers #1191
- Compat: Custom Post Type UI - Experimental fix for editing permissions #1221
- Updated: Compatibility with WordPress 6.7 #527
- Updated: Improve translation handling by removing translation functions on variables where unnecessary.
- Updated: Code formatting and normalized whitespace.
- Lang: Updated reference language strings #1195
- Lang: Added Portuguese language hints #1202
- Lang: Added missing translation strings in permissions (free version) #1202
- Lang: Translation files #1190

[4.0.32 -, unreleased

[4.0.31] - 8 Oct, 2024

- Fixed: PHP Notice "Attempt to read property object_type on bool" under some configurations
- Compat: Events Manager - Error on event category creation if no other event categories exist

[4.0.30] - 25 Sep, 2024

- Compat: PublishPress Authors - Default author was inappropriately applied for Contributors / Authors under some configurations
- Change: Permissions metaboxes - include user_email as a User search field
- Change: Media cannot be edited or deleted if attached to an uneditable post (unless "Users can always edit their own attachments" setting is enabled)
- Change: Settings > Advanced > Constants - Setting checkbox to enable listing of all available constants (previously required constant definition)
- Change: Settings > Advanced > Constants - Improved formatting
- Fixed: Settings > Advanced > Constants - Add missing constant definitions, remove obsolete, list module-specific constants only if applicable
- Feature: Edit Permission Group - Bulk edit supports conversion of existing Permissions' adjustment (Enabled / Blocked / Limit to)

[4.0.29] - 16 Sep, 2024

- Fixed: WP 6.6 - Post Visibility settings did not correctly refresh Save As caption under some configurations
- Compat: PublishPress Statuses - Improved button captioning with Statuses 1.0.7

[4.0.28] - 3 Sep 2024 (unrelease,d)

- Fixed: WP 6.6 - Specific Permissions were not propagated to new subpages
- Fixed: WP 6.6 - Page Parent selection was not properly filtered under some configurations
- Feature: New setting, Permissions > Editing > "Page Parent selection for editable pages only", causes Page Parent availability to follow page editing access

[4.0.27] - 27 Aug 2024 (unrelease,d)

- Compat: WordPress 6.0 and earlier - Fatal error on category / term insertion
- Compat: Events Manager - If a restricted user adds an Event Category, the term hierarchy cache is updated to an empty array, breaking subsequent Event Category requests
- Compat: PublishPress Series - Specific Permissions could not be assigned for Series Categories
- Change: On new installations, create pp_group_members database table with a unique key

[4.0.26] - 1 Jul, 2024

Re-release with incremented version to force clearance of update package caches after previous mistagging

[4.0.25] - 26 Jun, 2024

- Compat: PublishPress Revisions - Administrators could not be added to Change Request Notification group

[4.0.24] - 18 Jun, 2024

- Compat: Advanced Custom Fields - Custom Post Types did not have type-specific capabilities enforced unless explicitly configured in ACF settings
- Compat: Admin Columns - Users listing inappropriately filtered under some conditions
- Compat: Disable Gutenberg - Classic Editor mode was not detected under some configurations
- Fixed: Settings UI - Checkbox for Permissions > Settings > Editing > Media Library > "Prevent editing uploads if attached to a non-editable post" not displayed under some conditions
- Fixed: Fatal error if constant SSEO_VERSION is unexpectedly defined

[4.0.23] - 7 May, 2024

- Compat: Google Analytics by MonsterInsights - custom field error message on post update
- Compat: PublishPress Revisions - Apply restrictive Submit Revisions permissions to limit Revision Queue listing
- Compat: PublishPress Capabilities - Negated capabilities were not properly applied under some Permissions configurations
- Compat: User Posts Limit - Users could not create more than one post
- Fixed: On selection of multiple new users for group membership, if one was already a group member, none of the new selections were added

[4.0.22] - 26 Apr, 2024

- Fixed: Fatal error updating a subpage

[4.0.21] - 25 Apr, 2024

- Fixed: Gutenberg Editor - empty categories were unselectable on some installations
- Change: Option to restore previous behavior by suppressing front end term filtering under some conditions
- Change: Remove penguins from Permissions > Settings screen header
- Fixed: PHP Warning on plugin activation
- Perf: Improve performance of user groups retrieval query
- Perf: Improve performance of post update query under some conditions
- Perf: Improve performance on attachment upload / update

[4.0.20] - 4 Mar, 2024

- Fixed: PHP Warning on PublishPress\Permissions\Groups::getGroupsForUser() / pp_get_groups_for_user() call

[4.0.19] - 29 Feb, 2024

- API: Function pp_get_groups_for_user() no longer defaulted to returning group objects
- Compat: bbPress - Forum Role column on Users screen was hidden
- Lang: Upate ES, FR, IT translations

[4.0.18] - 27 Feb, 2024

- Perf: Eliminated scan of users table on plugin activation (impacting sites with large number of users)
- Perf: Eliminated recursive query of subpages (impacting sites with complex page hierarchies)
- Perf: Improved caching of post capability checks
- Perf: On category / term queries, don't filter term counts if empty terms are not being hidden and counts are not being shown
- Code: Improved PHP Code Sniffer scan results
- Compat: Elementor - Could not use Elementor front end editor to save a draft of a published post
- Compat: Nested Pages - Apply pp_force_quick_edit capability to Nested Pages' Quick Edit and Contextual Add / Insert buttons
- Fixed: Filters for Post category, Tags, Terms, Parent or Status could be applied to wrong post under certain conditions
- Fixed: Permissions > Settings > Core > Front End > "Performance: Don't filter category / tag counts" was not applied for Administrator
- Fixed: Some strings on Permissions > Settings were not translated
- Fixed: Gutenberg editor usage was not properly detected when triggered by another plugin, possibly leading to issues with category / term assignment filtering
- Fixed: Category pages: Subcategory posts were inappropriately hidden on some sites
- Fixed: Legacy Nav Menu Management - Limited Nav Menu editors saw uneditable menus in dropdown on Menus management screen
- Fixed: Legacy Nav Menu Management filters interfered with front end filtering under some conditions
- Fixed: Sanity check to prevent excessive version history logging if installed plugin's version tags or version tag storage is incorrect
- Fixed: Terms were inappropriately auto-assigned under some conditions
- Change: Permissions > Settings > Editing option to disable auto-assignment of terms (when default term is not selectable). Note: Auto-assignment is required for some term-restricted editing configurations.
- Change: Auto-assign a term only if no default terms are selectable and the user's editing access is modified by term-specific Permissions
- Change: Never auto-assign a term to front page or posts page
- Change: Constant definitions related to term auto-assignment to assist any potential troubleshooting or restore previous behavior
- Change: User search for Specific Permission assignment - use LIKE matching for user meta field searches
- Change: Suppress "Enable Permissions" metaboxes in Post editor, Edit Term screens
- Change: Support constant PRESSPERMIT_MEDIA_UPLOAD_GRANT_PAGE_EDIT_CAPS for front end uploading solutions that require page editing capabilities for the async upload request
- Lib: Update wordpress-reviews library to v1.1.20
- Lib: Update wordpress-version-notices library to v2.1.3
- Lang: Update ES, FR, IT translations

[3.11.6] - 13 Dec, 2023

- Feature: Option to require Taxonomy edit capability to assign post tags that do not already exist
- Fixed: On Post edit, Tags were not filtered based on Specific Permissions
- Fixed: On Permissions > Settings, All Taxonomies remained checked even after updating with some disabled
- Compat: Work around unidentified compatibility issue affecting term filtering and access to certain static methods

[3.11.5] - 1 Nov, 2023

- Compat: Beaver Builder - Queries within BB shortcodes were improperly filtered
- Fixed: Supplemental role captions were blank
- Fixed: PHP Warning "Attempt to read property 'count' on string"
- Fixed: PHP Warning "Undefined variable $admin_post_new_url"

[3.11.4] - 26 Oct, 2023

- Fixed: Collaborative Publishing module was not loaded correctly on some installations
- Fixed: Caption for Permissions: Assign Term metabox in post editor
- Fixed: PHP Warnings on Permission Groups screen

[3.11.3] - 25 Oct, 2023

- Fixed: Some Permissions filtering was not applied on sites with a custom wp-admin URL
- Fixed: Type-specific Supplemental Roles also granted most generic capabliities in Pattern Role. Introduce new Permissions > Advanced > Role Integration setting to restore previous behavior if needed.
- Fixed: On page edit, if the Page Parent is not editable by the logged in user, it is hidden from the Page Parent selector. This occurred only with WP >[6.3 and with a non-standard, advancePermissions configuration.
- Fixed: PHP Warning in term filtering (Attempt to read property "term_taxonomy_id" on string) under some configurations
- Fixed: Filtering of default category / term by other plugin was overridden
- Fixed: Edit User Permissions - PHP Warning "compact(): Argument must be string..."
- Fixed: Fatal error "Call to a member function init() on null" under some configurations
- Fixed: Version update script triggering could be skipped on Pro installation under some conditions
- Compat: Polylang + WP 6.3 - Language filter was no longer applied to Page Parent dropdown
- Change: Added installation log to Permissions > Settings > Install

[3.11.1] - 30 Aug, 2023

- Fixed: Rest API access error on some sites (potentially preventing login)
- Fixed: Gallery block in Gutenberg editor: error loading Image Size dropdown options
- Fixed: Caption for Navigation Menus (for Navigation block) did not distinguish them from legacy Nav Menus
- Fixed: PHP 8.1 - Warning for dynamic property creation in post editor
- Compat: Peepso - Non-administrators couldn't submit front end posts on PHP >,[8

[3.10.0] - 19 Jun, 2023

- Compat: WooCommerce - Private Products were not listed in Shop, even if Read Permissions are assigned
- Compat: ACF Extended - Extra Update button on Edit Term screen
- Fixed: Fatal error for undefined PUBLISHPRESS_PERMISSIONS_PRO_VENDOR_PATH on some installations
- Fixed: If a "Limit to: (none)" Permission is assigned to default-restrict a post type, creating a new post causes a post-specific allowance to be assigned
- Fixed: Category filtering error caused Nav Menu corruption if empty category is used as a top level menu
- Change: Bump WordPress version requirement to 5.5
- Change: Bump PHP version requirement to 7.2.5
- Change: Update vendor libraries based on revised PHP version support

[3.9.3] - 11 May, 2023

- Change: Adjustment to composer.json
- Change: Adjustment to .gitignore

[3.9.2] - 10 May, 2023

- Fixed: Remove .git nested folders from some vendor libraries, using build script

[3.9.1] - 9 May, 2023

- Fixed: Fatal error in Composer installs due to missing vendor libraries
- Compat: PublishPress Planner - Status Change notifications were not sent

[3.9.0] - 4 May, 2023

- Fixed: Error updating plugin with Composer, fixed by removing unused vendor libraries
- Fixed: Fatal error in wp-admin if certain request variables have unexpected values
- Change: Bump WordPress version requirement to 5.5
- Change: Bump PHP version requirement to 7.2.5
- Change: Update vendor libraries based on revised PHP version support

[3.8.8] - 04 May, 2023

- Change: Added warning about end of support for WordPress 5.4 and earlier. PublishPress Permissions 3.9 will require WordPress 5.5 or later.

[3.8.7] - 30 Mar, 2023

- Change: Media Library - new setting to disable "Prevent editing uploads if attached to a non-editable post", available if Settings > Core > Filtered Post Types > "Enforce distinct capabilities for Media" is enabled
- Compat: WPML - Logged in users saw 404 error on Home Page viewing request if post type is not enabled for Permissions filtering
- Fixed: Error on post creation / update by Editor, under some configurations
- Fixed: PHP 8.1 - Notice in wp-admin
- Change: Minimum PHP version 7.2.5

[3.8.6] - 23 Mar, 2023

- Compat: Elementor - Error, memory exhaustion when users try to edit their own draft in Elementor
- Compat: PublishPress Revisions - When revision submission is enabled for unpublished posts, Revision Creation exceptions also allowed publication of main post
- Fixed: Fatal Error for some get_pages() queries

[3.8.5] - 9 Feb, 2023

- Fixed: Permission Group description was cleared when a new Permission is saved
- Fixed: If Permissions were set to limit Page Parent selection to a single page and its descendants, when that page itself was edited, all pages were displayed in Page Parent selector (though they could not be saved)
- Fixed: Nav Menu Management: Menu update by a limited user cause all uneditable menu items to be removed
- Fixed: Nav Menu management by limited user based on Permissions for a specific menu - On menu update, all uneditable items were removed
- Fixed: PHP Warning in login popup after current login times out
- Fixed: If constant PP_RESTRICTION_PRIORITY is set, "Limit to" Category permissions (the unblocked list) were still overriding "Exclude" Category permissions
- Compat: PublishPress Revisions - Permissions limiting revision creation to only specific posts also blocked reading access to other posts

[3.8.4] - 15 Dec, 2022

- Fixed: Nav Menu Manager role had no label on Edit Permissions screen after storage
- Fixed: Nav Menu Manager role did not allow menu creation
- Fixed: get_pages() call with large include or exclude array caused excessively large query
- Fixed: Classic Editor - limited authors may be locked out of editing new page if access depends on inheriting specific permissions from a required parent page
- Fixed: Edit Category / Tag - Extra update button, not needed for non-Administrators, who don't have multiple Specific Permission metaboxes

[3.8.2] - 17 Nov, 2022

- Fixed: Post preview did not display unsaved changes
- Fixed: WP 6.0 - Advanced option to "Delete settings on plugin deletion" prevented successful plugin deletion
- Fixed: PHP error "undefined function PublishPress\Permissions\ppc_delete_agent_permissions()" at user deletion on some installations
- Compat: Nested Pages - Subpages not listed if Permissions configured to make root level page uneditable
- Compat: Elementor - Work around Elementor requiring edit_posts capability no matter what type of post is being edited

[3.8] - 18 Oct, 2022

- Fixed: Category / Term Management restrictions did not exclude unmanagable terms from list
- Fixed: Clearance of category_children field caused issues for some third party plugins
- Fixed: Query Loop block - Sticky Posts displayed redundantly
- Fixed: Multisite - Invalid UI on some plugin screens for network installations
- Fixed: Users screen - PHP Notice for required parameter $column_name, $id
- Fixed: Edit Permission Group screen - PHP Notice for required parameter $agent_type
- Fixed: Edit Permission Group screen - PHP Notice for deprecated function
- Fixed: Archive widget - PHP Warning
- Fixed: HTML Forms plugin - PHP Notices
- Feature: Option to delete all plugin data and settings on plugin deletion
- Feature: New setting "List other user's uneditable posts", default disable on new installations
- Change: Disable "Add Author Page" dropdown on new installations
- Change: Settings screen caption, styling improvements
- Change: Use instance protection library to deal with duplicate / obsolete plugin activations
- Change: Plugin review request

[3.7.12] - 30 Aug, 2022

- Fixed: Sticky Posts were displayed redundantly in Query Loop block
- Compat: PublishPress Revisions - Category permissions for revision creation or submission failed if term_id differed from term_taxonomy_id

[3.7.11] - 16 Aug, 2022

- Fixed: PHP 8 - If a non-Administrator updated a top-level page, any Specific Permissions propagated to its subpages were cleared
- Fixed: Category / Term restrictions set for Everyone / Logged In were applied to Administrators
- Fixed: Fatal error on activation of certain other plugins
- Fixed: Fatal error if option "presspermit_deactivated_modules" has invalid value stored
- Workaround: Support PRESSPERMIT_AUTOSET_AUTHOR constant to set Author to current user if autoset_post_author / autoset_page_author capability is assigned

[3.7.10] - 7 Jul, 2022

- Fixed: Filter 'use_block_editor_for_post' was not recognized in detecting block editor disable
- Fixed: Category Permissions - Assign Category restrictions did not prevent checkbox display in Gutenberg post editor

[3.7.9] - 8 Jun, 2022

- Fixed: REST post creation - Category Assign restrictions were not applied unless accompanied with Edit restrictions; caused new category to be created
- Fixed: Permission Groups screen - Roles column displays unrendered html tags under some configurations

[3.7.8] - 2 Jun, 2022

- Fixed: Access failures under some configurations

[3.7.7] - 2 Jun, 2022

- Fixed: Authors could not create new posts; possibility of other access failures

[3.7.6] - 1 Jun, 2022

- Compat: WP 6.0 - Fatal error loading Customizer with PublishPress Revisions active, possibly in other areas
- Fixed: WP 6.0 - Edit User / Profile screen did not display group assignments
- Fixed: Implicit assignment of read capability forced all roles to have dashboard access
- Fixed: Edit Category screen did not have metabox for Assign Category permissions assignment
- Fixed: Category / Term assignment restrictions were not applied in Gutenberg editor
- Fixed: Category / Term permissions - exclusions were not applied to terms list for post template display
- Compat: The Events Calendar - post queries filtered incorrectly if event venue is involved

[3.7.5] - 2 May, 2022

- Fixed: Category Permissions set for "(all)" post types were not stored properly
- Fixed: Category / Term restrictions were not applied to post creation / edit by REST API
- Fixed: On new page creation, author could be locked out of editing if restrictive editing permissions are assigned and autosave occurs before manual save
- Fixed: Non-administrators can access Appearance menu, theme settings in WordPress 5.9

[3.7.4] - 20 Apr, 2022

- Lang: Spanish translation
- Lang: French translation
- Lang: Italian translation
- Fixed: Fatal error on post edit if category / term permissions are stored
- Fixed: PHP Warning on post update by non-Administrator
- Fixed: Customizer did not load under some configurations
- Fixed: Role Usage menu items not displayed under some configurations
- Fixed: Coding Standards - some output variables were not late-escaped

[3.7.3] - 3 Mar, 2022

- Compat: PublishPress - Non-Administators could not see unpublished posts on calendar
- Fixed: Edit Group / User Permissions - roles could not be removed
- Fixed: Non-administrators could not edit Menus on some installations
- Fixed: PHP Warnings on admin dashboard

[3.7.2] - 2-22,-22

- Fixed: Specific Permissions could not be added using editor metaboxes

[3.7.1] - 18 Feb, 2022

- Fixed: Category / Term blockages were not applied
- Fixed: Error redirecting following post save if the save operation sets a status which blocks the user from further editing
- Fixed: PHP 8 - Warning on Edit Permission Group screen

[3.7] - 17 Feb, 2022

- Fixed: Numerous instances of missing / non-standard output variable escaping
- Fixed: Numerous instances of missing / non-standard database query sanitization
- Fixed: Specific Permissions could not be added using editor metaboxes until after post is saved

[3.6.9] - 26 Jan, 2022

- Compat: WordPress 5.9 - fatal error adding / editing posts (work around WP hooking late-defined function _disable_block_editor_for_navigation_post_type)

[3.6.8] - 20 Jan, 2022

- Fixed: Specific Permissions could not be added or removed using metaboxes in the post editor

[3.6.7] - 5 Jan, 2022

- Fixed: Fatal error on sites not running PublishPress Revisions

[3.6.6] - 5 Jan, 2022

- Compat: PublishPress Revisions - Contributors couldn't edit own draft posts if "Prevent Revisors from editing other user's drafts" setting enabled
- Compat: PublishPress Revisions - "Revise" permissions assigned under previous Revisions versions did not enable revision creation
- Compat: PublishPress Revisions - Restrictive permissions for revision creation were not applied
- Compat: PublishPress Revisions - limited revisors could not edit newly created revision under some Permissions configurations
- Fixed: Error message after trashing a post in Gutenberg editor (although trashing was successful)
- Fixed: Trash button not initally displayed after creating a post (requires page reload)
- Fixed: Permissions table header styling was broken if custom styling is applied to certain standard WP classes
- Fixed: Edit User screen - Permissions box styling was broken if custom styling is applied to certain standard WP classes
- Fixed: Input sanitization consistency

[3.6.5] - 24 Nov, 2021

- Fixed: PHP Notice "Undefined index: list_published_posts"
- Compat: PublishPress Revisions - PHP Notice "Undefined variable: type_obj"

[3.6.4] - 23 Nov, 2021

- Compat: PublishPress Revisions - Published custom post types not listed to Revisors under some configurations (also requires Revisions 3.0.5)
- Compat: Public Post Preview - Disable Permissions filtering for public preview requests
- Compat: Database servers that return column names all lowercase
- Fixed: PHP Notice (undefined name property) on Edit Permission Group screen under some conditions
- Fixed: Page editor: permalink preview did not include parent pages

[3.6.3] - 16 Nov, 2021

- Compat: PublishPress Revisions - Revisions Submission permissions did not correctly adjust Edit Posts / Pages listing in some configurations (also requires Revisions 3.0.2)

[3.6.2] - 9 Nov, 2021

- Fixed: Nav Menu Editor - Offered to add unpublished posts to menu; post metabox paging failed if unpublished items present
- Fixed: Front end Nav Menu filter was applied regardless of "Disable all filtering for anonymous users" setting

[3.6] - 14 Oct, 2021

- Compat: PublishPress Revisions 3
- Fixed: Non-Administrators could not view image gallery in post preview
- Fixed: Page Structure settings did not prevent creation of top level pages in Gutenberg
- Feature: Edit Group Permissions screen - "Fix sub-Pages permissions" link causes Specific Permissions to be re-propagated to sub-pages if WP_DEBUG is defined (url argument: pp_fix_child_exceptions)
- Compat: PublishPress Revisions - Specific Permissions for "Revise" did not cause display of "Edit" link in Admin Bar

[3.5.7] - 26 Jul, 2021

- Fixed: Nav Menu Edit - Permissions configuration did not make private pages selectable
- Fixed: Nav Menu Edit - If Pages metabox results are paged, custom Front Page and Privacy Page were forced to the top of every results page
- Compat: WP Engine - Long wp-admin screen loads because excessive clearance of WP Engine cache caused WordPress to execute Update Plugins check on each request
- Fixed: Default / Lock Privacy settings were not properly reflected in Gutenberg Editor display
- Compat: HTML Forms plugin - PHP Notice on form submission / file upload

[3.5.6] - 23 Jun, 2021

- Fixed: Category / Term selector in post editor offered a maximum of 100 terms
- Fixed: Menu Editor - Page / Post selection metaboxes (if more than 50 total items are available) did not list private items after clicking a paging link
- Fixed: PHP Notice on plugin activation under some conditions
- Fixed: Fatal error if a very old version of Revisionary or PressPermit Core is active
- Compat: User Switching - First switched user inherits capabilities of current logged user on some sites
- Compat: WooCommerce - Failure / delay updating variations of variable product

[3.5.5] - 19 May, 2021

- Fixed: Add User screen - Javascript error on some sites
- Fixed: Term filtering error for some custom taxonomies
- Compat: WPML - Archives widget did not output links if multiple languages configured

[3.5.4] - 6 May, 2021

- Compat: Revisions - Pending Revision Monitors group ineffective when first installation of Permissions was >,[3
- Compat: Revisions - If draft revisions enabled, apply term-specific Revise permissions to unpublished posts if constant PRESSPERMIT_REVISE_TERMS_FOR_UNPUBLISHED defined
- Fixed: PHP warning on Permissions > Settings > Advanced

[3.5.2] - 8 Apr, 2021

- Compat: Gutenberg Ramp - Fatal error on editor screen if PublishPress Revisions not active
- Compat: Revisions Pro + Elementor, Divi or Beaver Builder: Pending Revision Monitors group membership did not control notifications

[3.5.1] - 6 Apr, 2021

- Fixed: Post Editor - toggling a Specific Permission Enabled / Disabled left both Enabled and Disabled permissions intact (with Enabled taking precedence under normal configuration)
- Fixed: Classic Editor - Publish metabox replaced "Public" caption with blank space
- Compat: Classic Editor plugin - PHP warning for undefined variable current_user on some screens if users are allowed to select their editor
- Compat: PublishPress Revisions - Revisors could not preview other users' pending revisions, even if they are listed in Revision Queue (also requires PublishPress Revisions 2.5.1)
- Compat: PublishPress Revisions - Pending Revision Monitors group ineffective; notifications were sent to all Editors and Administrators (also requires PublishPress Revisions 2.5.1)

[3.5] - 4 Mar, 2021

- Compat: Divi Builder - Specific Permissions did not allow non-Editors to edit other users' pages
- Compat: PublishPress Authors - non-Editors could be locked out of editing their own post due to "default author for new post" setting or manual Authors change
- Compat: PublishPress Authors - users who can edit due to specific permissions where blocked from Edit Posts / Pages screen under some configurations
- Compat: PublishPress Revisions - Specific Permissions did not allow Contributors to revise other users' pages
- Compat: Glance That plugin - Widget content was cleared
- Change: Settings screen - admin hints hidden by default, display on Comments icon click
- Change: Moved Users screen content to Settings > Advanced > User Permissions
- Lang: Separated admin hints into separate language file (text domains: press-permit-core-hints)
- Fixed: Permission metaboxes in post editor did not search user display name
- Fixed: Permission metaboxes in post editor - clicking search icon did not trigger search
- Fixed: Fatal error in some custom REST requests
- Perf: Eliminate a few redundant queries

[3.4.3] - 21 Jan, 2021

- Fixed: Edit Category / Term - Metaboxes for Editing and Assignment permissions were blank
- Fixed: Non-Administrators with editing access to an unpublished post could not view it using standard post link
- API: New filter 'presspermit_rest_post_endpoints' and 'presspermit_rest_term_endpoints' support some custom REST API routes and endpoints
- Compat: Simple WordPress Membership - Invalid metabox displayed on Edit Category screen

[3.4.2] - 20 Jan, 2021

- Compat: WP Engine Object Cache - initial pass at auto-clearing cache on plugin configuration changes
- Fixed: Slow comment count query for Contributors in wp-admin

[3.4.1] - 14 Jan, 2021

- Fixed: Anonymous visitors were blocked from viewing public posts under some conditions
- Fixed: Administrators could not assign roles or edit users with a role level higher that Subscriber, under some conditions
- Fixed: Fatal Error activating Permissions Pro if Permissions is already active
- Fixed: PHP Warning for undefined constant DB_NAME, on some installations
- Fixed: Deprecated jQuery event handlers
- Compat: PublishPress Revisions - Contributors could not edit their own drafts if Revisions is configured to restrict access to other users' drafts
- Compat: PublishPress Capabilities - With "Control Custom Statuses" enabled, custom capability was required to set Draft status
- Compat: WPML - Edit Category / Edit Term screen had duplicate Permissions metaboxes
- Compat: PublishPress Authors - PHP Notice in term / category filtering under some conditions
- Feature: Add / Edit User: single select for Permission Groups if constant PRESSPERMIT_EDIT_USER_SINGLE_GROUP_SELECTION or PRESSPERMIT_EDIT_USER_SINGLE_GROUP_SELECTION is defined

[3.4] - 17 Dec, 2020

- Compat: PublishPress Authors - integration of multiple authors in Permissions filtering
- Fixed: Better styling in Permissions / Groups administration UI

[3.3.10] - 8 Dec, 2020

- Compat: GD bbPress Attachments - 404 error on some sites following file rewrite rules update, if File Access module enabled
- Compat: Status Control + WooCommerce: PHP Notice on scheduled task execution
- Compat: Access Circles + PublishPress Revisions - Visibility Circles blocked editors from approving revisions
- Compat: PublishPress Revisions - Pending Revision Monitors group members were not properly filtered for editing access prior to display as available "Publishers to Notify"
- Compat: Divi Page Builder / theme - Contributors granted page editing permission for specific pages cannot edit those pages with Divi
- Compat: Visual Composer - PHP error for undefined class "PublishPress\Permissions\Capabilities" under some configurations
- Compat: Display Posts plugin - Posts with a custom privacy status were never listed (even if readable)
- Fixed: Edit Permissions screen - Cannot save Specific Permissions for a post type that has the same name as a taxonomy
- Fixed: Menus screen - Private posts were not included in "Add menu items" search results
- Fixed: Categories / Terms screen - Incorrect filtering under some conditions
- Lang: Move all Pro translations into a single file

[3.3.9] - 27 Oct, 2020

- Fixed: Permissions metaboxes were not displayed on Edit Category screen

[3.3.8] - 26 Oct, 2020

- Feature: Gutenberg block embedding - for users lacking "edit_posts" capability, allow embedding based on "upload_files" (or per "presspermit_embed_capability" filter)
- Feature: New setting - Core > Front End > "Performance: Don't filter category / tag counts"
- Fixed: REST tag / term queries returned all terms, ignoring per_page parameter
- Fixed: Comment count filtering - Incorrect Total for non-Administrators
- Fixed: Comment count filtering - Incorrect Approved subtotal for non-Administrators if PublishPress Notifications or Editorial Comments have been stored
- Compat: ODBC installations - Comment query database error caused issues including lack of confirmation message after Revision creation with PublishPress Revisions plugin
- Compat: Revisions - "Prevent Revisors from editing others' revisions" setting was not applied (also requires Revisions 2.4.2)
- Compat: Revisions - Category-Specific Revise Permissions allowed an Author to fully edit posts in specified categories
- Compat: Revisions - Category-Specific Revise Permissions allowed an Author to restore past revisions
- Compat: Revisions - If Revisors are blocked from editing other users' drafts, those can now be included (unclickable) in Edit Pages if the list_others_pages capability is granted
- Compat: Revisions - Specific Permissions to enable the Revise operation were ineffective for Contributors and Authors in some cases
- Fixed: PHP Warning for undefined index on first-time activation
- Fixed: PHP Warning on Edit Category page, for deprecated action name
- Change: Some settings captions referred to "PressPermit"

[3.3.7] - 9 Oct, 2020

- Compat: PublishPress Revisions - On new post creation, Revisors had Submit button replaced by a Publish button, which failed. The only way to submit was to Save Draft first.
- Compat: PublishPress Revisions - Existing "Edit Page" Permissions could not be mirrored as "Revise Page" Permissions using bulk action dropdown
- Compat: PublishPress Revisions - Existing "Revise Page" Permissions could not be mirrored as "Edit Page" Permissions using bulk action dropdown
- Compat: PublishPress Revisions - PHP warning on Edit Group Permissions screen if any Specific Permissions are stored for the Revise operation

[3.3.6] - 8 Oct, 2020

- Fixed: Post-specific permissions did not correctly enable access under some configurations with "Post-specific Permissions take priority" setting enabled

[3.3.5] - 1 Oct, 2020

- Change: Friendlier caption in Permissions metaboxes, "Editing permissions have not been added or blocked for any Custom Group"
- Fixed: Javascript error "jQuery is not defined" on some sites
- Fixed: Media items were always included in search results if filtering enabled. Now controlled by Settings > Core > Front End > Search Results include Media
- Fixed: Edit Permission Group - In Posts / Pages selector, "(none)" item was not available unless paging links clicked (since 3.1)
- Compat: Gutenberg Ramp - Revision submission UI did not load for post types that have Gutenberg enabled

[3.3.4] - 11 Sep, 2020

- Fixed: Post access was improperly blocked under some configurations if Permissions > Settings > Core > "Post-specific Permissions take priority" enabled

[3.3.3] - 10 Sep, 2020

- Fixed: Deleted WordPress roles were still listed in Permissions metaboxes of Post/Term editor
- Fixed: Limited term managers could not view some of their manageable terms under some configurations
- Fixed: Term managers who are limited to managing a fixed set of terms had "None" category listed in Parent dropdown, even though they cannot add a top-level category
- Fixed: Parent selection for custom post types was not properly filtered in Gutenberg editor
- Fixed: Setting "Post-specific Permissions take priority" ineffective under some configurations
- Compat: PublishPress Authors - activation of invalid "Custom permissions for Authors" setting on Edit Author screen (using a previous Permissions version) broke Authors > Authors listing and editing access
- Compat: Nested Pages - Enable Permissions filtering, but disable Quick Edit and Context Menu for non-Administrators by default. Available constants: PP_NESTED_PAGES_DISABLE_FILTERING, PP_NESTED_PAGES_QUICKEDIT_ROLES, PP_NESTED_PAGES_CONTEXT_MENU_ROLES
- Compat: WooCommerce - When editing a product, variation additions were blocked inappropriately

[3.2.5] - 13 Aug, 2020

- Fixed: WP 5.5 - Javascript error in Classic Editor if Default Privacy is set to a non-public status
- Fixed: WP object cache was cleared when a non-Administrator accessed wp-admin Pages listing
- Fixed: Pro - Post Status dropdown in Gutenberg editor was pushed into bad alignment if PublishPress 2.2 active
- Fixed: Classic Editor plugin - Block editor usage was not properly detected if user selection of default editor is enabled and set to Block

[3.2.4] - 7 Aug, 2020

- Fixed: Page Parent could not be viewed or changed in Gutenberg editor (since 3.2.3)

[3.2.3] - 6 Aug, 2020

- Fixed: Fatal error on new installations if Import module is activated
- Fixed: REST API - When context argument is used with include argument in a GET posts query, include value is ignored

[3.2.2] - 8 Jul, 2020

- Fixed: New post creation locked author out of further editing if editing permission restricted by term and necessary term was not selected (now auto-select allowed term if none selected)
- Fixed: Multisite - Permissions menu was not displayed if plugin network-activated and main site ID is not 1
- Fixed: Term-specific Permissions were not applied correctly in some configurations
- Fixed: Restrictive term-specific Permissions were not correctly negated by permissive term-specific restrictions assigned to another role or group for the same user
- Compat: Revisions - Revision Permissions assigned for specific categories did not enable editing of existing revisions
- Compat: Divi - non-Administrators could not edit new page on front end
- Compat: PublishPress Authors - invalid error message for minimum PressPermit Pro version (note: Permissions is still not fully compatible with PublishPress Authors)
- Feature: Support capabilities list_posts, list_others_posts, list_pitch_pages, etc. for inclusion in Posts / Pages listing without ability to edit
- Fixed: Permissions > Settings > Install displayed instructions for restoring a Press Permit Pro 2.6.x installation, even if none was installed (since 3.0)

[3.2.1] - 1 Jun, 2020

- Fixed: Supplemental roles were not effective on some sites
- Fixed: Menu management limitations were not applied

[3.2] - 29 May, 2020

- Fixed: Contributors could not set Featured Image in post editor
- Fixed: Permission Groups search returned only WP role group results, not any custom groups
- Fixed: custom get_terms() call with fields=slugs caused a PHP Notice on front end
- Compat: Elementor - Non-administrator could not edit draft with Elementor editor

[3.1.8] - 14 May, 2020

- Compat: PublishPress Permissions - Fatal error on post creation

[3.1.7] - 13 May, 2020

- Compat: PublishPress Revisions - Authors were enabled to edit other users' drafts
- Compat: PublishPress Revisions - Term-Specific Permissions for Revise operation were not correctly applied
- Fixed: Edit Permission Group screen - invalid Edit link displayed for currently stored Nav Menu Permissions
- Fixed: Classic Editor - Fatal error due to incorrect parameter count on preview_post_link filter

[3.1.4] - 23 Apr, 2020

- Compat: PublishPress Revisions - Support suppression of Permissions metaboxes on Edit Revision screen
- Compat: Nested Pages - Error on Nav Menu edit

[3.1.3] - 6 Apr, 2020

- Fixed: Possible fatal error loading Permissions screens on a small percentage of installations

[3.1.2] - 2 Apr, 2020

- Fixed: Limited editors with editing permissions in limited categories lost access to new post when autosave assigned inaccessible default category
- Fixed: Possible fatal error on Permissions screens on a small percentage of installations
- Compat: PublishPress Revisions - Slider on Compare Pending Revisions screen did not work for non-Editors
- Compat: Ubermenu - Enable Nav Menu filtering if Permissions > Settings > Core > Front End > Filter Menu Items is switched on
- Compat: Nested Pages - Suppress all filtering on Nested Pages listing, due to incompatible NP handling of filtered query results
- Fixed: Some informational captions for Pro functionality were applied for the wrong conditions

[3.1] - 16 Mar, 2020

- Change: Metaboxes in Post, Term editors recaptioned as "Permissions: Read this Page", "Permissions: Edit Posts in this Category" etc.
- Change: Edit Group / User Permissions - Exceptions recaptioned as "Specific Permissions"
- Change: Edit Group / User Permissions - "Also these / Not these / Only these" recaptioned as "Enable / Block / Limit to"
- Change: Edit Group / User Permissions - "Associate (as Parent)" operation recaptioned as "Set as Parent"
- Change: Edit Group / User Permissions - Operation and Adjustment selection UI uses radio buttons (for new Specific Permissions) instead of dropdown select
- Change: Edit Group / User Permissions - Operation, Adjustment and Qualification selections persist (for new Specific Permissions) until changed
- Change: Edit Group / User Permissions - Minor styling improvements
- Feature: Edit Group / User Permissions - Mirror currently stored Specific Permissions to another operation (new bulk edit action). Example: copy "Edit Page" restrictions as "Set as Parent" restrictions.
- Fixed: Edit Group / User Permissions - Bulk edit checkboxes were re-selected by browser autocomplete
- Fixed: Non-editors with editing exceptions did not see Edit link on front end Admin Bar if Classic Editor plugin active with "Allow users to switch" setting disabled
- Compat: Ubermenu - Intermittant failure to retrieve top level menu items broke front end rendering on some sites
- Compat: WP Bakery Page Builder - Editing exceptions were not effective for users lacking role capabilities
- Compat: PublishPress Revisions - If Collaborative Publishing module is not enabled, notify about need for it.

[3.0.2] - 5 Mar, 2020

- Feature: Option to apply Publish exceptions separate from Edit exceptions (Permissions > Settings > Advanced > Permissions Admin). Previously available by constant definition.
- Compat: Divi Page Builder - Non-editors with page-specific editing exceptions could not access some fields within the Divi editor
- Fixed: Import module - corrections to import of RS Category Restrictions on the Post Contributor, Post Author and Post Editor roles
- Fixed: Import module - corrections to import of Page Associate Restrictions
- Change: Import module - styling improvements

[3.0.1] - 28 Feb, 2020

- Fixed: RTL languages - PP Permissions plugin screens were offset to the right, with the Save button and/or captions out of view
- Fixed: Featured Images were not properly attached to post if they have an alt text value
- Fixed: Post editing exceptions did not grant post meta editing capabilities
- Fixed: Publish capability was not credited from assigned exceptions in some scenarios
- Compat: PublishPress Revisions 2.2.1 - if set to trigger save_post action on revision publication, do not execute normal Permissions action handlers
- Compat: Divi Page Builder - Non-editors with page-specific editing exceptions could not use Divi editor

[3.0] - 20 Feb, 2020

- Feature: Collaborative Publishing module ported from Pro edition
- Feature: Import module (for Role Scoper installations) ported from Pro edition
- Feature: On activation, detect Role Scoper installation and offer to import it
- Fixed: Javascript error when a published post is unpublished in the block editor
- Fixed: Settings screen - dropdown select items sometimes failed to display current setting due to browser autocomplete
- Fixed: Edit Permission Group - After new custom group creation, "back to groups list" linked to WP Roles list instead of Custom Groups
- Fixed: Permission Groups screen - groups corresponding to deleted WordPress roles could not be deleted
- Fixed: Post editor - Non-administrators with permission assign exceptions got no results from group / user search
- Fixed: Collaboration module - Stop filtering page parent dropdown needlessly for Administrators (caused invalid results and browser freeze under rare conditions)
- Compat: Divi Page Builder - Non-Editors could not edit new page after creating it
- Compat: Divi Page Builder - Non-Editors could not enter Divi UI
- Compat: Yoast SEO - Admin dashboard access generated two PHP warnings for database error under some configurations
- Compat: Media Library Assistant - PP Permissions were not applied on Media Library thumbnail view or Select Media tab
- Compat: Image Source Control - Newly uploaded featured image was not formally attached to post (also apply this compatibility fix if constant PRESSPERMIT_LIMIT_ASYNC_UPLOAD_FILTERING is defined)
- Change: Admin menu ordering - If PublishPress Capabilities is active, display Permissions menu below Capabilities (both under Users)
- Perf: Edit Page with Block Editor - Prevent needless core queries
- Fixed: Edit Permissions screen styling: alignment of Add Roles / Exceptions tab borders

[2.9] - 9 Jan, 2020

- Change: Renamed to PublishPress Permissions
- Compat: PublishPress Capabilities

[2.8.8] - 23 Dec, 2019

- Compat: Themes that break Gutenberg by making meta boxes steal screen space from editor
- Fixed: Avoid PHP warnings or unexpected behavior if a post is improperly stored with a zero ID

[2.8.7] - 10 Dec, 2019

- Fixed: Edit Group Permissions - Category Search on "Add Exceptions" tab did not work
- Fixed: Edit Group Permissions - when selecting groups for Group Exceptions assignment, redundant UI display (checkboxes for "All" tab not initially hidden)
- Fixed: Custom get_terms() calls: some "fields" argument values were not supported
- Fixed: PHP Notice - trying to access property term_name on a non-object, under some configurations
- Change: Accommodate larger search results set on Ajax user search
- Compat: White Dot Theme - Exceptions metaboxes on Edit Post screen had broken layout, could not search for users / groups
- Compat: TwentyTwenty theme modified alignment of PressPermit Settings columns
- Compat: JReviews plugin - PHP warning due to 'the_posts' results array being set to null under some conditions
- Compat: Project Nami - Users could not be added to groups
- Compat: Project Nami - Exceptions could not be removed

[2.8.2] - 31 Oct, 2019

- Fixed: Supplemental Media Author role - uploader stuck on "Crunching" after uploading a file, could not open it until reloading Media Library
- Fixed: Category / Term listing: after clicking Universal Exceptions link, category links led to edit screen for type-specific exceptions
- Fixed: Edit Permissions screen - when selecting Media for Exception assignment, paging did not work in the Select Media metabox
- Fixed: Edit Permissions screen - Page / Category Exceptions - fatal error on update if item "(none)" was selected with "sub-Items" checkbox selected
- Fixed: Edit Permissions screen - Improper UI handling for editing existing exceptions if Apply button is clicked twice or without any items selected
- Fixed: PHP Notice when Term Exceptions are assigned to enable access (adjustment mode "Also these")
- Change: On Permissions > Groups list, change "Group" filter link caption to "Custom Group"
- Change: Plugins screen - Put Settings link next to Activate / Deactivate (was in plugin description area)
- Change: Added PublishPress footer to plugin screens

[2.8] - 2 Oct, 2019

- Fixed: Category / Term listing: after clicking Universal Exceptions link, category links led to edit screen for type-specific exceptions
- Change: On Permissions > Groups list, change "Group" filter link to "Custom Group"
- Change: Added PublishPress footer to plugin screens

[2.7.14] - 13 Sep, 2019

- Fixed: Exceptions assigned for "All" post types and "Only these" categories blocked access to all categories
- Change: Work around unexplained class loading error on early user_has_cap filtering with CAS integration
- Fixed: Fatal error if Revisionary 1.2.x (releases older than March 2019) active
- Change: Better dismissal support for admin notices
- Change: Better sharing / separation of Core, Pro code

[2.7.13] - 21 Aug, 2019

- Fixed: If get_pages() was called with depth, child_of, and exclude_tree arguments, some pages were not properly excluded
- Fixed: PHP Notices for undefined variable if get_pages() or wp_list_pages() is called with hide_empty argument
- Change: The informational notice displayed to existing Pro users (to replace PressPermit with PressPermit Pro) is now dismissible

[2.7.12] - 6 Aug, 2019

- Fixed: Add New User screen was missing Permission Groups selection UI
- Fixed: Categories were improperly filtered when queried within a shortcode, and in other cases where get_terms() was already previously called
- Fixed: Conflict with TagDiv Cloud Library plugin (Newspaper Theme) and others that use a non-standard REST handler structure
- Fixed: Inconsistent formatting of messages below Plugins row
- Fixed: Gutenberg - Improvements to REST term filtering
- Lang: Update .po file

[2.7.11] - 17 Jul, 2019

- Change: Adjust explanation about PressPermit Pro account migration

[2.7.10] - 17 Jul, 2019

- Fixed: Supplemental Media Editor role granted Post Editor capabilities if Permissions > Settings > Core > Filtered Post Types > "Enforce distinct edit, delete capability requirements for Media" not enabled

[2.7.9] - 11 Jul, 2019

- Fixed: Users lacking read capability were blocked from viewing public posts (now apply this requirement only if constant PRESSPERMIT_STRICT_READ_CAP is defined)
- Fixed: API - undefined function pp_get_groups_for_user
- Fixed: Notice for undefined variables last_siteroles_hash, siteroles_hash
- Change: If constant PRESSPERMIT_MEDIA_IGNORE_UNREGISTERED_PARENT_TYPES defined, Media Library filtering treats media attached to a post of unregistered type as unattached

[2.7.8] - 8 Jul, 2019

- Fixed: Group roles were not applied under some configurations
- Fixed: Permissions > Settings > Installation screen always displayed "A presspermit.com key appears to be active" - even on fresh installs.
- Fixed: Eyes Only User Access Shortcode plugin - Fatal error on Edit Page screen
- Perf: Eliminated redundant role retrieval queries, processing
- Change: Adjustment to Press Permit Core migration script

[2.7.7] - 5 Jul, 2019

- Fixed: Fatal error on front end if Nav Menu includes a Category
- Fixed: Some stored exceptions were not shown on Edit Permissions screen, under some conditions
- Fixed: Gutenberg Page Parent dropdown hidden or inappropriately restricted if Read Page exceptions stored

[2.7.6] - 5 Jul, 2019

- Fixed: Eyes Only User Access Shortcode plugin - Fatal error on activation

[2.7.5] - 4 July, 2019

- Fixed: Corrections and clarifications to Pro upgrade links

[2.7.4] - 4 July, 2019

- Fixed: Fatal error on Permissions > Settings screen

[2.7.3] - 4 July, 2019

- Fixed: Error loading language file on non-English sites, servers with open_basedir restrictions
- Fixed: PHP warning for undefined variable post_blockage_priority, under some configurations
- Fixed: API - Error creating a new custom Permission Group via API function call

[2.7.2] - 27 Jun, 2019

- Fixed: Fatal error on Plugins screen on some sites

[2.7.1] - 24 Jun, 2019

- Fixed: Some wp-admin captions incorrectly identified this plugin as PressPermit Pro
- Change: Notice on Plugins screen for existing Pro installations

[2.7] - 21 Jun, 2019

- Change: This plugin no longer used with Pro extensions (replaced by PressPermit Pro)
- Change: Improved code structure using PHP namespaces
- Compat: Renamed functions, classes, globals, constants, page slugs and hooks (with back compat) to avoid conflicts with other packages
- Compat: Pro - PublishPress Custom Statuses
- Feature: Pro - Custom Privacy statuses, default/lock privacy settings implemented in Gutenberg editor
- Feature: On PressPermit Settings update, return to previous tab
- Fixed: Secondary query_posts() calls blocked results inappropriately under some configurations, due to redundant filtering of the terms query
- Fixed: Term restrictions applied for "all post types" could not be overridden by exceptions on a different taxonomy
- Perf: Redundant filtering of terms query within WP_Query calls
- Change: CSS improvements in Permissions > Settings

[2.6.1] - 22 Feb, 2019

- Fixed: PHP Notice on Plugins > Add New

[2.6] - 21 Feb, 2019

- Compat: WP 5.0 - extension change logs were not displayed
- Fixed: Extension updates on wp-admin Plugins screen did not launch in iframe
- Change: Update copyrights, contributors for PublishPress ownership
- Change: Purchase / renewal prompt captions and styling
- Change: Update support links and captions for help ticket infrastructure
- Change: Minimum WordPress version 4.7

[2.5.5] - 21 Jan, 2019

- Fixed: On Edit Page screen, Groups and Users could not be selected for exceptions if WP_DEBUG was defined

[2.5.4] - 6 Dec, 2018

- Fixed: Pro - Excessive update checks on Plugins screen if any Pro extensions are installed but inactive
- Fixed: Pro - Restrictive exceptions assigned directly to a post did not override direct-assigned enabling exceptions, even when PP_RESTRICTION_PRIORITY defined

[2.5.3] - 4 Dec, 2018

- Fixed: PHP warning on third party calls to get_terms() with an invalid taxonomies argument
- Fixed: PHP warning on Permissions > Settings > Install when new Press Permit Core version is available

[2.5.2] - 28 Nov, 2018

- Fixed: On the Edit Page form, clearing a "Sub-Pages" exception did not delete propagated exceptions from the subpages
- Fixed: Quick Edit did not allow private and draft pages to be assigned or retained as parent (since 2.4.2)
- Fixed: Inability to delete exceptions which were assigned to a user before they become an Administrator (though those exceptions were correctly disregarded)

[2.5.1] - 9 Nov, 2018

- Fixed: In Exceptions metaboxes on the Edit Page screen, when a user or group is selected, their "Enabled / Blocked" dropdown was displayed without an identifying label (since 2.5)
- Change: Pro - Allow the {All} and {Anon} metagroups to be granted Reading Exceptions for specific media items
- Change: Converted external links to https

[2.5] - 28 Sep, 2018

- Compat: PHP 7.2 - Eliminated create_function calls
- Change: WP coding standards - eliminated extract function
- Change: WP coding standards - php open / close tag placement

[2.4.5] - 21 Aug, 2018

- Fixed: Gutenberg - post update failure
- Fixed: Gutenberg - restrictive category reading exceptions caused white screen on post creation by restricted author
- Fixed: Wrong items count on wp-admin Users screen if redundant usermeta records are stored
- Fixed: PP_GET_PAGES_LEGACY_FILTER did not fully restore previous get_pages() filtering
- Change: Restore default get_pages() filtering of Page Parent dropdown in wp-admin for Administrators, unless PP_GET_PAGES_LIMIT_ADMIN_FILTERING is defined;

[2.4.4] - 14 Jun, 2018

- Fixed: Page Association exceptions were not applied to parent selection dropdown on Edit Page screen (since 2.4.2)
- Fixed: Pro - PHP warnings for PP extensions on Plugins, WordPress Updates screens
- Fixed: PHP warnings in wp-admin

[2.4.3] - 3 May, 2018

- Fixed: Pro - Invalid update links and PHP warnings for PP extensions on Plugins, WordPress Updates screens

[2.4.2] - 2 May, 2018

- Fixed: After a WP role is deleted, the corresponding permission group remained. These can now be manually deleted.
- Change: Increase limit for number of quick search results in post selection boxes on Edit Group Permissions screen
- Fixed: "Add Exceptions" dropdowns on Edit Group Permissions screen failed to load on some installations with a server-imposed limit on simultaneous queries
- Fixed: Groups table not created early enough on some multisite installations when third party code triggers early set_current_user action
- Compat: get_pages() calls by plugins / themes in wp-admin() may be filtered incorrectly when sort_column is menu_order (for previous behavior, define constant PP_GET_PAGES_LEGACY_ADMIN_FILTER)

[2.4.1] - 13 Dec, 2017

- Fixed: Edit Permissions screen: javascript error on Safari browser
- Fixed: PHP Notice if a serialized PP settings array stored in wp_options table is corrupted
- Fixed: Compat - PHP Notice for undefined index in pp_find-post-type.php, with some third party plugins
- Fixed: PHP Notice in Permissions > Settings

[2.4] - 14 Nov, 2017

- Feature: Collapsible page selection tree on Edit Permissions screen, defaults visible depth toward a target of 50 visible pages (or as defined by PP_ITEM_MENU_DEFAULT_MAX_VISIBLE constant)
- Feature: Edit Permissions screen: "Clear All" link on selection review list after selecting post / term exceptions
- Change: Scheduled posts are not included in blogroll, even if logged user can edit them. For previous behavior, define constant PP_FUTURE_POSTS_BLOGROLL.
- Perf: Eliminated excessive page queries on Edit Pages screen
- Perf: Reduced html output and database queries on Edit Group Permissions / Edit User Permissions screen
- Perf: Improved database query construction and api behavior when inserting propagating exceptions on a page tree (for previous method, define constant PP_DISABLE_OPTIMIZED_INSERTIONS)
- Fixed: Do not auto-delete role metagroups even if stored roles are no longer active. Otherwise, omission of role registration by 3rd party code triggers unwanted metagroup regeneration, causing stored permissions to be disassociated from users.
- Fixed: Users whose role metagroup was inappropriately deleted are automatically restored on login or when included in wp-admin Users listing
- Fixed: Fatal error for undefined function if presspermit_get_group() is called without first calling presspermit_load_admin_api()
- Fixed: Incorrect REST response under some conditions if PP Collaborative Editing (Pro) not activated
- Fixed: Edit Post screen: stored post exceptions were not displayed in Exceptions metaboxes on some installations
- Fixed: If a post has exceptions assigned directly to a user, all of its group-assigned "Only these" exceptions are cleared on post update
- Fixed: If PP Exceptions metaboxes are re-ordered on the Edit Post screen, they become permanently hidden on the Edit Categories screen
- Fixed: Multisite - Exceptions were not displayed in custom column on Terms screen
- Fixed: Comment count in admin bar was not properly filtered for logged non-Administrators on the front end
- Fixed: Comments total on admin bar was not filtered
- Fixed: Pro - Eliminate unintended (and ineffective) BuddyPress group membership checkboxes on Edit User screen
- Fixed: If constant PP_GROUP_RESTRICTIONS was defined and later removed, stored restrictions ("Not these" / "Blocked" exceptions) were still applied
- Fixed: If constant PP_ALL_ANON_ROLES was defined and later removed, stored supplemental roles for {All} or {Anonymous} group were still applied
- Fixed: Constant definitions PP_NO_POST_EXCEPTIONS, PP_NO_PAGE_EXCEPTIONS, etc. were not consistently applied
- Fixed: Responsive styling on Permissions > Settings
- Fixed: PHP Notice for non-static function act_sync_wproles
- Fixed: Pro - PHP 7 compat: PP configuration upload
- Change: Pro - Always include PHP error log in PP configuration uploads
- Change: Support constant PP_ITEM_MENU_PER_PAGE to adjust paging behavior of post selection metabox on Edit Permissions screen
- Change: Support constant PP_ITEM_MENU_HIERARCHICAL_PER_PAGE to adjust paging behavior of post selection metabox on Edit Permissions screen
- Change: If any PP constants are defined, display them (and available related constants) on Permissions > Settings > Advanced
- Doc: Updated dates in several files
- Lang: Updated .pot file

[2.3.21] - 11 Aug, 2017

- Fixed: PHP Notice on some installations (trying to get property of non-object in groups-retrieval_pp.php)

[2.3.20] - 20 Jul, 2017

- Fixed: REST comments retrieval by non-Administrator returned empty if PP Collaborative Editing Pack not activated
- Fixed: Exceptions and supplemental roles associated with WP role permission group were not applied if pp_group_members table out of sync

[2.3.19] - 16 Jun, 2017

- Fixed: Authors could not preview their own scheduled posts
- Fixed: Database error for duplicate primary key values in table pp_group_members
- Compat: WP 4.8 - Uppermost Update button on Edit Category screen was ineffective

[2.3.18] - 24 Mar, 2017

- Fixed: PHP Warning on Terms Listing screen
- Compat: Pro - bump PP BuddyPress Role Groups minimum version to 2.1.5 to prevent fatal error on BP Groups screen
- Fixed: Pro, multisite - PHP warning on login screen if PP Compatibility plugin active but netwide permission groups disabled

[2.3.17] - 17 Mar, 2017

- Compat: PHP 7.1 - warning for "expected to be a reference, value given" when PP Collaborative Editing Pack is active
- Feature: Link in Users table header to list only users who have no group membership
- Feature: On Users screen, if "no group" / "has role" / "has exceptions" filter is active, set link bold and black
- Fixed: Improved Formatting on PP plugin screens

[2.3.16] - 19 Dec, 2016

- Fixed: Fatal error on some installations (cannot use $this as parameter)

[2.3.15] - 15 Dec, 2016

- Fixed: Exceptions were not shown in custom column on Pages screen
- Fixed: Pro - Page editing access did not grant Media Library access for attached files (site-wide capabilities or a supplemental Media role was also required)
- Fixed: Pro - Media files editable to a limited user based on parent page access could not be updated (also requires PP Collaborative Editing 2.3.13)

[2.3.14] - 7 Dec, 2016

- Compat: WP 4.7 - Fatal error when nav menu includes a category / term
- Compat: WP 4.7 (Pro) - Fatal error when term-restricted non-Administrator saves a post
- Compat: WP 4.7 - PHP Warnings in wp-admin
- Compat: WP 4.7 (Pro) - Term assignment exceptions were not applied to new 'assign_term' capability check (also requires PP Collaborative Editing 2.3.9)
- Fixed: Term exceptions were not shown in custom column on Categories / Terms screen

[2.3.13] - 17 Jul, 2016

- Fixed: _trashed suffix was added to post slug inappropriately under some conditions
- Fixed: Pro - Invalid page parent filtering if PPCE deactivated after page association exceptions were assigned

[2.3.12] - 15 Jun, 2016

- Fixed: _trashed suffix was added to post slug inappropriately following Menu editing (and possibly other wp-admin actions)
- Compat: CMS Tree Page View - Avoid page listing error due to non-standard 'get_pages' filter application by CMSTPV

[2.3.11] - 9 May, 2016

- Perf: Simplify query clauses that ensure non-blockage of unfiltered post types for anonymous viewer
- Fixed: Pro - Don't propagate bbPress exceptions to topics and replies needlessly
- Change: Pro - Better formatting for license key status UI
- Change: Move most hardcoded style rules in plugin admin to CSS

[2.3.10] - 28 Apr, 2016

- Fixed: On sites that have third party code assigning page parents with a different post type, saving exceptions for "page and sub-pages" causes the storage of unused exception records.  This has no functional effect, but presented a performance issue or even script timeout on sites that have thousands of page children.
- Compat: WPML (and possibly other plugins) - if PP filtering of a post type is disabled, posts of that type are not readable to anonymous users
- Pro: Permissions > Settings > Install now displays link to presspermit.com account page for display of license key(s) and activated site(s)

[2.3.9] - 12 Apr, 2016

- Compat: WP 4.5 - Exception metaboxes on Edit Term screen were missing
- Compat: WP 4.5 - Term / Post selection boxes on Edit Permissions screens were missing bottom padding
- Compat: PHP 7 - Eliminated notices for constructors, static function calls and array to string conversion
- Feature: Groups column on Users screen is now sortable
- Fixed: With constant PP_ALL_ANON_FULL_EXCEPTIONS defined, Reading Exceptions granted to Anonymous metagroup for private posts were ineffective
- Fixed: When a subpage was edited by a user blocked who cannot modify page parent due to an "Only these - none" association exception, the page was set to top level if Permissions > Settings > Editing > Page Structure set to "no parent filter" or "Page Authors, Editors and Administrators".  This can now be prevented by assigning "Not these - none" association exception.
- Fixed: Pro - Authors could not edit their own draft posts via REST API v2
- Change: Support constant PP_UNFILTERED_TERM_COUNTS
- Change: Pro - Refresh link in license key entry / status UI

[2.3.8] - 18 Jan, 2016

- Fixed: "Only these" exceptions set for a post type based on term/category causes the Edit Post form to default-assign the corresponding exception directly to posts of the same ID.  If the exception is based on term "(none)", the exception is default-assigned to all new posts.  NOTE: Affected posts will need to be manually edited.

[2.3.7] - 7 Jan, 2016

- Fixed: Truncated Plugins listing if PP license key is inactive or expired (since 2.3.5)

[2.3.6] - 7 Jan, 2016

- Fixed: Pro - extension installs and updates failed (since 2.3.5)

[2.3.5] - 6 Jan, 2016

- Lang: Some strings were missing text domain
- Lang: Updated .pot, .po files
- Fixed: Pro - Change log for extensions was not displayed under some conditions
- Change: License key availability, expiration notices for PP Core in Plugins row

[2.3.4] - 4 Jan, 2016

- Fixed: Fatal error on user registration

[2.3.3] - 21 Dec, 2015

- Fixed: WP 4.4 - On Users screen, UI to bulk add/remove permission group membership was non-functional

[2.3.2] - 18 Dec, 2015

- Fixed: Additional permissions error (since 2.3.1)

[2.3.1] - 18 Dec, 2015

- Fixed: Not Found error on front end for all Subscribers and anonymous viewers (since 2.3)

[2.3] - 18 Dec, 2015

- Feature: REST v2 support for filtering of Posts and Terms
- Fixed: WP 4.4 - Private pages were excluded from page uri hierarchy, caused invalid link display on Edit Page screen and Pages listing
- Change: Supplemental Roles and Exceptions can be cloned to custom Permissions Groups
- Change: Pro - Allow disable of "Hide non-editable posts" setting if constant PP_ADMIN_READONLY_LISTABLE is defined
- Change: Support constant definition PP_DISABLE_NAV_MENU_FILTER
- Change: Support constant definition PP_GET_PAGES_PRIORITY for later filter application in case of interference by third parties
- Feature: Pro - Support pp_manage_own_groups capability (also requires PP Collaborative Editing 2.2.3)
- Fixed: Pro - Non-editable groups were included in Permission Groups list for non-Administrators with group management exceptions
- Fixed: Pro - Group management exceptions did not allow non-administrators to bulk add/remove group membership
- Fixed: Pro - On networked sites with network groups enabled, member network groups were listed twice on Groups column of site 1 Users screen
- Fixed: Pro - On networked sites with network groups enabled, site-specific permission group membership was not editable on Edit User screen of secondary sites
- Fixed: More consistent application of group and member management capabilities for non-Administrators

[2.2.8] - 20 Nov, 2015

- Compat: Advanced Custom Fields and WPML - ACF metaboxes were not displayed on Edit Post screen if translation was enabled for fields
- Change: Streamlined Bulk Groups UI on Users screen (single groups dropdown for Add/Remove)
- Change: Added an option on Advanced tab to disable Bulk Groups dropdown on Users screen
- Change: Don't display Bulk Groups dropdown if no groups are defined
- Fixed: Removed extra top margin in Permission Groups box on Edit User screen
- Lang: Updated .po file

[2.2.7] - 6 Nov, 2015

- Fixed: On Network installations, PP User Search returned no results unless a user meta search was also specified (since 2.2.5)

[2.2.6] - 5 Nov, 2015

- Fixed: On Edit Page screen, User and Groups searches yielded no results if PP Collaborative Editing extension was inactive (since 2.2.5)
- Fixed: On Edit Page screen, User and Groups search UI had results box and search button too narrow (since 2.2.5)
- Fixed: Extra gap in Permissions menu when accessing Edit Group/User Permissions screen
- Change: If custom fields are not defined for user_meta search, UI provides a maximum of three key/value inputs
- Change: User_meta search input box title attribute mentions the PP_USER_SEARCH_META_FIELDS constant (for logged Administrators if "Display hints" and "Advanced" settings are enabled)

[2.2.5] - 3 Nov, 2015

- Feature: Bulk Add / Remove permission groups on Edit Users screen
- Feature: In PP UI, search for users by First Name / Last Name / Nickname
- Feature: In PP UI, search for users by any string/numeric/boolean  field specified in constant PP_USER_SEARCH_META_FIELDS (comma separation for multiple user_meta keys)
- Feature: constant PP_USER_SEARCH_NUMERIC_FIELDS causes corresponding user_meta search entries to be cast to numeric
- Feature: constant PP_USER_SEARCH_BOOLEAN_FIELDS causes corresponding user_meta search entries to be cast to boolean
- Feature: constant PP_USER_SEARCH_FIELD specifies a usermeta field to apply main user search box to (deprecates constant PP_USER_LASTNAME_SEARCH)
- Change: When constant PP_USER_SEARCH_FIELD or PP_USER_LASTNAME_SEARCH is defined, Find User caption above search box reflects this
- Change: If constant PP_USER_RESULTS_DISPLAY_NAME is defined, set user_login as title attribute for hover display
- Change: Reading Exceptions metabox on Edit Post/Page screen does not indicate default access (Yes/No) for WP roles until post is published
- Perf: Eliminated some redundant javascript output

[2.2.4] - 28 Sep, 2015

- Fixed: PHP Notice for missing action argument broke some Ajax responses
- Change: Support constant PP_RESTRICTION_PRIORITY to force "Not these" exceptions to take priority over "Also these" exceptions

[2.2.3] - 28 Sep, 2015

- Fixed: PHP Notice when a user's role is changed
- Change: Support constant PP_UNFILTERED_FRONT to disable read access filtering
- Change: Support constant PP_UNFILTERED_FRONT_TYPES to specify which (comma-separated) post types should have read access filtering disabled
- Change: When PP_UNFILTERED_FRONT is defined, also support filters pp_skip_filtering and pp_skip_cap_filtering to allow third party identification of queries which should not be filtered

[2.2.2] - 25 Aug, 2015

- Fixed: Improved formatting on Edit Permission Groups screen
- Fixed: Pro - Membership editing UI was displayed inappropriatedly on Permission Group screen for BuddyPress Groups
- Fixed: Pro - PHP Warnings on configuration upload under some conditions

[2.2.1] - 3 Jul, 2015

- Fixed: Pro - Extensions could not be updated
- Fixed: Pro - On WP 4.2, extensions were deactivated following update

[2.2] - 2 Jul, 2015

- Fixed: If a specific user has a set of "Only these" exceptions assigned, the Edit Post/Page screen did not correctly handle new exception assignments for that user
- Fixed: PP key could not be deactivated after expiration
- Fixed: If PP_USER_RESULTS_DISPLAY_NAME is defined, user_login was still displayed for selected / stored exceptions
- Fixed: If PP_USER_LASTNAME_SEARCH is defined, partial searches (entering a portion of the last name) did not work
- Fixed: Database error when the Edit Post/Page screen was used to add a new user-specific exception
- Fixed: PHP Warning for undefined "action" argument when accessing wp-admin
- Perf: Don't load dashboard-specific code on Ajax or direct file access calls (if PP Collaborative Editing is inactive or >[,2.
- Perf: Fixed slow query (exceptions count) on Edit Permission Groups screen

[2.1.57] - 22 Apr, 2015

- Fixed: Pro - If Network Groups or BuddyPress Groups had limiting "Only these" exceptions set, those exceptions were not displayed properly in the Edit Page metaboxes and could be lost on page update
- Fixed: PHP Strict Warning when retrieving exceptions under some configurations

[2.1.56] - 21 Apr, 2015

- Fixed: "Add New" button was missing from top of Permissions Groups screen
- Fixed: Relative URL in wp_http_referer argument may prevent redirect failure on some servers following permission group creation
- Fixed: Harden security within wp-admin (mirroring WP 4.1.1 changes)
- Change: Editing exceptions on parent post also allows deletion of attachment if constant PP_EDIT_EXCEPTIONS_ALLOW_DELETION or PP_EDIT_EXCEPTIONS_ALLOW_ATTACHMENT_DELETION is defined
- Change: Search users by last name if constant PP_USER_LASTNAME_SEARCH is defined
- Change: Display user search results by display name if constant PP_USER_RESULTS_DISPLAY_NAME is defined
- Chagne: If a custom WP_Query call passes in a required_operation argument, don't override it

[2.1.55] - 17 Mar, 2015

- Fixed: Permission Groups management screen failed with fatal error / white screen on WP 3.9.x and previous (since 2.1.52)
- Change: Editing exceptions also allow deletion if constant PP_EDIT_EXCEPTIONS_ALLOW_DELETION is defined
- Change: Editing exceptions also allow deletion for specified post type if constant PP_EDIT_EXCEPTIONS_ALLOW_PAGE_DELETION, PP_EDIT_EXCEPTIONS_ALLOW_ATTACHMENT_DELETION, etc. is defined

[2.1.54] - 21 Feb, 2015

- Fixed: PP tabs in wp-admin broke if a third party plugin added classes to their links
- Feature: Support filtering of WP Users listing by PP group, by appending pp_group argument to URL
- Compat: Wiki plugin - white screen on non-Administrator access of wp-admin Wikis screen

[2.1.53] - 4 Feb, 2015

- Compat: Visual Composer - invalid display of VC "add element" UI on Edit Term screen

[2.1.52] - 3 Feb, 2015

- Compat: The Events Calendar - Ajax refresh of calendar did not display events to subscribers or anonymous viewers
- Compat: Visual Composer - invalid display of VC metabox on Edit Term screen
- Change (Pro): Refresh license key data to more promptly display expiration status
- Fixed: White screen after cloning permissions from one role group to another
- Fixed: PHP warning for deprecated function call on Permissions > Groups screen

[2.1.51] - 9 Jan, 2015

- Compat: Google Analytics by Yoast - PP filtering was disabled due to GA loading user prior to init action
- Compat: WP Cron Control - PP filtering was disabled due to WPCC setting constant DOING_CRON universally
- Compat: Events Manager - PHP Warning on Event Tags, Event Categories screen under some configurations
- Compat: Kriesi Enfold theme - More Posts query failed
- Fixed: Incorrect user count for WP role groups on Permissions > Groups screen

[2.1.50] - 5 Jan, 2015

- Fixed: Pro: Media Items were not properly filtered in grid view
- Fixed: Errors on Add Supplemental Role UI if standard WP role definition are deleted
- Fixed: Pro: Expired license key caused incorrect display of Activation UI
- Fixed: Fatal Error when calling some PP API functions from front end
- Fixed: Fatal Error for redeclared class SQLTokenizer on some installations
- Compat: JSON REST API - filtering of calls does not match typical API usage (now not filtered at all unless PP_FILTER_JSON_REST constant defined)

[2.1.49] - 13 Nov, 2014

- Fixed: With "Post-assigned Exceptions take priority" setting active, post-specific enables did not override post-specific blockages
- Fixed: With Network-wide groups enabled, exceptions stored (with network-wide previously disabled) to regular main site groups were still applied (though not displayed on Edit Group Permissions screen)
- Fixed: Users with "Only These" editing exceptions for specified pages could delete those pages for editing access to other pages.  Trash/deletion is now blocked unless user also has an "Also these" exception for the page.
- Fixed: PHP warnings for "implode(): Invalid arguments" on various wp-admin screens
- Fixed: Some non-Apache servers had "Fatal error: Object of class stdClass could not be converted to string" on Edit User and Edit Permission Groups screens
- Fixed: Edit User screen did not display Network Groups checkboxes under some configurations
- Change: Post / term selection UI on Edit Permission Group screen now default to 100 items per page, and can be customized via PP_ITEM_MENU_PER_PAGE constant definition.
- Compat: To resolve numerous Ajax conflicts, don't require editing permissions by default. New filter 'pp_ajax_edit_actions' replaces 'pp_ajax_read_actions'.
- Compat: Ozh Admin Menus: caption PP Settings submenu (in Settings menu) more descriptively
- API: New filter 'pp_ajax_edit_actions' to require editing permissions for specific Ajax actions.
- Fixed: Edit Permissions UI did not obey PP_ALL_ANON_FULL_EXCEPTIONS constant, limiting assignments to the "{All}" and "{Anon}" groups
- Fixed: PHP warnings on Permissions > Settings > Install screen when key is not activated

[2.1.48] - 29 Sep, 2014

- Fixed: Post-specific restrictions were not applied correctly if PP setting "Post-assigned Exceptions take priority" enabled
- Fixed: Nuisance notification of "Post-assigned Exceptions take priority" setting on new installations

[2.1.47] - 4 Sep, 2014

- Feature: Option to change exceptions handling to make post-specific blockages take priority over term-specific additions
- Fixed: Media Upload by non-Editors stalled on "crunching" under some configurations
- Fixed: Edit User Permissions screen labeled group Exceptions box as "Supplemental Roles"
- Fixed: License key expiration message was displayed incorrectly in some situations

[2.1.46] - 24 July, 2014

- Feature: Option to keep non-editable posts visible in wp-admin (only if PP Collaborative Editing pack is NOT active).
- Compat: Co-Authors Plus - basic compatibility if "hide uneditable posts" setting is disabled
- Compat: Co-Authors Plus - compatibility with PP Pro extensions
- Compat: Tribe Events Calendar - read access filtering for ajax-loaded displays
- Fixed: Network Groups were not updated correctly from Edit User screen (Pro)
- Fixed: Term Management and Association exceptions were not propagated to new sub-terms
- Fixed: Edit Terms screen did not properly label "only these" exceptions for term Management or Association, cleared them on term update
- Fixed: Terms list for Universal Exceptions generated invalid link for term edit
- Fixed: Custom columns in terms listing for Universal Exceptions did not include term Management or Association exceptions

[2.1.45] - 11 June, 2014

- Compat: verified WP 3.9.1 compatibility
- Feature: New setting on Advanced tab to force Administrators to see all pages, even if blocked from the "All" or "Authenticated" groups.
- Fixed: Unexpected behavior when a parent category/term has no posts
- Fixed: When "Only these" exceptions are assigned for categories/terms, ignore them if user lacks corresponding site-wide role/capability
- Fixed: Prev / Next links were not properly filtered on some installations
- Compat: Slim Jetpack Infinite Scroll (and new filter 'pp_ajax_read_actions' to specify other read-only ajax queries)
- Compat: WP Document Revisions - read_document capability check was not handled correctly
- Compat: Work around plugins that create a role with no capabilities array
- Change: Support constant definition PP_NAV_MENU_SHOW_EMPTY_TERMS
- Change: Apply PP_NO_COMMENT_FILTERING constant even if user has moderate_comments capability
- Change: Attempted workaround for intermittent failure to propagate exceptions to subpages
- Lang: Added Brazilian Portuguese translation (by Doppos)

[2.1.44] - 26 Feb, 2014

- Fixed: With PP Compatibility extension enabled on Multisite and network-wide groups enabled, fatal error when clicking "Add New" link at top of Groups screen
- Change: Allow "Also These" / "Enabled" exceptions to be assigned to {All} and {Anonymous} groups if constant PP_ALL_ANON_FULL_EXCEPTIONS is defined
- Fixed: PHP warning when third party plugin causes an object to be passed into presspermitSanitizeKey()

[2.1.43] - 4 Feb, 2014

- Fixed: Posts inappropriately hidden from anonymous users on some installations
- Compat: The Events Calendar Pro - Ajax calendar refresh returned no entries

[2.1.42] - 24 Jan, 2014

- Compat: PP Content Teaser - Teaser was not applied for posts listing when universal category exceptions are active
- Compat: PP Content Teaser - Teaser was not applied for single post display under some configurations

[2.1.41] - 23 Jan, 2014

- Fixed: Read access to Media was blocked unexpectedly under some configurations

[2.1.40] - 17 Jan, 2014

- Compat: Slidedeck - Slides made by a direct media upload were not displayed correctly
- Compat: Slidedeck - Iframe and RESS decks conflict with Press Permit; temporary workaround overrides those options
- Compat: CMS Tree Page View - Pages editable based on exceptions were not displayed if they have an uneditable parent (also requires PP Compatibility Pack 2.1.11)

[2.1.39] - 9 Jan, 2014

- Fixed: Editing permissions were not propagated to newly created pages under some configurations on WP 3.8 (also requires PP Collaborative Editing 2.1.18)
- Fixed: User search ajax submission with blank search box returned users by creation date with oldest first (should be newest first)
- Fixed: Work around PHP Bug #52339 - SPL autoloader breaks class_exists()
- Fixed: PHP Notices on when updating extension plugins with strict error reporting

[2.1.38] - 18 Dec, 2013

- Compat: WP 3.8 - styling corrections on Edit Permissions, Settings screens
- Fixed: Post access blocked per-Role by a Universal Taxonomy Exception could not be enabled per-user or per-group by another Universal Taxonomy Exception
- Fixed: When a page is re-saved to a different parent, exceptions propagated to subpages from the previous parent were not cleared
- Fixed: When a page is re-saved to a different parent, exceptions from the new parent were not assigned to subpages
- Fixed: Pro - Customization of role capabilities for stock WP roles was not reflected in supplemental role assignment (since 2.1.33)
- Fixed: Pro - Editing exceptions remained partially active even if corresponding pro extensions disabled
- Feature: Pro - Support list_all_posts, list_all_pages, etc. capabilities (also requires PP Collaborative Editing 2.1.16)
- Change: Additional explanatory captions on Edit Permissions screen
- Change: Link on Edit Permissions screen to reload with propagated exceptions displayed
- Fixed: PHP Notices for non-static function definitions

[2.1.37] - 14 Dec, 2013

- Fixed: Pro - Assignment of Tags and other hierarchical taxonomies was not filtered based on "Only these" or "Not these" exceptions (also requires PP Collaborative Editing 2.1.15)
- Fixed: PHP warning when uploading configuration data from a network installation
- Doc: Corrected code comment for exceptions array in pp-user.php

[2.1.36] - 11 Dec, 2013

- Fixed: After saving changes to Universal Category Exceptions, redirect was back to Edit Category (Post Exceptions)
- Change: Edit Category screen - additional inline note regarding Universal Category Exceptions
- Fixed: Pro - Nav Menu Management exceptions were not not applied correctly in some configurations (also requires PP Collaborative Editing 2.1.14)
- Fixed: Pro - Term Management and Association exceptions assigned via Edit Category screen were not stored correctly (also requires PP Collaborative Editing 2.1.14)
- Fixed: Pro - Editors excluded from managing specific categories could still edit them via direct URL
- Fixed: Pro - On Edit Category screen, exceptions metabox for term management was incorrectly captioned as "Post Management"
- Change: Pro - On Edit Permissions screen, simplify captioning for currently stored term management and association exceptions

[2.1.35] - 6 Dec, 2013

- Fixed: When a Page exception was changed from "also subpages" to "selected only", subpage exceptions were retained but became inaccessable on Edit User/Group screen
- DB: Update to 2.1.35 exposes propagated exceptions whose base exception is deleted or no longer marked for propagation (and logs them to option ppc_exposed_eitem_orphans)
- Fixed: Page exceptions were propagated to attachments
- DB: Update to 2.1.35 deletes invalid / redundant attachment exceptions
- DB: Update to 2.1.35 exposes propagated attachment Edit Attachment exceptions
- DB: Update to 2.1.35 exposes propagated attachment "Read Attachment - Only These" exceptions

[2.1.34] - 2 Dec, 2013

- Fixed: With PP File URL Filter active, attachments to private posts were not visible unless user had editing capabilities (since 2.1.30)

[2.1.33] - 15 Nov, 2013

- Fixed: Improper filtering of get_tags() function
- Change: By default, Post Tag is enabled as a filtered taxonomy. Previously, it was default disabled yet front end tag filtering was implicitly forced.
- Change: If PP_GROUP_RESTRICTIONS constant is defined, allow the Editing Exceptions metabox on Edit Post screen to block Groups
- Change: If PP File URL Filter is not active, Reading Exceptions metabox on Edit Media screen displays notice about direct file access
- Change: Display warning if a supplemental role assignment will use default capabilities due to invalid customization of the role definition
- Change: Include PP Group Membership in Permissions > Settings > Help > configuration data upload by default
- Fixed: Database error if external code calls presspermit_get_groups_for_user() with a metagroup_type argument
- Fixed: Fatal error on Permissions > Settings > Help > configuration data upload if RS/PP import data enabled and PP Import version number was deleted from database

[2.1.32] - 8 Nov, 2013

- Fixed: Exceptions could not be assigned on Edit Post screen if post type name contains a dash
- Change: If PP_GROUP_RESTRICTIONS constant is defined, allow Post editing Exceptions with "Not these" or "Only these" adjustment to be assigned to custom groups
- Change: Revised extension installation/update code to more closely mirror the core WP process; may resolve some rare installation errors

[2.1.31] - 30 Oct, 2013

- Fixed: Terms were not included in get_terms() output based on user's access to private posts (since 2.1.28)

[2.1.30] - 29 Oct, 2013

- Compat: WP 3.7 - Non-administrators could not access revisions viewer for unpublished posts
- Compat: WP 3.7 - PHP warnings for undefined capability properties
- Fixed: wp_list_pages() was not filtered if arguments included nonzero child_of and depth=1 arguments

[2.1.29] - 25 Oct, 2013

- Fixed: CMS Tree Page View - could not expand page tree (since 2.1.28)

[2.1.28] - 24 Oct, 2013

- Fixed: Propagating Category Exceptions were not correctly assigned to subcategories
- Fixed: Universal Category Exceptions (for all post types) were not applied correctly in some configurations
- Fixed: Category widget (and other get_terms output) was inconsistent with post reading access in some configurations
- Compat: JC Submenu and other plugin / theme code which requires get_pages() or get_terms() to order subpages or subcategories immediately after their parent
- Fixed: Post types not enabled for PP Filtering were stripped out of Nav Menus on the front end

[2.1.27] - 23 Oct, 2013

- Fixed: Nav Menu items (front end display) were not filtered

[2.1.26] - 22 Oct, 2013

- Change: Allow page reading exceptions to be assigned for the All or Anonymous metagroup, but display a warning regarding best practice

[2.1.25] - 22 Oct, 2013

- Feature: Filter WP image galleries based on attachment reading exceptions
- Feature: Remove unreadable posts from Nav Menus (previously required PP Collaborative Editing extension)
- Fixed: Permission Groups was inappropriately displayed as an available Post Type when on "Add Exceptions" tab of Edit Permissions screen
- Compat: Advanced Custom Fields - don't filter ajax queries
- API: New filter 'pp_exception_type' for use in applying exceptions to externally defined data sources

[2.1.24] - 15 Oct, 2013

- Compat: Eyes Only User Access Shortcode (requires v 1.6)
- Change: Allow post reading exceptions to be assigned for the All or Anonymous metagroup, but display a warning regarding best practice
- Fixed: Cannot add Permission Group membership via Edit User screen if that membership was previously expired by a PP Membership date limit but PP Membership plugin is now inactive

[2.1.23] - 28 Sep, 2013

- Fixed: Category/Term exceptions to grant additional access did not affect term listings if parent term was inaccessible
- Fixed: Add Exceptions UI on Edit Permissions screen inappropriately included "n/a" as a Post Type under some conditions
- Fixed: Several PHP Strict Notices, mostly for non-static functions

[2.1.22] - 25 Sep, 2013

- Feature: Bulk-assign roles or exceptions to multiple users (link on Permissions > Users screen)
- Fixed: Terms were not included in get_terms() output based on user's access to private posts if terms counts are not shown, or if taxonomy is hierarchical and there are no subterms
- Fixed: IE styling error on Edit Permissions screen
- Lang: Added .pot file
- Lang: Updated .po file

[2.1.21] - 23 Sep, 2013

- Fixed: Plugins screen indicated update available for Press Permit Core even if current version was installed
- Fixed: Automatic update for PP Core was not available from Plugins screen (though version update was flagged and could be installed from the plugin info popup or WordPress Updates screen)
- Fixed: Non-functional "update now" link for PP Core on Permissions > Settings > Install screen (though plugin could be updated through version details popup)

[2.1.20] - 20 Sep, 2013

- Fixed: Could not update plugin from Plugins screen without license key activation (although updates were available from Permissions > Settings > Install since 2.1.15)
- Change: Get PP Core updates from wordpress.org

[2.1.19] - 20 Sep, 2013

- Fixed: Exceptions metaboxes on Term Edit screen was not sized correctly
- Fixed: If exceptions were deleted on Edit Permissions screen, corresponding post/term edit links remained displayed
- Fixed: Prevent display of roles / exceptions stored for a custom status if associated extension plugins are inactive
- Compat: All in One Event Calendar - non-Administrators could not navigate or filter calendar
- API: New filters 'pp_ajax_post_types' and 'pp_ajax_required_operation' for disambiguation of third party Ajax queries
- Compat: Shopp and other plugins which call $wp_query->get_queried_object manually caused hierarchical post types to be filtered correctly
- Compat: bbPress (when PP Collaborative Editing and PP Compatibility extensions activated)
- Change: On Settings > Install, restore previous layout for extensions lists
- Lang: updated .po file

[2.1.18] - 18 Sep, 2013

- Fixed: PP filtering of taxonomies could not be enabled/disabled on Permissions > Settings > Core, if PP Collaborative Editing extension not activated
- Feature: Permissions > Settings > Advanced > Anonymous Users > "Disable all filtering for anonymous users"
- Change: Support PP_ALLOW_UNFILTERED_FRONT constant. When a logged user has pp_unfiltered capability, suppresses the front-end filtering which normally adds readable private posts to get_pages listing, post count, etc.
- Change: Add error message string related to new PP Pro 3-site package
- Change: Improved layout of License key and Extensions sections on Permissions > Settings > Install
- Change: Improved layout of PP Capabilities section on Permissions > Settings > Advanced
- Change: Added margin between change log entries!

[2.1.17] - 17 Sep, 2013

- Fixed: On Edit Post screen, stored exceptions could not be changed from Enabled to Blocked (or vice versa) without first saving to default
- Change: Better styling for scrollbars in exception metaboxes on Edit Post screen
- Fixed: Email notification for comments was blocked under some configurations
- Fixed: User search - prefixing user search entry with a space did not cause results to be listed alphabetically (since 2.1.15)
- Change: Support constant PP_SUPPRESS_PRIVATE_PAGES to prevent get_pages() from including them
- Change: Support required_operation argument in query_posts() call
- Change: Removed debug comments and dead code from admin/plugin-update_pp.php
- API: 'pp_skip_the_terms_filtering' filter, used by PP Content Teaser extension

[2.1.16] - 12 Sep, 2013

- Fixed: Edit User/Group Permissions - exceptions with Post Type of "(all)" were not stored correctly
- Fixed: On Edit User screen, extra "Custom User Permissions" box with invalid link

[2.1.15] - 11 Sep, 2013

- Feature: Permissions > Settings > Advanced > Misc > "User Search: Filter by WP role" - adds a role dropdown below user search button
- Change: Support PP Core updates without license key activation

[2.1.14] - 9/9, 2013

- Initial production release
- Change: Info link on Install tab for screencast links and other PP Pro promotional info if license key inactive or expired
- Lang: updated .po file
