jQuery(document).ready(function ($) {
    $(document).on('click', '#authordiv a.pp-add-author', function () {
        $('#post_author_override').hide();
        $('#pp_author_search').show();
        $('#authordiv a.pp-add-author').hide();
        $('#authordiv a.pp-close-add-author').show();
        $('#agent_search_text_select-author').focus();
        return false;
    });

    $(document).on('click', '#authordiv a.pp-close-add-author', function () {
        $('#pp_author_search').hide();
        $('#authordiv a.pp-close-add-author').hide();
        $('#authordiv a.pp-add-author').show();
        $('#post_author_override').show();
        return false;
    });

    $(document).on('click', '#select_agents_select-author', function () {
        var selected_id = $('#agent_results_select-author').val();
        if (selected_id) {
            if (!$('#post_author_override option[value="' + selected_id + '"]').prop('selected', true).length) {
                var selected_name = $('#agent_results_select-author option:selected').html();

                $('#post_author_override').append('<option value=' + selected_id + '>' + selected_name + '</option>');
                $('#post_author_override option[value="' + selected_id + '"]').prop('selected', true);
            }
        }

        $('#authordiv a.pp-close-add-author').trigger('click');
        return false;
    });

    $(document).on('jchange', '#agent_results_select-author', function () {
        if ($('#agent_results_select-author option').length) {
            $('#agent_results_select-author').show();
            $('#select_agents_select-author').show();
        }
    });

    // Set post visibility in Gutenberg based on default_privacy
    if (typeof window.ppEditorConfig !== 'undefined' && window.ppEditorConfig.defaultPrivacy) {
        var defaultPrivacy = window.ppEditorConfig.defaultPrivacy;
        var visibility;
        switch (defaultPrivacy) {
            case 'private':
                visibility = 'private';
                break;
            default:
                visibility = 'draft';
                break;
            // Add more cases if needed
        }

        if (visibility) {
            // Wait for Gutenberg editor to be fully ready
            var applyDefaultPrivacy = function() {
                if (typeof wp === 'undefined' || !wp.data || !wp.data.select || !wp.data.dispatch) {
                    setTimeout(applyDefaultPrivacy, 200);
                    return;
                }
                
                // Check if editor is fully loaded by verifying we have a post type
                var currentPost = wp.data.select('core/editor').getCurrentPost();
                if (!currentPost || !currentPost.type) {
                    setTimeout(applyDefaultPrivacy, 200);
                    return;
                }
                
                try {
                    wp.data.dispatch('core/editor').editPost({ status: visibility });
                    if (wp.data.dispatch('core/editor').savePost) {
                        wp.data.dispatch('core/editor').savePost();
                    }
                } catch (e) {
                    console.log('Error applying default privacy:', e);
                    // Retry after a delay if there's still an error
                    setTimeout(applyDefaultPrivacy, 500);
                }
            };
            
            // Start checking for editor readiness
            applyDefaultPrivacy();
        }
    }
});