<?php

/*
    Plugin Name: Email Signature Builder
    Plugin URI: http://www.purdue.edu
    description: Limit user emails to only accept univeristy approved email addresses
    Version: 0.3.0
    Author: Marketing and Media
    Author URI: https://brand.purdue.edu
    License:     GPLv3
    License URI: https://www.gnu.org/licenses/gpl-3.0.html

    ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

if ( !defined('ABSPATH') ) {
	header( 'HTTP/1.0 403 Forbidden' );
	die;
}

if ( ! class_exists( 'EmailSignatureBuilder' ) ) :

    class EmailSignatureBuilder {

        public function __construct() {
			self::includes();
			self::hooks();
		}

		private static function includes() {
           
		}

		private static function hooks() {
            add_action( 'wp_enqueue_scripts', array( __CLASS__, 'addScripts' ) );
            add_shortcode( 'email_signature_builder' , array( __CLASS__, 'emailSigBuilderShortcode' ) );
            add_shortcode( 'email_builder_iframe' , array( __CLASS__, 'emailBuilderIframe' ) );

		}
        
        public static function addScripts() {
            wp_enqueue_script( 'jquery' );
            wp_enqueue_script( 'jquery-mask', 'https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js', 'jquery', '1.14.16', false );

            wp_enqueue_script( 'jquery-serialize-object', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-serialize-object/2.5.0/jquery.serialize-object.min.js', 'jquery', '2.5.0', false );
            
            
            wp_enqueue_script( 'handlebars', 'https://cdnjs.cloudflare.com/ajax/libs/handlebars.js/4.7.2/handlebars.min.js', 'jquery', '4.7.2', false );
            wp_enqueue_script( 'hogan', 'https://cdnjs.cloudflare.com/ajax/libs/hogan.js/3.0.2/hogan.min.js', 'handlebars', '3.0.2', false );
            // wp_enqueue_script( 'esig-h', plugin_dir_url( __FILE__ ) . 'scripts/h.js', null, self::plugin_name_get_version(), false );
            wp_enqueue_script( 'esig-app', plugin_dir_url( __FILE__ ) . 'scripts/app.js', 'esig-h', self::plugin_name_get_version(), true );
            
        }

        private static function plugin_name_get_version() {
            $plugin_data = get_plugin_data( __FILE__ );
            $plugin_version = $plugin_data['Version'];
            return $plugin_version;
        }
        
        public static function emailBuilderIframe() {
          $pluginPath = plugin_dir_url( __FILE__ );
          return '
          <style>
          .iframe-container {
            overflow: hidden;
            padding-top: 56.25%;
            position: relative;
          }
          
          .iframe-container iframe {
             border: 0;
             height: 100%;
             left: 0;
             position: absolute;
             top: 0;
             width: 100%;
          }
          </style>
          <div class="iframe-container">
            <iframe frameborder="0" src="' . $pluginPath . 'builder.html" gesture="media"  allow="encrypted-media" allowfullscreen overflow-x="hidden"></iframe>
          </div>';

        }

        public static function emailSigBuilderShortcode() {
            $pluginPath = plugin_dir_url( __FILE__ );

            $s = <<<EOSTR
            <style>
              #instructions {
                padding: 1rem;
                margin-bottom: 2rem;
              }
              .signature {
                background-color:#fff;
                border: solid 1px #eee;
                border-top-color: rgb(238, 238, 238);
                border-right-color: rgb(238, 238, 238);
                border-bottom-color: rgb(238, 238, 238);
                border-left-color: rgb(238, 238, 238);
                border-radius: 2px;
                padding: 15px;
                transition: all 200ms;
              }
              @media (min-width:1024px){
                .signatures {
                  margin-top:4rem;
                }
                #radio-control{
                  margin-right: -200%;
              }
            </style>
            <section id="instructions">
        <h2>Instructions</h2>
        <ol>
          <li>
            <p>
              Fill in the form fields that you’d like to include in your
              signature. A preview of your signature will be built as you type.
            </p>
          </li>
          <li>
            <p>
              Select the format option you’d like to use. The signature content
              will be highlighted.
            </p>
          </li>
          <li>
            <p>Copy the signature that was just highlighted:</p>
            <p>
              <strong>Windows:</strong> Press <kbd>Ctrl+C</kbd><br>
              <strong>Mac:</strong> Press <kbd>⌘+C</kbd><br>
              <strong>Or in your browser:</strong> Click <kbd>Edit</kbd> in the
              toolbar, then <kbd>Copy</kbd>
            </p>
          </li>
          <li>
            <p>Paste it into your email program of choice.</p>
          </li>
        </ol>
      </section>
      <!-- <hr /> -->
      <div class="columns is-desktop">
        <div class="column">
          <form id="signature-fields" class="form">
              <div class="field ">
                <div class="control" id="radio-control">
                  <label class="radio">
                    <input type="radio" name="imgopt" value="signature" checked>
                    Signature Logo
                  </label>
                 <!-- <label class="radio">
                  <input type="radio" name="imgopt" value="contenthub" >
                  The Persistent Pursuit
                </label>
                <label class="radio">
                <input type="radio" name="imgopt" value="tppNewsletter" >
                The Persistent Pursuit Newsletter
              </label>-->
                </div>
              </div>
              <p><h4>Personal Information</h4></p>
              <div class="field ">
                <label class="label" for="name">Name</label>
                <div class="control">
                  <input id="name" name="name" class="input is-small" type="text" placeholder="e.g Purdue Pete">
                </div>
              </div>
              <div class="field ">
                <label class="label" for="credential">Academic/Professional Designation</label>
                <div class="control">
                  <input id="credential" name="credential" class="input is-small" type="text" placeholder="e.g PhD">
                </div>
              </div>
              <div class="field ">
                <label class="label" for="pronouns">Preferred Pronouns</label>
                <div class="control">
                  <input id="pronouns" name="pronouns" class="input is-small" type="text" >
                </div>
              </div>
              <div class="field ">
                <label class="label" for="title">Job Title</label>
                <div class="control">
                  <input id="title" name="title" class="input is-small" type="text" >
                </div>
              </div>
              <div class="field ">
                <label class="label" for="unit">College/School/Department</label>
                <div class="control">
                  <input id="unit" name="unit" class="input is-small" type="text" >
                </div>
              </div>
              <p><h4>Location</h4></p>
              <div class="field ">
                <label class="label" for="building">Building</label>
                <div class="control">
                  <input id="building" name="building" class="input is-small" type="text" >
                </div>
              </div>
              <div class="field ">
                <label class="label" for="street">Address 1</label>
                <div class="control">
                  <input id="street" name="street" class="input is-small" type="text" >
                </div>
              </div>
              <div class="field ">
                <label class="label" for="extended">Address 2</label>
                <div class="control">
                  <input id="extended" name="extended" class="input is-small" type="text" >
                </div>
              </div>
              <div class="field ">
                <label class="label" for="city">City</label>
                <div class="control">
                  <input id="city" name="city" class="input is-small" type="text" >
                </div>
              </div>
              <div class="field ">
                <label class="label" for="state">State</label>
                <div class="select">
                  <select id="state" name="state">
                  <option value="">— Select State —</option>
                  <option value="AL">Alabama</option>
                  <option value="AK">Alaska</option>
                  <option value="AZ">Arizona</option>
                  <option value="AR">Arkansas</option>
                  <option value="CA">California</option>
                  <option value="CO">Colorado</option>
                  <option value="CT">Connecticut</option>
                  <option value="DE">Delaware</option>
                  <option value="DC">District Of Columbia</option>
                  <option value="FL">Florida</option>
                  <option value="GA">Georgia</option>
                  <option value="HI">Hawaii</option>
                  <option value="ID">Idaho</option>
                  <option value="IL">Illinois</option>
                  <option value="IN" selected="selected">Indiana</option>
                  <option value="IA">Iowa</option>
                  <option value="KS">Kansas</option>
                  <option value="KY">Kentucky</option>
                  <option value="LA">Louisiana</option>
                  <option value="ME">Maine</option>
                  <option value="MD">Maryland</option>
                  <option value="MA">Massachusetts</option>
                  <option value="MI">Michigan</option>
                  <option value="MN">Minnesota</option>
                  <option value="MS">Mississippi</option>
                  <option value="MO">Missouri</option>
                  <option value="MT">Montana</option>
                  <option value="NE">Nebraska</option>
                  <option value="NV">Nevada</option>
                  <option value="NH">New Hampshire</option>
                  <option value="NJ">New Jersey</option>
                  <option value="NM">New Mexico</option>
                  <option value="NY">New York</option>
                  <option value="NC">North Carolina</option>
                  <option value="ND">North Dakota</option>
                  <option value="OH">Ohio</option>
                  <option value="OK">Oklahoma</option>
                  <option value="OR">Oregon</option>
                  <option value="PA">Pennsylvania</option>
                  <option value="RI">Rhode Island</option>
                  <option value="SC">South Carolina</option>
                  <option value="SD">South Dakota</option>
                  <option value="TN">Tennessee</option>
                  <option value="TX">Texas</option>
                  <option value="UT">Utah</option>
                  <option value="VT">Vermont</option>
                  <option value="VA">Virginia</option>
                  <option value="WA">Washington</option>
                  <option value="WV">West Virginia</option>
                  <option value="WI">Wisconsin</option>
                  <option value="WY">Wyoming</option>
                  </select>
                </div>
              </div>
              <div class="field ">
                <label class="label" for="postalcode">Postal Code</label>
                <div class="control">
                  <input id="postalcode" name="postalcode" class="input is-small" type="tel" pattern="(\d{5}([\-]\d{4})?)">
                </div>
              </div>
              <p><h4>Contact Information</h4></p>
              <div class="field ">
                <label class="label" for="phone">Phone</label>
                <div class="control">
                  <input id="phone" name="phone" class="input is-small" type="tel" pattern="\d{3}[\-]\d{3}[\-]\d{4}" placeholder="___-___-____" >
                </div>
              </div>
              <div class="field ">
                <label class="label" for="mobile">Mobile</label>
                <div class="control">
                  <input id="mobile" name="mobile" class="input is-small" type="tel" pattern="\d{3}[\-]\d{3}[\-]\d{4}" placeholder="___-___-____" >
                </div>
              </div>
              <div class="field ">
                <label class="label" for="fax">Fax</label>
                <div class="control">
                  <input id="fax" name="fax" class="input is-small" type="tel" pattern="\d{3}[\-]\d{3}[\-]\d{4}" placeholder="___-___-____" >
                </div>
              </div>

              <p><h4>Additional Details</h4></p>
              <div class="field ">
                <div class="control">
                  <label class="radio">
                    <input type="radio" name="social" value="links">
                    Social Links
                  </label>
                  <label class="radio">
                    <input type="radio" name="social" value="line" checked>
                    Strengths or MBTI
                  </label>
                </div>
              </div>
              <div id="extraline" class="field ">
                <label class="label" for="strengths">Strengths or MBTI</label>
                <div class="control">
                  <input id="strengths" name="strengths" class="input is-small" type="text" placeholder="StrengthsFinder or MBTI Results">
                </div>
              </div>
              <div id="socialnetworks">
                <div class="field ">
                  <label class="label" for="fb">Facebook</label>
                  <div class="control">
                    <input id="fb" name="fb" class="input is-small" type="text" >
                  </div>
                </div>
                <div class="field ">
                  <label class="label" for="twitter">Twitter</label>
                  <div class="control">
                    <input id="twitter" name="twitter" class="input is-small" type="text" >
                  </div>
                </div>
                <div class="field ">
                  <label class="label" for="lin">LinkedIn</label>
                  <div class="control">
                    <input id="lin" name="lin" class="input is-small" type="text" >
                  </div>
                </div>
                <div class="field ">
                  <label class="label" for="insta">Instagram</label>
                  <div class="control">
                    <input id="insta" name="insta" class="input is-small" type="text" >
                  </div>
                </div>
                <div class="field ">
                  <label class="label" for="snap">Snapchat</label>
                  <div class="control">
                    <input id="snap" name="snap" class="input is-small" type="text" >
                  </div>
                </div>
              </div>         
          </form>
        </div>
   

        <div class="column ">
          <div class="signatures">
            <div class="option">
              <p><h3 class="option-title">Extended Option</h3></p>
              <div id="template1" class="signature"></div>
            </div>
            <div class="option">
              <p><h3 class="option-title">Compact Option</h3></p>
              <div id="template2" class="signature"></div>
            </div>
            <br />
            <div class="">
              <form id="signature-output" class="form">
                <textarea
                  id="signature-html"
                  name="signature"
                  hidden
                  readonly
                ></textarea>
                <div>
                  <!-- <a id="clip" class="button button-primary" data-clipboard-target="#signature-html">Copy to Clipboard</a> -->
                  <p>
                    <a id="highlight" class="button button-tertiary"
                      >Re-Select Signature Text</a
                    >
                  </p>
                  <div class="alert">
                    Formatting may be lost when pasting into Microsoft Outlook
                    client. If format looks incorrect, hover your cursor around
                    the bottom-right corner of the signature to activate
                    <em>Paste Options</em>. Click the dropdown arrow and select
                    <em>Keep Source Formatting</em>.
                  </div>
                  <h4>Client-specific Instructions</h4>
								<ul>
									<li><a href="https://support.office.com/en-us/article/Create-and-add-a-signature-to-messages-8ee5d4f4-68fd-464a-a1c1-0e1c80bb27f2" target="_blank">Microsoft Outlook</a></li>
									<li><a href="https://support.apple.com/guide/mail/create-and-use-email-signatures-mail11943/mac" target="_blank">macOS Mail</a></li>
									<!-- <li><a href="https://support.google.com/mail/answer/8395?co=GENIE.Platform%3DDesktop&hl=en" target="_blank">Gmail</a></li> -->
								</ul>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>


    <script id="option-1" type="x-handlebars-template">

        <div class="esig" style="{{> fontFamilyCSS}} {{> fontSizeCSS}}">
          <div class="person">
            {{#if name}}
              <span style="{{> nameCSS}}">{{name}}</span>{{#if credential}}<span style="{{> nameCSS}}">, {{credential}}</span>{{/if}}
            {{/if}}
            {{#if pronouns}}
              <div style="{{> italicCSS}}">{{pronouns}}</div>
            {{/if}}
            {{#if title}}
              {{#if (or name pronouns)}}<br />{{/if}}
              <span style="{{> italicCSS}} {{> fontFamilyCSS}}">{{title}}</span><br />
            {{/if}}
            {{#if unit}}
              <span style="{{> agedGoldCSS}} {{> fontFamilyCSS}}">{{unit}}</span><br />
            {{/if}}
          </div>
          {{#if (or name pronouns title unit)}}<br />{{/if}}
          <div class="address">
            {{#if building}}
              <span style="{{> fontFamilyCSS}}">{{building}}</span><br />
            {{/if}}
            {{#if street}}
              <span style="{{> fontFamilyCSS}}">{{street}}</span>{{#if extended}}, <span style="{{> fontFamilyCSS}}">{{extended}}</span>{{/if}}<br />
            {{/if}}
            <span style="{{> fontFamilyCSS}}">{{locality city state postalcode}}</span>
          </div>
          {{#if (or phone mobile fax)}}
            <div class="phonenum">
            <span style="{{> fontFamilyCSS}}">{{phoneFormat phone 'o'}}</span>
            {{#if (and phone mobile)}}&nbsp;{{/if}}
            <span style="{{> fontFamilyCSS}}">{{phoneFormat mobile 'm'}}</span>
            {{#if (or (and phone fax) (and mobile fax))}}&nbsp;{{/if}}
            <span style="{{> fontFamilyCSS}}">{{phoneFormat fax 'f'}}</span>
          </div>
          {{/if}}
          {{#if (or strengths fb twitter lin snap insta)}}
            <br /><span style="{{> fontFamilyCSS}} {{> italicCSS}} {{> fontFamilyCSS}}">{{extraline social}}</span>
          {{/if}}
          
          {{#if (eq imgopt "contenthub")}}
            <br />{{> contenthubBanner}}
          {{else if (eq imgopt "tppNewsletter")}}
          <br />{{> tppNewsletter}}
          {{else}}
          {{> signatureLogo}}
          {{/if}}
        ​</div>
    </script>
    <script id="option-2" type="x-handlebars-template">
      <div class="esig" style="{{> fontFamilyCSS}} {{> fontSizeCSS}}">
        <div class="person">
          {{#if name}}
            <span style="{{> nameCSS}}">{{name}}</span>{{#if credential}}<span style="{{> nameCSS}}">, {{credential}}</span>{{/if}}
          {{/if}}
          {{#if pronouns}}
            {{#if name}}<br />{{/if}}
            <span style="{{> italicCSS}}">{{pronouns}}</span>
          {{/if}}
          {{#if title}}
            {{#if (or name pronouns)}}<br />{{/if}}
            <span style="{{> italicCSS}} {{> fontFamilyCSS}}">{{title}}{{#if unit}}, {{/if}}</span>
          {{/if}}
          {{#if unit}}
            <span style="{{> agedGoldCSS}} {{> fontFamilyCSS}}">{{unit}}</span>
          {{/if}}
        </div>
        
        <div class="address">
          {{#if (or title unit)}}<br />{{/if}}
          {{#if building}}
            <span style="{{> fontFamilyCSS}}">{{building}}{{#if street}}, {{/if}}</span>
          {{/if}}
          {{#if street}}
            <span style="{{> fontFamilyCSS}}">{{street}}</span>{{#if extended}}, <span style="{{> fontFamilyCSS}}">{{extended}}</span>{{/if}},
          {{/if}}
          <span style="{{> fontFamilyCSS}}">{{locality city state postalcode}}</span>
        </div>
        
        {{#if (or phone mobile fax)}}
          <div class="phonenum">
            <span style="{{> fontFamilyCSS}}">{{phoneFormat phone 'o'}}</span>
            {{#if (and phone mobile)}}&nbsp;{{/if}}
            <span style="{{> fontFamilyCSS}}">{{phoneFormat mobile 'm'}}</span>
            {{#if (or (and phone fax) (and mobile fax))}}&nbsp;{{/if}}
            <span style="{{> fontFamilyCSS}}">{{phoneFormat fax 'f'}}</span>
          </div>
        {{/if}}
        
        {{#if (or strengths fb twitter lin snap insta)}}
          <br /><span style="{{> fontFamilyCSS}} {{> italicCSS}} {{> fontFamilyCSS}}">{{extraline social}}</span>
        {{/if}}

        {{#if (eq imgopt "signature")}}
          {{> signatureLogo}}
        {{/if}}
    {{!--
        {{#if (eq imgopt "contenthub")}}
          <br />{{> contenthubBanner}}
        {{else if (eq imgopt "tppNewsletter")}}
        <br />{{> tppNewsletter}} 
        {{else}}
          {{> signatureLogo}}
        {{/if}} 
       --}}
      ​</div>
    </script>
EOSTR;

            return $s;
        }



    }

    new EmailSignatureBuilder( );

endif;