<?php
$id = $attributes['id'] != "" ? ' id="' . $attributes['id'] . '"' : "";
?>

<div <?= $id; ?> class="purdue-home-cta-banner purdue-home-link-hero <?= $attributes['className']; ?>">
    <div class="image">
        <?php if ($attributes['mediaType'] == "image"): ?>
            <img alt="<?= $attributes["mediaAlt"]; ?>" src="<?= $attributes["mediaURL"]; ?>"/>
        <?php elseif ($attributes['mediaType'] == "video"): ?>
            <video preload="metadata" title="<?= $attributes['mediaTitle']; ?>" muted playsinline="">
                <source src="<?= $attributes["mediaURL"]; ?>#t=0.1">
            </video>
        <?php endif; ?>
    </div>
    <div class="section has-padding-exlarge">
        <div class="container">
            <?php if ($attributes['subheader'] != ""): ?>
                <p class="purdue-home-hero__subheader purdue-home-link-hero__subheader tagged-header tagged-header--gold">
                    <?= $attributes['subheader']; ?>
                </p>
            <?php endif; ?>
            <?php if ($attributes['header'] != ""): ?>
                <?php 
                if($attributes['imgURL'] == ""):
                    $class = 'second-level-page-heading purdue-home-link-hero__header'; 
                ?>
                <h1 class="<?= $class; ?>">
                    <?= $attributes['header']; ?>
                </h1>
                <?php else: ?>
                <div class="purdue-home-link-hero__header-image">
                    <img src="<?= $attributes['imgURL']; ?>" alt="<?= $attributes['imgAlt']; ?>">
                </div>
                <h1 class="is-sr-only">
                    <?= $attributes['header']; ?>
                </h1>
                <?php endif; ?>
            <?php endif; ?>
            <?php if ($attributes['subtext'] != ""): ?>
                <p class="purdue-home-link-hero__subtext">
                    <?= $attributes['subtext']; ?>
                </p>
            <?php endif; ?>
            <?php if ($attributes['linkType']=="cta" && $attributes['ctalinks'] && sizeof($attributes['ctalinks']) > 0 && $attributes['ctalinks'][0]['linkURL']): ?>
                <ul class="purdue-home-button-list">
                    <?php foreach ($attributes['ctalinks'] as $key => $link): ?>
                        <?php
                        $target = $link["external"] ? 'target="_blank"' : 'target="_self"';
                        $buttonClass = "purdue-home-button";
                        if ($link["buttonColor"] == "black") {
                            $buttonClass .= " purdue-home-button--black";
                        }elseif($link["buttonColor"] == "white") {
                            $buttonClass .= " purdue-home-button--white";
                        }
                        $dataTarget = "";
                        if($key == 0){
                            $buttonClass .= " modal-trigger";
                            $dataTarget = ' data-target="subscribe-modal"';
                        }
                        $liClass = $link["fullWidth"] ? "purdue-home-button-wrap--full" : "";
                        ?>
                        <li class="<?= $liClass; ?>">
                        <?php if($key == 0): ?>
                            <button class="<?= $buttonClass; ?>" data-target="subscribe-modal">
                                <?= trim($link["linkText"]); ?>
                        </button>
                        <?php else: ?>
                            <a class="<?= $buttonClass; ?>" href="<?= $link["linkURL"]; ?>" <?= $target; ?> <?= $dataTarget; ?>>
                                <?= trim($link["linkText"]); ?>
                            </a>
                        <?php endif; ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
            <div class="purdue-home-link-hero__arrow hero-down-arrow" aria-hidden="true">
                <i class="fa-solid fa-chevron-down icon" aria-hidden="true"></i>
            </div>
        </div>
    </div>
    <div id="subscribe-modal" class="modal subscribe-modal">
        <div class="modal-background">
            </div>
        <div class="modal-inner">
        <div class="modal-close" aria-label="close"></div>
         <div class="modal-content">
            <h2>Subscribe to the<br/>"This Is Purdue"<br/>Podcast</h2>
                <ul>
                    <li><a href="https://podcasts.apple.com/us/podcast/this-is-purdue/id1496040232" target="_blank"><?php rkv_theme_the_svg_contents_for_svg( '/font-awesome/Apple_Podcast.svg' ); ?><span class="screen-reader-text">Listen on Apple Podcasts</span></a></li>
                    <li><a href="https://open.spotify.com/show/1npQBIaTzFnCvDlzeiNV7j" target="_blank"><?php rkv_theme_the_svg_contents_for_svg( '/font-awesome/Spotify_Podcast.svg' ); ?><span class="screen-reader-text">Listen on Spotify</span></a></li>
                    <li><a href="https://www.youtube.com/@ThisIsPurdue" target="_blank"><?php rkv_theme_the_svg_contents_for_svg( '/font-awesome/Youtube_Podcast.svg' ); ?><span class="screen-reader-text">Listen or watch on Youtube</span></a></li>
                    <li><a href="https://music.amazon.com/podcasts/a47fc8cc-bd4c-42b9-890d-fc46600a2327/this-is-purdue" target="_blank"><?php rkv_theme_the_svg_contents_for_svg( '/font-awesome/Amazon_Music_Podcast.svg' ); ?><span class="screen-reader-text">Listen on Amazon Music</span></a></li>
                    <li><a href="https://www.stitcher.com/show/this-is-purdue" target="_blank"><?php rkv_theme_the_svg_contents_for_svg( '/font-awesome/Stitcher_Podcast.svg' ); ?><span class="screen-reader-text">Listen on Stitcher</span></a></li>
                </ul>
            </div>
        </div>
    </div>
</div>
