<?php
/**
 * Example custom post type.
 *
 * This can be replaced.
 *
 * @package rkv-theme
 */

namespace RKV\Theme\Post_Type;

/**
 * Define the example custom post type.
 */
class Podcast extends \RKV\Utilities\Post_Type\Base {

	/**
	 * Post type name.
	 *
	 * Remember to always prefix the post type name with the name of the theme.
	 *
	 * @var string
	 */
	protected $post_type_name = 'rkv_podcast';

	/**
	 * Initialize the post type by setting the post type args.
	 *
	 * This is also where you can add any other actions or filters
	 * to further extend the post type.
	 */
	protected function initialize_post_type() {
		$labels = [
			'name'               => __( 'Podcasts', 'rkv-theme' ),
			'singular_name'      => __( 'Podcast', 'rkv-theme' ),
			'add_new'            => _x( 'Add New Podcast', 'rkv-theme', 'rkv-theme' ),
			'add_new_item'       => __( 'Add New Podcast', 'rkv-theme' ),
			'edit_item'          => __( 'Edit Podcast', 'rkv-theme' ),
			'new_item'           => __( 'New Podcast', 'rkv-theme' ),
			'view_item'          => __( 'View Podcast', 'rkv-theme' ),
			'search_items'       => __( 'Search Podcasts', 'rkv-theme' ),
			'not_found'          => __( 'No Podcast found', 'rkv-theme' ),
			'not_found_in_trash' => __( 'No Podcast found in Trash', 'rkv-theme' ),
			'parent_item_colon'  => __( 'Parent Podcast:', 'rkv-theme' ),
			'menu_name'          => __( 'Podcasts', 'rkv-theme' ),
		];

		$this->post_type_args = [
			'labels'              => $labels,
			'description'         => __( 'Purdue Podcasts', 'rkv-theme' ),
			'taxonomies'          => [ 'post_tag', 'category', '_theme', 'rkv_featured' ],
			'menu_position'       => 5,
			'menu_icon'           => 'dashicons-playlist-audio', // See https://developer.wordpress.org/resource/dashicons/.
			'show_in_nav_menus'   => true,
			'publicly_queryable'  => true,
			'exclude_from_search' => false,
			'has_archive'         => false,
			'query_var'           => $this->post_type_name,
			'rewrite'             => [
				'slug'       => 'podcast', 
				'with_front' => false,
			],
			'supports'            => [
				'title',
				'editor',
				'author',
				'thumbnail',
				'excerpt',
				'comments',
				'trackbacks',
				'revisions',
			],
		];
	}


}
