<?php
/**
 * Example custom taxonomy.
 *
 * @package rkv-theme
 */

namespace RKV\Theme\Taxonomy;

/**
 * Example taxonomy class.
 */
class Example extends \RKV\Utilities\Taxonomy\Base {

	/**
	 * Taxonomy name.
	 *
	 * @var string
	 */
	protected $taxonomy_name = 'rkv-example';

	/**
	 * Initialize the taxonomy.
	 */
	protected function initialize_taxonomy() {
		$labels = [
			'name'              => _x( 'Exampless', 'taxonomy general name', 'rkv-theme' ),
			'singular_name'     => _x( 'Example', 'taxonomy singular name', 'rkv-theme' ),
			'search_items'      => __( 'Search Examples', 'rkv-theme' ),
			'all_items'         => __( 'All Examples', 'rkv-theme' ),
			'parent_item'       => __( 'Parent Example', 'rkv-theme' ),
			'parent_item_colon' => __( 'Parent Example:', 'rkv-theme' ),
			'edit_item'         => __( 'Edit Example', 'rkv-theme' ),
			'update_item'       => __( 'Update Example', 'rkv-theme' ),
			'add_new_item'      => __( 'Add New Example', 'rkv-theme' ),
			'new_item_name'     => __( 'New Example Name', 'rkv-theme' ),
			'menu_name'         => __( 'Examples', 'rkv-theme' ),
			'not_found'         => __( 'No Examples Found', 'rkv-theme' ),
		];

		$this->taxonomy_args = [
			'labels'       => $labels,
			'hierarchical' => true,
		];

		$this->taxonomy_post_types = [ 'post' ];
	}

}
