<?php
/**
 * genre custom taxonomy.
 *
 * @package rkv-theme
 */

namespace RKV\Theme\Taxonomy;

/**
 * genre taxonomy class.
 */
class Featured extends \RKV\Utilities\Taxonomy\Base {

	/**
	 * Taxonomy name.
	 *
	 * @var string
	 */
	protected $taxonomy_name = 'rkv-featured';

	/**
	 * Initialize the taxonomy.
	 */
	protected function initialize_taxonomy() {
		$labels = [
			'name'              => _x( 'Featured Posts', 'taxonomy general name', 'rkv-theme' ),
			'singular_name'     => _x( 'Featured Post', 'taxonomy singular name', 'rkv-theme' ),
			'search_items'      => __( 'Search Featured Post', 'rkv-theme' ),
			'all_items'         => __( 'All Featured Post', 'rkv-theme' ),
			'parent_item'       => __( 'Parent Featured Post', 'rkv-theme' ),
			'parent_item_colon' => __( 'Parent Featured Post:', 'rkv-theme' ),
			'edit_item'         => __( 'Edit Featured Post', 'rkv-theme' ),
			'update_item'       => __( 'Update Featured Post', 'rkv-theme' ),
			'add_new_item'      => __( 'Add New Featured Post', 'rkv-theme' ),
			'new_item_name'     => __( 'New Featured Post Name', 'rkv-theme' ),
			'menu_name'         => __( 'Featured Post', 'rkv-theme' ),
			'not_found'         => __( 'No Featured Post Found', 'rkv-theme' ),
		];

		$this->taxonomy_args = [
			'labels'       => $labels,
			'hierarchical' => true,
			'has_archive'         => false,
			'rewrite'             => [
				'slug'       => 'featured', 
				'with_front' => false,
			],
		];

		$this->taxonomy_post_types = ['post', 'rkv_podcast', 'video'];
	}

}
