<?php
/**
 * Example custom taxonomy.
 *
 * @package rkv-theme
 */

namespace RKV\Theme\Taxonomy;

/**
 * Example taxonomy class.
 */
class Media extends \RKV\Utilities\Taxonomy\Base {

	/**
	 * Taxonomy name.
	 *
	 * @var string
	 */
	protected $taxonomy_name = 'rkv-media';

	/**
	 * Initialize the taxonomy.
	 */
	protected function initialize_taxonomy() {
		$labels = [
			'name'              => _x( 'Media', 'taxonomy general name', 'rkv-theme' ),
			'singular_name'     => _x( 'Media', 'taxonomy singular name', 'rkv-theme' ),
			'search_items'      => __( 'Search Media', 'rkv-theme' ),
			'all_items'         => __( 'All Media', 'rkv-theme' ),
			'parent_item'       => __( 'Parent Media', 'rkv-theme' ),
			'parent_item_colon' => __( 'Parent Media:', 'rkv-theme' ),
			'edit_item'         => __( 'Edit Media', 'rkv-theme' ),
			'update_item'       => __( 'Update Media', 'rkv-theme' ),
			'add_new_item'      => __( 'Add New Media', 'rkv-theme' ),
			'new_item_name'     => __( 'New Media', 'rkv-theme' ),
			'menu_name'         => __( 'Media', 'rkv-theme' ),
			'not_found'         => __( 'No Media Found', 'rkv-theme' ),
		];

		$this->taxonomy_args = [
			'labels'             => $labels,
			'hierarchical'       => true,
			'public'             => false,
			'show_ui'            => true,
			'show_in_nav_menus'  => false,
			'query_var'          => true,
			'show_in_rest'       => true,
			'show_in_quick_edit' => true,
			'show_admin_column'  => true,
			'rewrite'            => [
				'slug' => 'media',
			],
		];

		$this->taxonomy_post_types = [ 'post', 'rkv_podcast', 'video' ];
		
		add_action( 'registered_taxonomy', [ $this, 'register_initial_terms' ] );
	}
	
	/**
	 * Register initial terms.
	 *
	 * @param string $taxonomy The taxonomy name.
	 */
	public function register_initial_terms( $taxonomy ) {
		if ( $this->taxonomy_name !== $taxonomy ) {
			return;
		}
		
		$initial_terms = apply_filters( "rkv_taxonomy_{$this->taxonomy_name}_initial_terms", [ 'Post', 'Podcast', 'Video', 'Gallery' ] );
		foreach ( $initial_terms as $initial_term ) {
			// Insert the term using the display string.
			// The slug will be pulled from the display string.
			// If the term already exists, it won't be created again.
			wp_insert_term( $initial_term, $this->taxonomy_name );
		}
	}

}
