<?php
/**
 * Example custom taxonomy.
 *
 * @package rkv-theme
 */

namespace RKV\Theme\Taxonomy;

/**
 * Example taxonomy class.
 */
class Story extends \RKV\Utilities\Taxonomy\Base {

	/**
	 * Taxonomy name.
	 *
	 * @var string
	 */
	protected $taxonomy_name = 'rkv-story';

	/**
	 * Initialize the taxonomy.
	 */
	protected function initialize_taxonomy() {
		$labels = [
			'name'              => _x( 'Story', 'taxonomy general name', 'rkv-theme' ),
			'singular_name'     => _x( 'Story', 'taxonomy singular name', 'rkv-theme' ),
			'search_items'      => __( 'Search Story Tags', 'rkv-theme' ),
			'all_items'         => __( 'All Story Tags', 'rkv-theme' ),
			'parent_item'       => __( 'Parent Story', 'rkv-theme' ),
			'parent_item_colon' => __( 'Parent Story:', 'rkv-theme' ),
			'edit_item'         => __( 'Edit Story', 'rkv-theme' ),
			'update_item'       => __( 'Update Story', 'rkv-theme' ),
			'add_new_item'      => __( 'Add New Story', 'rkv-theme' ),
			'new_item_name'     => __( 'New Story', 'rkv-theme' ),
			'menu_name'         => __( 'Story', 'rkv-theme' ),
			'not_found'         => __( 'No Story Found', 'rkv-theme' ),
		];

		$this->taxonomy_args = [
			'labels'             => $labels,
			'hierarchical'       => false,
			'public'             => false,
			'show_ui'            => true,
			'show_in_nav_menus'  => false,
			'query_var'          => true,
			'show_in_rest'       => true,
			'show_in_quick_edit' => true,
			'show_admin_column'  => true,
			'rewrite'            => [
				'slug' => 'story',
			],
		];

		$this->taxonomy_post_types = [ 'post', 'rkv_podcast' ];
		
		add_action( 'registered_taxonomy', [ $this, 'register_initial_terms' ] );
	}
	
	/**
	 * Register initial terms.
	 *
	 * @param string $taxonomy The taxonomy name.
	 */
	public function register_initial_terms( $taxonomy ) {
		if ( $this->taxonomy_name !== $taxonomy ) {
			return;
		}
		
		$initial_terms = apply_filters( "rkv_taxonomy_{$this->taxonomy_name}_initial_terms", [ 'Signature Stories' ] );
		foreach ( $initial_terms as $initial_term ) {
			// Insert the term using the display string.
			// The slug will be pulled from the display string.
			// If the term already exists, it won't be created again.
			wp_insert_term( $initial_term, $this->taxonomy_name );
		}
	}

}
