<?php
/**
 * genre custom taxonomy.
 *
 * @package rkv-theme
 */
function custom_people_taxonomy() {
	$labels = [
		'name'              => _x( 'People', 'taxonomy general name', 'rkv-theme' ),
		'singular_name'     => _x( 'People', 'taxonomy singular name', 'rkv-theme' ),
		'search_items'      => __( 'Search People', 'rkv-theme' ),
		'all_items'         => __( 'All People', 'rkv-theme' ),
		'parent_item'       => __( 'Parent People', 'rkv-theme' ),
		'parent_item_colon' => __( 'Parent People:', 'rkv-theme' ),
		'edit_item'         => __( 'Edit People', 'rkv-theme' ),
		'update_item'       => __( 'Update People', 'rkv-theme' ),
		'add_new_item'      => __( 'Add New People', 'rkv-theme' ),
		'new_item_name'     => __( 'New People Name', 'rkv-theme' ),
		'menu_name'         => __( 'People', 'rkv-theme' ),
		'not_found'         => __( 'No People Found', 'rkv-theme' ),
	];
	$args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
		'has_archive'         => true,
		'show_in_rest'        => true,
		'rewrite'             => [
			'slug'       => 'people', 
			'with_front' => false,
		],
    );
    register_taxonomy( 'people', array( 'post', 'rkv_podcast', 'rkv_video', 'topic' ), $args );
}
add_action( 'init', 'custom_people_taxonomy', 0 );