<?php 
    function readtime($content) {

         // Define the block names.
        $summary_block = 'purdue/at-a-glance'; 
        $new_block = '<!-- wp:paragraph --><p>This is the new block content.</p><!-- /wp:paragraph -->';

        // Parse the blocks in the content.
        $blocks = parse_blocks( $content );

        // Check if the summary block exists.
        $summary_block_exists = false;
        foreach ( $blocks as $block ) {
            if ( $block['blockName'] === $summary_block ) {
                $summary_block = true;
                break;
            }
        }

        // If the summary block doesn't exist, prepend it.
        if ( ! $summary_block_exists ) {
            $blocks = array_merge(
                [
                    [
                        'blockName' => 'core/heading',
                        'attrs'     => [],
                        'innerHTML' => '<h2>Default Heading Block</h2>',
                    ]
                ],
                $blocks
            );
        }

        // Insert the new block after the specific block.
        $updated_blocks = [];
        foreach ( $blocks as $block ) {
            $updated_blocks[] = $block;
            if ( $block['blockName'] === $summary_block ) {
                $updated_blocks[] = parse_blocks( $new_block )[0];
            }
        }

        // Reconstruct the content.
        $mod_content = serialize_blocks( $updated_blocks );

        echo add_filter('the_content', $mod_content);

}