<?php
/**
 * Example custom post type.
 *
 * This can be replaced.
 *
 * @package purdue-home-theme-child
 */

 function custom_register_topic_post_type() {
    $labels = array(
        'name'               => 'Topic',
        'singular_name'      => 'Topic',
        'add_new'            => 'Add New Topic',
        'add_new_item'       => 'Add New Topic',
        'edit_item'          => 'Edit Topic',
        'new_item'           => 'New Topic',
        'all_items'          => 'All Topic',
        'view_item'          => 'View Topic',
        'search_items'       => 'Search Topics',
        'not_found'          => 'No Topics found',
        'not_found_in_trash' => 'No Topics found in Trash',
        'parent_item_colon'  => '',
        'menu_name'          => 'Topics',
    );

    $args = array(
        'labels'              => $labels,
        'taxonomies'          => array( 'post_tag', 'category', '_theme' ),
        'public'              => true,
        'publicly_queryable'  => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'query_var'           => true,
        'rewrite' => array( 
			'slug' => false,
			'with_front' => false
		),
        'capability_type'     => 'post',
        'has_archive'         => true,
        'hierarchical'        => false,
        'menu_position'       => null,
        'supports'            => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
        'show_in_rest'        => true,
    );

    register_post_type( 'topic', $args );
}

add_action( 'init', 'custom_register_topic_post_type' );
