<?php
/**
 * Example custom post type.
 *
 * This can be replaced.
 *
 * @package purdue-home-theme-child
 */

 function custom_register_video_post_type() {
    $labels = array(
        'name'               => 'Videos',
        'singular_name'      => 'Video',
        'add_new'            => 'Add New Video',
        'add_new_item'       => 'Add New Video',
        'edit_item'          => 'Edit Video',
        'new_item'           => 'New Video',
        'all_items'          => 'All Video',
        'view_item'          => 'View Video',
        'search_items'       => 'Search Videos',
        'not_found'          => 'No Videos found',
        'not_found_in_trash' => 'No Videos found in Trash',
        'parent_item_colon'  => '',
        'menu_name'          => 'Videos',
    );

    $args = array(
        'labels'              => $labels,
        'taxonomies'          => array( 'post_tag', 'category', '_theme', 'rkv_featured' ),
        'public'              => true,
        'publicly_queryable'  => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'query_var'           => true,
        'rewrite' => array( 
			'slug' => false,
			'with_front' => false
		),
        'capability_type'     => 'post',
        'has_archive'         => true,
        'hierarchical'        => false,
        'menu_position'       => null,
        'supports'            => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
        'show_in_rest'        => true,
    );

    register_post_type( 'rkv_video', $args );
}

add_action( 'init', 'custom_register_video_post_type' );