import { __ } from "@wordpress/i18n";
import {
	RichText,
    InspectorControls,
    useBlockProps,
    InnerBlocks,
} from "@wordpress/block-editor";

import {
    PanelBody,
    PanelRow,
    TextControl,
} from "@wordpress/components";


const BLOCKS_TEMPLATE = [
    [ 'core/paragraph', { placeholder: 'Add content' } ],
];

  
const Edit = ( props ) => {
  const { setAttributes } = props;
  const { id, text} = props.attributes;
  const blockProps = useBlockProps();
  setAttributes( { id: props.clientId } );
  
  const onChangeText = ( text ) => {
    setAttributes({
        text: text,
    });
}

  return [
    <InspectorControls key="1">
      <PanelBody>
        <PanelRow>
            <TextControl
              label="HTML Anchor"
              help="Enter a word without spaces to make a unique web address just for this block, called an “anchor.” It must be unique from any other anchors on the page. Then, you’ll be able to link directly to this section of your page."
              value={ id }
              onChange={ ( id ) => setAttributes( { id } ) }
            />
        </PanelRow>
      </PanelBody>
    </InspectorControls>,

    <div { ...blockProps } key="2">
      <div className={`purdue-at-a-glance`}>
            <div className={`section`}> 
                    <p><strong>At a Glance:</strong></p>
                    <InnerBlocks
                        template={ BLOCKS_TEMPLATE }
                        templateLock={ false }
                    />
            </div>
      </div>
    </div>
  ]
}

export default Edit;