<?php 

function splitSummary($text, $wordLimit, $id, $spanClass = 'details-text') {



    $dom = new DOMDocument('1.0', 'UTF-8');    
    $dom->loadHTML(mb_convert_encoding($text, 'HTML-ENTITIES', 'UTF-8'));
    $body = $dom->getElementsByTagName('body')->item(0);
    
    if ($body) {
        // Find the first element node (ignoring text nodes, comments, etc.)
        foreach ($body->childNodes as $node) {
            if ($node->nodeType === XML_ELEMENT_NODE) {
                // Return the name of the first element node
                $element = $node->nodeName;
            }
        }
    }
    $Counter = 0;
    $spanHide = $dom->createElement('span');
    $spanHide->setAttribute("class",$spanClass);
    $spanVisible = $dom->createElement('div');
    $spanVisible->setAttribute("class",'purdue-at-a-glance__wrapper');
    $divVisible = $dom->createElement('div');
    $divVisible->setAttribute("class",'purdue-at-a-glance__wrapper');
    $divHide = $dom->createElement('div');
    $divHide->setAttribute("class",$spanClass);
    $div = $dom->createElement('div');

    $button = $dom->createElement('button', 'Expand');
    $button->setAttribute("class", "purdue-at-a-glance__expand");
    $button->setAttribute("aria-expanded", "false");
    $button->setAttribute("aria-controls", $id);

    

    if($element === "ul"){

        $ulElements = $dom->getElementsByTagName('ul')->item(0);
        $children = $ulElements->childNodes;

        $liElements = $ulElements->getElementsByTagName('li');
        $liCount = $liElements->length;
        $liContainer = [];

        

        foreach ($ulElements->childNodes as $child) {
            if ($child->nodeName === 'li') {
                $liContainer[] = $child;
            }
        }

        if($liElements->length > 3){

            foreach ($liContainer as $index => $li) {
                
                
                    if ($Counter < 3) {
                        // Wrap the first three <li> elements in the first <span>
                        $spanVisible->appendChild($li->cloneNode(true));
                    } else {
                        // Wrap all remaining <li> elements in the second <span>
                        $spanHide->appendChild($li->cloneNode(true));
                    }
                    // Remove the processed <li> element from the <ul>
                    $ulElements->removeChild($li);
                    $Counter++;
                
            }

            $ulElements->appendChild($spanVisible);
            $ulElements->appendChild($spanHide);
            $dom->appendChild($button);
            
        }

        return $dom->saveHTML();

    }else{

        $pElements = $dom->getElementsByTagName('p');
        $pCount = $pElements->length;
        $pContainer = [];

        foreach ($body->childNodes as $child) {
            if ($child->nodeName === 'p') {
                $pContainer[] = $child;
            }
        }

        if($pCount > 3){

            foreach ($pContainer as $index => $p) {
                
                    if ($Counter < 3) {
                        // Wrap the first three <li> elements in the first <span>
                        $divVisible->appendChild($p->cloneNode(true));
                    } else {
                        // Wrap all remaining <li> elements in the second <span>
                        $divHide->appendChild($p->cloneNode(true));
                    }
                    // Remove the processed <li> element from the <ul>
                    $body->removeChild($p);
                    $Counter++;
                
            }
            $body->appendChild($div);
            $div->appendChild($divVisible);
            $div->appendChild($divHide);
            $dom->appendChild($button);
            
        }
        
        return $dom->saveHTML();

        /*
            // Split text into words
            $fullText = explode(' ', $text);

            // Check if the text exceeds the word limit
            if (count($fullText) > $wordLimit) {
                // Extract the visible and extra words
                $teaser = array_slice($fullText, 0, $wordLimit);
                $details = array_slice($fullText, $wordLimit);

                // Join the visible words
                $visibleText = implode(' ', $teaser);
                // Join the extra words and wrap them in a <span>
                $detailsText = '<span id="' .$id. '" class="' . htmlspecialchars($spanClass) . '">' . implode(' ', $details). '</span>';

                // Return the combined text
                return $visibleText . ' <span class="purdue-at-a-glance__wrapper">' . $detailsText . '<button aria-expanded="false" aria-controls="' .$id. '" class="purdue-at-a-glance__expand">&hellip;Expand</button></span>';
            }

            // If text doesn't exceed the limit, return it as is
            return $text; */

    }


}
