import { __ } from '@wordpress/i18n'
import {
  PanelBody,
  PanelRow,
  CheckboxControl,
  TextControl,
  SelectControl,
  Button,
} from '@wordpress/components'
import { InspectorControls, MediaUploadCheck, MediaUpload, RichText, useBlockProps } from "@wordpress/block-editor"
import { ReactSortable } from 'react-sortablejs';
import "./editor.scss";

const edit = ( props )=>{
  const { className, setAttributes } = props;
  const { header, subheader, subtext, descText, linkType, mediaType, mediaURL, mediaAlt,imgURL, imgAlt, mediaTitle, links, ctalinks, fieldId, id} = props.attributes;
  const blockProps = useBlockProps();
  setAttributes({ fieldId: props.clientId });
  const removeItem = (linkType, identifier) => {
    if(linkType==="shortcut"){
      const newlinks = links.filter((item) => {
        return item.linkText!== identifier;
      });
      setAttributes({ links: newlinks });
    }else{
      const newlinks = ctalinks.filter((item) => {
        return item.linkText!== identifier;
      });
      setAttributes({ ctalinks: newlinks });
    }

  };
  const initialLink ={
    linkText:'',
    linkURL:'',
    buttonColor: 'gold',
    fullWidth: false,
    external:false,
  }
  if(links.length ===0){
    setAttributes({links:[initialLink]})
  }
  if(ctalinks.length ===0){
    setAttributes({ctalinks:[initialLink]})
  }
  const handleAddNew = (linkType)=>{
    if(linkType==="shortcut"){
      let newLinks=[...links];
      newLinks.push(initialLink);
      setAttributes({links: newLinks});
    }else{
      let newLinks=[...ctalinks];
      newLinks.push(initialLink);
      setAttributes({ctalinks: newLinks});
    }
  }
  const handleLinkTextChange = (linkType, text, index)=>{
    if(linkType==="shortcut"){
      let newLinks=[...links];
      newLinks[index].linkText=text;
      setAttributes({links: newLinks});
    }else{
      let newLinks=[...ctalinks];
      newLinks[index].linkText=text;
      setAttributes({ctalinks: newLinks});
    }
  }
  const handleLinkURLChange = (linkType,url, index)=>{
    if(linkType==="shortcut"){
      let newLinks=[...links];
      newLinks[index].linkURL=url;
      setAttributes({links: newLinks});
    }else{
      let newLinks=[...ctalinks];
      newLinks[index].linkURL=url;
      setAttributes({ctalinks: newLinks});
    }
  }
  const handleExternalChange = (linkType,index)=>{
    if(linkType==="shortcut"){
      let newLinks=[...links];
      newLinks[index].external=!newLinks[index].external;
      setAttributes({links: newLinks});
    }else{
      let newLinks=[...ctalinks];
      newLinks[index].external=!newLinks[index].external;
      setAttributes({ctalinks: newLinks});
    }
  }
  const handleColorChange = (color, index)=>{
    let newLinks=[...ctalinks];
    newLinks[index].buttonColor=color;
    setAttributes({ctalinks: newLinks});
  }
  const handleWidthChange = (index)=>{
    let newLinks=[...ctalinks];
    newLinks[index].fullWidth=!newLinks[index].fullWidth;
    setAttributes({ctalinks: newLinks});
  }
let editorFields;
editorFields = links.map((item, index) => {   
  return (
    <PanelBody initialOpen={false} key={index} title={item.linkText?item.linkText:`link ${index+1}`}>
      <PanelRow>
        <TextControl
          label="Link Text"
          value={ item.linkText }
          onChange={ ( val ) => handleLinkTextChange( "shortcut", val, index ) }
        />
      </PanelRow>
      <PanelRow>
        <TextControl
          label={'Link URL'}
          type="url"
          onChange={(val) => {
            handleLinkURLChange("shortcut",val, index);
          }}
          value={item.linkURL}
        />
      </PanelRow>
      <PanelRow>
        <CheckboxControl
          label="Open link in new tab?"
          checked={item.external}
          onChange={() => {
            handleExternalChange("shortcut",index);
          }}
        />
      </PanelRow>
      <Button
        style={{ marginTop: '5px' }}
        isSecondary
        onClick={() => {
          removeItem("shortcut",item.linkText);
        }}
      >
        Remove Item
      </Button>
    </PanelBody>
  );
})

let ctaLinksEditorFields;
ctaLinksEditorFields = ctalinks.map((item, index) => {   
  return (
    <PanelBody initialOpen={false} key={index} title={item.linkText?item.linkText:`link ${index+1}`}>
      <PanelRow>
        <TextControl
          label="Link Text"
          value={ item.linkText }
          onChange={ ( val ) => handleLinkTextChange( "cta", val, index ) }
        />
      </PanelRow>
      <PanelRow>
        <TextControl
          label={'Link URL'}
          type="url"
          onChange={(val) => {
            handleLinkURLChange("cta",val, index);
          }}
          value={item.linkURL}
        />
      </PanelRow>
      <PanelRow>
        <CheckboxControl
          label="Open link in new tab?"
          checked={item.external}
          onChange={() => {
            handleExternalChange("cta",index);
          }}
        />
      </PanelRow>
        <PanelRow>
          <SelectControl
            label="Choose a button color"
            value={ item.buttonColor }
            options={ [
              { label: 'Gold', value: 'gold' },
              { label: 'Black', value: 'black' },
              { label: 'White', value: 'white' },
            ] }
            onChange={(color) => {
              handleColorChange(color, index);
            }}
          />
        </PanelRow>
        <PanelRow>
        <CheckboxControl
          label="Make it full width"
          checked={item.fullWidth}
          onChange={() => {
            handleWidthChange(index);
          }}
        />
      </PanelRow>
      <Button
        style={{ marginTop: '5px' }}
        isSecondary
        onClick={() => {
          removeItem("cta",item.linkText);
        }}
      >
        Remove Item
      </Button>
    </PanelBody>
  );
})
  return [
    <InspectorControls key="1">
      <PanelBody>
        <PanelRow>
          <TextControl
            label="HTML Anchor"
            help="Enter a word without spaces to make a unique web address just for this block, called an “anchor.” It must be unique from any other anchors on the page. Then, you’ll be able to link directly to this section of your page."
            value={ id }
            onChange={ ( id ) => setAttributes( { id } ) }
          />
        </PanelRow>
        <PanelRow>
            <MediaUploadCheck>
              <MediaUpload
                onSelect={ ( img ) => {
                  setAttributes( {
                    imgURL: img.url,
                    imgAlt: img.alt,
                  } );
                }}
                allowedTypes={ ['image'] }
                render={ ( { open } ) => {
                  return imgURL !== '' ? (
                    <div>
                      <img src={imgURL} />
                      <Button
                        isSecondary                        
                        onClick={ open }
                      >
                        Select a New Image
                      </Button>
                    </div>
                  ) : (
                      <Button
                      isSecondary
                        onClick={ open }
                      >
                        Select an Image for heading
                      </Button>);
                } }
              />
            </MediaUploadCheck>
        </PanelRow>
        {
          linkType === "shortCuts"?
          <PanelRow>
          <TextControl
            label="Description of the links"
            value={ descText }
            onChange={ ( descText ) => setAttributes( { descText } ) }
          />
        </PanelRow>:""
        }
        </PanelBody>
        {
          linkType === "shortCuts"?
        <PanelBody title={__('Shortcut Links')}>
        <PanelRow>
        <ReactSortable
            list={links}
            setList={(val) => {
              let linkTexts = [],
                values = [];
                links.map((item) => linkTexts.push(item.linkText));
                val.map((item) => values.push(item.linkText));
                if (_.isEqual(linkTexts, values)) {
                  return;
                }
                setAttributes({
                  links: val,
                });
            }}
            className="sortable-posts"
          >
          {editorFields}
          </ReactSortable>
        </PanelRow>
        <hr></hr>
        <PanelRow>
          <Button
            isPrimary
            onClick={() => handleAddNew("shortcut")}
          >
            Add New Shortcut Link
          </Button>
        </PanelRow>
      </PanelBody>:
      <PanelBody title={__('CTA Links')}>
        <PanelRow>
        <ReactSortable

            list={ctalinks}
            setList={(val) => {
              let linkTexts = [],
                values = [];
                ctalinks.map((item) => linkTexts.push(item.linkText));
                val.map((item) => values.push(item.linkText));
                if (_.isEqual(linkTexts, values)) {
                  return;
                }
                setAttributes({
                  ctalinks: val,
                });
            }}
            className="sortable-posts"
          >
          {ctaLinksEditorFields}
          </ReactSortable>
        </PanelRow>
        <hr></hr>
        <PanelRow>
          <Button
            isPrimary
            onClick={() => handleAddNew("cta")}
          >
            Add New CTA Link
          </Button>
        </PanelRow>
      </PanelBody>}
    </InspectorControls>,
    <div {...blockProps} key="2">
    <div className={`purdue-home-cta-banner purdue-home-link-hero purdue-home-link-hero-editor`}>   
        <MediaUploadCheck>
          <MediaUpload
            onSelect={ ( img ) => {
              setAttributes( {
                mediaType: img.type,
                mediaURL: img.url,
                mediaAlt: img.alt,
                mediaTitle: img.title,
              } );
            } }
            render={ ( { open } ) => {
              return (
                <div className={`image`}>
                    {mediaType==="image" ? 
                    <img
                      className=""
                      src={mediaURL}
                    />:""}
                    {mediaType==="video" ? <video muted playsinline="" src={mediaURL}/>:""}
                  <div className="image-buttons">
                  <Button isPrimary onClick={ open }>{ mediaURL !== '' ? 'Select a new media' : 'Select a media' }</Button>
                  </div>                    
                </div>
              );
            } }
          />
        </MediaUploadCheck>   
        <div className={`section has-padding-exlarge`}>  
          <div className="container">
            <RichText
              tagName="p"
              value={subheader}
              className={`purdue-home-link-hero__subheader tagged-header tagged-header--gold`}
              onChange={(subheader) => {
                setAttributes({ subheader});
              }}
              placeholder="Add Section Header"
            ></RichText>
            <RichText
              tagName="h1"
              value={header}
              className={`purdue-home-link-hero__header second-level-page-heading`}
              onChange={(header) => {
                setAttributes({ header});
              }}
              placeholder="Add Page Header"
            ></RichText>
            <RichText
              tagName="p"
              value={subtext}
              className={`purdue-home-link-hero__subtext`}
              onChange={(subtext) => {
                setAttributes({ subtext});
              }}
              placeholder="Add subtext"
            ></RichText>
            {linkType==="cta"&&ctalinks.length>0 && ctalinks[0].linkURL?ctalinks.map((link, index) => {
                return  <ul className="purdue-home-button-list">                
                <li key={index} className={`${link.fullWidth?" purdue-home-button-wrap--full":""}`}><a className={`purdue-home-button${link.buttonColor==="black"?" purdue-home-button--black":""}${link.buttonColor==="white"?" purdue-home-button--white":""}`} href={link.linkURL} target={`${link.external?"_blank":"_self"}`}>{link.linkText.trim()}</a>
                    </li>
                </ul>}):""}

              <div className="purdue-home-link-hero__arrow hero-down-arrow" aria-hidden="true">
                <i className="fa-solid fa-chevron-down icon" aria-hidden="true"></i>
              </div>
          </div>
        </div>
    </div></div>,
  ];
};
export default edit;