import { InnerBlocks, useBlockProps } from '@wordpress/block-editor';

export default function save(props) {
  const {
    sizeWide,
    sizeDesk,
    sizeTab,
    sizeMo,
    size,
    useExact,
    bgColor,
    columnClass,
    alignment
  } = props.attributes;

  const classes = [
    'column',    
    useExact
      ? [sizeMo, sizeTab, sizeDesk, sizeWide].join(' ')
      : size,
    bgColor !== '' ? bgColor : '',
     columnClass !== '' ? columnClass : '',
     alignment !== '' ? alignment : '',
  ].join(' ');

  return (
    <div className={classes}>
      <InnerBlocks.Content />
    </div>
  );
}
