wp.domReady(() => {
	// Heading
	wp.blocks.registerBlockStyle('core/heading', {
		name: 'has-font-acumin-pro-condensed',
		label: wp.i18n.__('Font - Acumin Pro Condensed', 'rkv-theme'),
		isDefault: false,
	});

	wp.blocks.registerBlockStyle('core/heading', {
		name: 'has-font-united-sans-condensed',
		label: wp.i18n.__('Font - United Sans Condensed', 'rkv-theme'),
		isDefault: false,
	});

	// Group

	wp.blocks.registerBlockStyle('core/group', {
		name: 'is-narrow',
		label: wp.i18n.__('Narrow Centered', 'rkv-theme'),
		isDefault: false,
	});

	// Button
	wp.blocks.registerBlockStyle('core/button', {
		name: 'view-all',
		label: wp.i18n.__('View All >', 'rkv-theme'),
		isDefault: false,
	});

	// Image
	wp.blocks.unregisterBlockStyle('core/image', 'rounded');
	wp.blocks.registerBlockStyle('core/image', {
		name: 'full-width-parallax',
		label: wp.i18n.__('Full Width Parallax with Caption', 'rkv-theme'),
		isDefault: false,
	});

	// Gallery
	wp.blocks.registerBlockVariation('core/gallery', {
		name: 'purdue-carousel',
		title: wp.i18n.__('Slider', 'rkv-theme'),
		description: wp.i18n.__('A basic carousel slider based on the Gallery block.', 'rkv-theme'),
		icon: 'slides',
		attributes: {
			align: 'full',
			className: 'purdue_carousel_default',
			title: 'Slider',
		},
		scope: ['block', 'inserter', 'transform'],
	});

	// Quote
	wp.blocks.unregisterBlockStyle('core/quote', 'default');
	wp.blocks.unregisterBlockStyle('core/quote', 'large');
	wp.blocks.registerBlockStyle('core/quote', {
		name: 'black-background',
		label: wp.i18n.__('Black Background', 'rkv-theme'),
		isDefault: true,
	});
	wp.blocks.registerBlockStyle('core/quote', {
		name: 'white-background',
		label: wp.i18n.__('White Background', 'rkv-theme'),
		isDefault: true,
	});
});
