const { registerPlugin } = wp.plugins;
const { PluginDocumentSettingPanel } = wp.editPost;
const { ToggleControl } = wp.components;
const { useSelect } = wp.data;
const { useEntityProp } = wp.coreData;

registerPlugin('rkv-post-toggle-bylines', {
    render() {
        const meta_key = 'byline_toggle';

        const postType = useSelect((select) => select('core/editor').getCurrentPostType(), []);
		const [meta, setMeta] = useEntityProp('postType', postType, 'meta');

        if('post' !== postType) {
            return <div />;
        }

        const byline_toggle = meta[meta_key];

		const updateMetaValue = (newValue) => {
			setMeta({ ...meta, byline_toggle: newValue });
		};

        return(
            
            <PluginDocumentSettingPanel
				name="byline_toggle"
				title="Byline Toggle"
				className="byline_toggle"
			>

                <ToggleControl
                    label="Toggle Bylines on Post"
                    help={
                        byline_toggle 
                            ? 'Hide Byline on Post'
                            : 'Default shows Byline on Post'
                    }
                    checked={byline_toggle}
                    onChange={(state) => {
						updateMetaValue(state);
					}}
                />
            </PluginDocumentSettingPanel>
                

        )
    },
    icon: 'admin-users',
})