// TinySlider

import { tns } from "../../../node_modules/tiny-slider/src/tiny-slider";
if (
  document.querySelector(
    ".purdue_carousel_default_wrapper .purdue_carousel_default"
  ) !== null
) {
  const pcd_sliders_containers = document.querySelectorAll(
    ".purdue_carousel_default_wrapper"
  );

  const pcd_sliders = [];

  pcd_sliders_containers.forEach((pcd_slider_container, i) => {
    const pcd_slider = pcd_slider_container.querySelector(
      ".purdue_carousel_default"
    );
    const sizeAttribute = pcd_slider.getAttribute("data-size");
    let slideWidth = [444, 444]; // 768 and 0 breakpoint.
    switch (sizeAttribute) {
      case "medium":
        slideWidth = [300, 300];
        break;
      case "rkv-two-to-one":
        slideWidth = [666, 318];
        break;
      case "rkv-four-to-five":
        slideWidth = [432, 317];
        break;
      case "rkv-square-variation-5-slider":
        slideWidth = [318, 318];
        break;
      default:
        slideWidth = [666, 318];
    }

    pcd_sliders[i] = tns({
      container: pcd_slider,
      autoplay: false,
      mouseDrag: true,
      controls: false,
      loop: true,
      speed: 400,
      swipeAngle: false,
      gutter: 25,
      preventScrollOnTouch: "auto",
      nav: false,
      responsive: {
        768: {
          fixedWidth: slideWidth[0],
        },
        0: {
          fixedWidth: slideWidth[1],
        },
      },
    });

    pcd_sliders[i].events.on("dragStart", (info) => {
      document.getElementById(info.container.id).classList.add("tns-dragging");
    });

    pcd_sliders[i].events.on("dragEnd", (info) => {
      document
        .getElementById(info.container.id)
        .classList.remove("tns-dragging");
    });
    const dots = pcd_slider_container.querySelectorAll(".tiny-slider-navigation button");
    // Previous Button
    pcd_slider_container
      .querySelector(".tiny-slider-arrow-previous")
      .addEventListener("click", () => {
        pcd_sliders[i].goTo("prev");
      });

    // Next button
    pcd_slider_container
      .querySelector(".tiny-slider-arrow-next")
      .addEventListener("click", () => {
        pcd_sliders[i].goTo("next");
      });

      dots.forEach((dot, index) => {
        dot.addEventListener("click", () => {
          pcd_sliders[i].goTo(index);
        });
      })
      pcd_sliders[i].events.on('indexChanged', ()=>{
        dots.forEach((dot) => {
          dot.classList.remove("tns-nav-active");
        });
        dots[pcd_sliders[i].getInfo().displayIndex-1].classList.add("tns-nav-active");
      });
  });
}

import Glide from "@glidejs/glide";

function siblings(node) {
  if (node && node.parentNode) {
    var n = node.parentNode.firstChild;
    var matched = [];

    for (; n; n = n.nextSibling) {
      if (n.nodeType === 1 && n !== node) {
        matched.push(n);
      }
    }

    return matched;
  }

  return [];
}

const check_resize = (glide) => {
  if (glide.slides_count <= glide.settings.perView) {
    glide.update({ startAt: 0 }).disable();
    glide.controls.classList.add("hidden");
  } else {
    glide.enable();
    glide.controls.classList.remove("hidden");
  }
};

const CustomActiveClass = (Glide, Components, Events) => {
  const Component = {
    mount() {
      this.changeActiveSlide();
    },

    changeActiveSlide() {
      const slide = Components.Html.slides[Glide.index];
      const bullets = Components.Controls.items[0];
      const bullet = [...bullets.children].find(
        (bullet) => bullet.getAttribute("data-glide-dir") === `=${Glide.index}`
      );

      bullet.classList.remove("is-next", "is-prev");
      bullet.classList.add("is-active");
      slide.classList.remove("is-next", "is-prev");
      slide.classList.add("is-active");

      siblings(slide).forEach((sibling) => {
        sibling.classList.remove("is-active", "is-next", "is-prev");
      });
      siblings(bullet).forEach((sibling) => {
        sibling.classList.remove("is-active", "is-next", "is-prev");
      });

      if (slide.nextElementSibling) {
        slide.nextElementSibling.classList.add("is-next");
      }

      if (slide.previousElementSibling) {
        slide.previousElementSibling.classList.add("is-prev");
      }
      if (bullet.nextElementSibling) {
        bullet.nextElementSibling.classList.add("is-next");
      }

      if (bullet.previousElementSibling) {
        bullet.previousElementSibling.classList.add("is-prev");
      }
    },
  };

  Events.on("run", () => {
    Component.changeActiveSlide();
  });

  return Component;
};

//image sliders
const img_sliders = document.querySelectorAll(
  ".purdue-home-image-slider--has-text"
);

if (img_sliders && img_sliders.length > 0) {
  for (let i = 0; i < img_sliders.length; i++) {
    const loop = "carousel";
    let glide = new Glide(img_sliders[i], {
      type: loop,
      perView: 1,
      gap: 24,
    });
    console.log(glide);
    const nextButton = img_sliders[i].querySelector(".arrow--left");
    const prevButton = img_sliders[i].querySelector(".arrow--right");
    nextButton.addEventListener("click", function (event) {
      event.preventDefault();
      glide.go("<");
    });

    prevButton.addEventListener("click", function (event) {
      event.preventDefault();
      glide.go(">");
    });
    glide.slides_count =
      img_sliders[i].querySelectorAll(".glide__slide").length;
    glide.controls = img_sliders[i].querySelector(".slider-controls");
    glide.on("resize", () => {
      check_resize(glide);
    });
    glide.mount({ CustomActiveClass });
    check_resize(glide);

    //if is in a tab block, adjust size
    const parent = img_sliders[i].parentElement;
    if (parent && parent.classList.contains("purdue-home-tabs__panel")) {
      const id = parent.getAttribute("aria-labelledby");
      if (id) {
        const panelButton = document.querySelector(`#${id}`);
        if (panelButton) {
          panelButton.addEventListener("click", () => {
            check_resize(glide);
          });
        }
      }
    }
  }
}

//fix cursor on safari
const cards = document.querySelectorAll(
  ".purdue-home-image-slider .purdue-home-image-slider__card"
);
if (cards && cards.length > 0) {
  cards.forEach((item) => {
    item.addEventListener("mousedown", (event) => {
      event.preventDefault();
    });
  });
}
