// TinySlider
import { tns } from '../../../node_modules/tiny-slider/src/tiny-slider';

if (document.querySelector('.rkv-block-cover-slider.purdue-variation-1') !== null) {
	// Content slider
	const variation_1_sliders = document.querySelectorAll(
		'.rkv-block-cover-slider.purdue-variation-1'
	);

	const variation_1_slider_containers = [];
	const variation_1_slider_backgrounds = [];

	variation_1_sliders.forEach((variation_1_slider, i) => {
		variation_1_slider_containers[i] = tns({
			container: variation_1_slider.querySelector('.rkv-block-cover-slider-slides-container'),
			items: 1,
			autoplay: false,
			swipeAngle: false,
			speed: 400,
			navPosition: 'bottom',
			controlsPosition: 'bottom',
			navContainer: variation_1_slider.querySelector('.rkv-block-cover-slider-slides-navigation'),
			controlsContainer: variation_1_slider.querySelector(
				'.rkv-block-cover-slider-slides-controls'
			),
			mouseDrag: true,
			autoHeight: true,
			preventScrollOnTouch: 'auto',
		});

		const setBackgroundImage = (info) => {
			const activeSlider = info.container.querySelector(
				'.cover-slider__background.tns-slide-active'
			);
			const backgroundImage =
				window.innerWidth < 801
					? activeSlider.getAttribute('data-src-half')
					: activeSlider.getAttribute('data-src');
			activeSlider.style.backgroundImage = 'url(' + backgroundImage + ')';

			const activeSlideWithBackgroundVideo = info.container.querySelector(
				'.cover-slider__background.tns-slide-active video'
			);
			if (activeSlideWithBackgroundVideo !== null) {
				activeSlideWithBackgroundVideo.play();
			}
		};

		// Background cover slider
		variation_1_slider_backgrounds[i] = tns({
			container: variation_1_slider.querySelector('.rkv-block-cover-slider-background-slides'),
			items: 1,
			autoplay: false,
			swipeAngle: false,
			speed: 400,
			controls: false,
			nav: false,
			viewportMax: 100,
			autoplayButtonOutput: false,
			onInit: setBackgroundImage,
			preventScrollOnTouch: 'auto',
		});

		variation_1_slider_backgrounds[i].events.on('transitionStart', setBackgroundImage);
		let startIndex;
		variation_1_slider_containers[i].events.on('touchStart', (info) => {
			startIndex = info.index;
		});
		variation_1_slider_containers[i].events.on('touchEnd', (info) => {
			if (startIndex < info.index) {
				variation_1_slider_backgrounds[i].goTo('next');
				setBackgroundImage;
			} else if (startIndex > info.index) {
				variation_1_slider_backgrounds[i].goTo('prev');
				setBackgroundImage;
			}
		});
		variation_1_slider_containers[i].events.on('dragStart', (info) => {
			startIndex = info.index;
		});
		variation_1_slider_containers[i].events.on('dragEnd', (info) => {
			if (startIndex < info.index) {
				variation_1_slider_backgrounds[i].goTo('next');
				setBackgroundImage;
			} else if (startIndex > info.index) {
				variation_1_slider_backgrounds[i].goTo('prev');
				setBackgroundImage;
			}
		});

		// Previous Button
		variation_1_slider.querySelector('.rkv-block-cover-slider-slides-controls-previous').onclick =
			function () {
				variation_1_slider_backgrounds[i].goTo('prev');
			};

		// Next button
		variation_1_slider.querySelector('.rkv-block-cover-slider-slides-controls-next').onclick =
			function () {
				variation_1_slider_backgrounds[i].goTo('next');
			};

		// Navigation buttons
		// variation_1_slider_containers[i].events.on('indexChanged', (info) => {
		// 	variation_1_slider_backgrounds[i].goTo(info.index);
		// });
		const buttons = variation_1_slider.querySelectorAll(
			'.rkv-block-cover-slider-slides-navigation button'
		);
		if (buttons.length > 0) {
			buttons.forEach((b) => {
				b.onclick = () => {
					variation_1_slider_backgrounds[i].goTo(parseInt(b.getAttribute('data-nav')));
				};
			});
		}
	});

	// Videos
	// Play on Hover
	// If there is a video element

	const pauseVideoBackgroundOnActiveSlideforSlider = (slider) => {
		const active_slide_with_video = slider.querySelector(
			'.rkv-block-cover-slider-background-slides .tns-slide-active video'
		);
		if (active_slide_with_video !== null) {
			active_slide_with_video.pause();
		}
	};

	const playVideoBackgroundOnActiveSlideforSlider = (slider) => {
		const active_slide_with_video = slider.querySelector(
			'.rkv-block-cover-slider-background-slides .tns-slide-active video'
		);
		if (active_slide_with_video !== null) {
			active_slide_with_video.play();
		}
	};

	const OnSliderVariation1VideoHover = () => {
		if (
			document.querySelector(
				'.rkv-block-cover-slider.purdue-variation-1 .cover-slider__item.cover-slider__background video'
			) !== null
		) {
			const sliders_with_slides_with_video_backgrounds = document.querySelectorAll(
				'.rkv-block-cover-slider.purdue-variation-1'
			);

			sliders_with_slides_with_video_backgrounds.forEach((slider) => {
				// Set up the video elements
				const card_video_elements = slider.querySelectorAll(
					'.cover-slider__item.cover-slider__background video'
				);
				card_video_elements.forEach((video_element) => {
					if (video_element !== null) {
						video_element.loop = true; // Make sure the video loops
						video_element.muted = true; // Make sure the video is muted
					}
				});

				// Play on mouse over
				slider.addEventListener('mouseover', () => {
					playVideoBackgroundOnActiveSlideforSlider(slider);
				});

				// Pause on mouse out
				slider.addEventListener('mouseout', () => {
					pauseVideoBackgroundOnActiveSlideforSlider(slider);
				});

				// IntersectionObserver to pause/play the video.
				const observer = new IntersectionObserver(
					(e) => {
						if (e[0].isIntersecting) {
							playVideoBackgroundOnActiveSlideforSlider(slider);
						} else {
							pauseVideoBackgroundOnActiveSlideforSlider(slider);
						}
					},
					{
						root: null,
						rootMargin: '0px',
						threshold: 0.5,
					}
				);

				observer.observe(slider);
			});
		}
	};

	OnSliderVariation1VideoHover();
}
