// TinySlider
import { tns } from '../../../node_modules/tiny-slider/src/tiny-slider';
if (document.querySelector('.rkv-default-archive-card-slider.purdue-variation-3') !== null) {
	// Content slider
	const variation_3_sliders = document.querySelectorAll(
		'.rkv-default-archive-card-slider.purdue-variation-3'
	);

	const variation_3_slider_containers = [];

	variation_3_sliders.forEach((variation_3_slider, i) => {
		variation_3_slider_containers[i] = tns({
			container: variation_3_slider.querySelector('.rkv-default-archive-card-slider-slides'),
			autoplay: false,
			mouseDrag: true,
			loop: true,
			speed: 400,
			swipeAngle: false,
			fixedWidth: 318,
			controlsPosition: 'bottom',
			navPosition: 'bottom',
			navAsThumbnails: true,
			responsive: {
				0: {
					gutter: 10,
				},
				568: {
					gutter: 25,
				},
			},
			preventScrollOnTouch: 'auto',
		});

		variation_3_slider_containers[i].events.on('dragMove', (e) => {
			e.container.classList.add('tns-dragging');
		});

		variation_3_slider_containers[i].events.on('dragEnd', (e) => {
			e.container.classList.remove('tns-dragging');
		});
	});
}
