// TinySlider
import { tns } from '../../../node_modules/tiny-slider/src/tiny-slider';
if (document.querySelector('.rkv-slider-details-and-box.purdue-variation-4') !== null) {
	// Content slider
	const variation_4_sliders = document.querySelectorAll(
		'.rkv-slider-details-and-box.purdue-variation-4'
	);

	const variation_4_slider_containers = [];
	const variation_4_slider_backgrounds = [];

	variation_4_sliders.forEach((variation_4_slider, i) => {
		variation_4_slider_containers[i] = tns({
			container: variation_4_slider.querySelector('.rkv-slider-details-and-box-slides'),
			items: 1,
			autoplay: false,
			swipeAngle: false,
			speed: 400,
			loop: true,
			navPosition: 'bottom',
			controlsPosition: 'bottom',
			navContainer: variation_4_slider.querySelector(
				'.rkv-slider-details-and-box-slides-navigation'
			),
			controlsContainer: variation_4_slider.querySelector(
				'.rkv-slider-details-and-box-slides-controls'
			),
			mouseDrag: true,
			autoHeight: false,
			preventScrollOnTouch: 'auto',
		});

		// Background cover slider
		variation_4_slider_backgrounds[i] = tns({
			container: variation_4_slider.querySelector('.rkv-slider-details-and-box-background-slides'),
			items: 1,
			autoplay: false,
			swipeAngle: false,
			speed: 400,
			loop: true,
			controls: false,
			nav: false,
			viewportMax: 100,
			autoplayButtonOutput: false,
			preventScrollOnTouch: 'auto',
		});

		// Previous Button
		variation_4_slider.querySelector(
			'.rkv-slider-details-and-box-slides-controls-previous'
		).onclick = function () {
			variation_4_slider_backgrounds[i].goTo('prev');
		};

		// Next button
		variation_4_slider.querySelector('.rkv-slider-details-and-box-slides-controls-next').onclick =
			function () {
				variation_4_slider_backgrounds[i].goTo('next');
			};
		let startIndex;
		variation_4_slider_containers[i].events.on('touchStart', (info) => {
			startIndex = info.index;
		});
		variation_4_slider_containers[i].events.on('touchEnd', (info) => {
			if (startIndex < info.index) {
				variation_4_slider_backgrounds[i].goTo('next');
			} else if (startIndex > info.index) {
				variation_4_slider_backgrounds[i].goTo('prev');
			}
		});
		variation_4_slider_containers[i].events.on('dragStart', (info) => {
			startIndex = info.index;
		});
		variation_4_slider_containers[i].events.on('dragEnd', (info) => {
			if (startIndex < info.index) {
				variation_4_slider_backgrounds[i].goTo('next');
			} else if (startIndex > info.index) {
				variation_4_slider_backgrounds[i].goTo('prev');
			}
		});
		// Navigation buttons
		// variation_4_slider_containers[i].events.on('indexChanged', (info) => {
		// 	variation_4_slider_backgrounds[i].goTo(info.index);
		// });
		const buttons = variation_4_slider.querySelectorAll(
			'.rkv-slider-details-and-box-slides-navigation button'
		);
		if (buttons.length > 0) {
			buttons.forEach((b) => {
				b.onclick = () => {
					variation_4_slider_backgrounds[i].goTo(parseInt(b.getAttribute('data-nav')));
				};
			});
		}
	});
}
