const defaultConfig = require( '@wordpress/scripts/config/webpack.config.js' );
const MiniCssExtractPlugin = require("mini-css-extract-plugin");

const {
	getWebpackEntryPoints
} = require( '@wordpress/scripts/utils' );

const blockEntry = getWebpackEntryPoints();

module.exports = {
  ...defaultConfig,
  entry: {
    ...blockEntry,
    app:['./src/js/front-end/app.js', './src/style/front-end/app.scss'],
    admin:['./src/js/back-end/admin.js', './src/style/back-end/admin.scss'],
  },
  
  optimization: {
    splitChunks: {
      cacheGroups: {
        ...defaultConfig.optimization.splitChunks.cacheGroups,
      }
    }
  }
}