import { __ } from '@wordpress/i18n';
import {
    PanelBody,
    PanelRow,
    CheckboxControl,
    TextControl,
    SelectControl,
    Button,
    Disabled
} from '@wordpress/components';

import { InspectorControls, MediaUploadCheck, MediaUpload, InnerBlocks, RichText, useBlockProps } from '@wordpress/block-editor';
import { ReactSortable } from 'react-sortablejs';
const BLOCKS_TEMPLATE = [
    [ 'core/paragraph', { placeholder: 'Body content copy' } ],
];

const edit = ( props )=>{
  const { className, setAttributes } = props;
  const { background, header, paddingTop, paddingBottom, cards, id} = props.attributes;
  const blockProps = useBlockProps();
  const removeCard= (identifier) => {
    const newCards = cards.filter((item) => {
      return item.id!== identifier;
    });
    setAttributes({ cards: newCards });
  };
  const initialCards={
    id:0,
    type:"story",
    backgroundType: 'image',
    backgroundColor: '',
    backgroundURL:'',
    backgroundAlt:'',
    mediaType:'image',
    mediaURL:'',
    mediaAlt:'',
    mediaTitle:'', 
    youtube:'',
    citeName:'',
    citeTitle:'',
    tag:'',
    title:'',
    subtext:'',
    linkText1:'',
    linkURL1:'',
    color1:'gold',
    external1:true,
    linkText2:'',
    linkURL2:'',
    color2:'gold',
    external2:true,
  }
  if(cards.length ===0){
    setAttributes({cards:[initialCards]})
  }
  const handleAddNew = ()=>{
    let newCards=[...cards];
    let newInitial=initialCards;
    newInitial.id=newCards.length;
    newCards.push(newInitial);
    setAttributes({ cards: newCards });
  }
  const handleCardBackgroundType = ( type, index ) => {
    let newCards=[...cards];
    newCards[ index ].backgroundType = type;
    setAttributes({ cards: newCards });
  };
  const handleCardbBackgroundColor = ( color, index ) => {
    let newCards=[...cards];
    newCards[ index ].backgroundColor = color;
    setAttributes({ cards: newCards });
  };
  const handleCardChangeBackground = ( img, index ) => {
    let newCards=[...cards];
    newCards[ index ].backgroundURL = img.url;
    newCards[ index ].backgroundAlt = img.alt;
    setAttributes({ cards: newCards });
  };
  const handleCardChangeImage = ( img, index ) => {
    let newCards=[...cards];
    newCards[ index ].mediaType = img.type;
    newCards[ index ].mediaURL = img.url;
    newCards[ index ].mediaAlt = img.alt;
    newCards[ index ].mediaTitle = img.title;
    setAttributes({ cards: newCards });
  };
  const handleTypeChange = (type, index)=>{
    let newCards=[...cards];
    newCards[index].type=type;
    setAttributes({ cards: newCards });
  }
  const handleYoutubeLinkChange = (url, index)=>{
    let newCards=[...cards];
    newCards[index].youtube=url;
    setAttributes({ cards: newCards });
  }
  const handleCiteNameChange = (citeName, index)=>{
    let newCards=[...cards];
    newCards[index].citeName=citeName;
    setAttributes({ cards: newCards });
  }
  const handleCiteTitleChange = (citeTitle, index)=>{
    let newCards=[...cards];
    newCards[index].citeTitle=citeTitle;
    setAttributes({ cards: newCards });
  }
  const handleTagChange = (tag, index)=>{
    let newCards=[...cards];
    newCards[index].tag=tag;
    setAttributes({ cards: newCards });
  }
  const handleTitleChange = (title, index)=>{
    let newCards=[...cards];
    newCards[index].title=title;
    setAttributes({ cards: newCards });
  }
  const handleSubtextChange = (subtext, index)=>{
    let newCards=[...cards];
    newCards[index].subtext=subtext;
    setAttributes({ cards: newCards });
  }
  const handleLinkText1Change = (linkText, index)=>{
    let newCards=[...cards];
    newCards[index].linkText1=linkText;
    setAttributes({ cards: newCards });
  }
  const handleLinkURL1Change = (url, index)=>{
    let newCards=[...cards];
    newCards[index].linkURL1=url;
    setAttributes({ cards: newCards });
  }
  const handleExternal1Change = (index)=>{
    let newCards=[...cards];
    newCards[index].external1=!newCards[index].external;
    setAttributes({ cards: newCards });
  }
  const handleLinkText2Change = (linkText, index)=>{
    let newCards=[...cards];
    newCards[index].linkText2=linkText;
    setAttributes({ cards: newCards });
  }
  const handleColor1Change = (color, index)=>{
    let newCards=[...cards];
    newCards[index].color1=color;
    setAttributes({ cards: newCards });
  }
  const handleColor2Change = (color, index)=>{
    let newCards=[...cards];
    newCards[index].color2=color;
    setAttributes({ cards: newCards });
  }
  const handleLinkURL2Change = (url, index)=>{
    let newCards=[...cards];
    newCards[index].linkURL2=url;
    setAttributes({ cards: newCards });
  }
  const handleExternal2Change = (index)=>{
    let newCards=[...cards];
    newCards[index].external2=!newCards[index].external;
    setAttributes({ cards: newCards });
  }
let editorFields;
editorFields = cards.map((item, index) => {   
  return (
    <PanelBody initialOpen={false} key={index} title={`Card ${index+1}`}>
        <PanelRow>
          <SelectControl
            label="Select Background Type"
            value={ item.backgroundType }
            options={ [
              { label: 'Image', value: 'image' },
              { label: 'Color', value: 'color' },
            ] }
            onChange={(type) => {
              handleCardBackgroundType(type, index);
            }}
          />
        </PanelRow>
        {
        item.backgroundType === "color"?
        <PanelRow>
          <SelectControl
            label="Select Background Color"
            value={ item.backgroundColor }
            options={ [
              { label: 'White', value: 'white' },
              { label: 'Gold', value: 'gold' },
              { label: 'Black', value: 'black' },
              { label: 'Gray', value: 'gray' },
            ] }
            onChange={(color) => {
              handleCardbBackgroundColor(color, index);
            }}
          />
        </PanelRow>:""}
        {item.backgroundType === "image"? 
        <PanelRow>
          <MediaUploadCheck>
            <MediaUpload
              onSelect={ ( img ) => handleCardChangeBackground (img, index)}
              render={ ( { open } ) => {
                return item.backgroundURL !== '' ? (
                  <div>
                      <img src={item.backgroundURL} />
                    <Button
                      isSecondary                        
                      onClick={ open }
                    >
                      Select a New background Image
                    </Button>
                  </div>
                ) : (
                    <Button
                    isSecondary
                      onClick={ open }
                    >
                      Select a background image
                    </Button>);
              } }
            />
          </MediaUploadCheck>
      </PanelRow>:""}
      {item.backgroundType === "image"? 
      <PanelRow>
          <MediaUploadCheck>
              <MediaUpload
                onSelect={ ( img ) => handleCardChangeImage (img, index)}
                render={ ( { open } ) => {
                  return item.mediaURL !== '' ? (
                    <div>
                      {item.mediaType === 'image'?
                        <img src={item.mediaURL} />
                      :""}
                      {item.mediaType === 'video'?
                        <Disabled>
                          <video muted playsinline="" title={item.mediaTitle} src={item.mediaURL}>
                          </video>
                        </Disabled>
                      :""}
                      <Button
                        isSecondary                        
                        onClick={ open }
                      >
                        Select a new featured media
                      </Button>
                    </div>
                  ) : (
                      <Button
                      isSecondary
                        onClick={ open }
                      >
                         Select a featured media
                      </Button>);
                } }
              />
            </MediaUploadCheck>
      </PanelRow>:""}
      <PanelRow>
          <SelectControl
            label="Choose Card Type"
            value={ item.type }
            options={ [
              { label: 'Story', value: 'story' },
              { label: 'Quote', value: 'quote' },
              { label: 'Profile', value: 'profile' },
            ] }
            onChange={ ( type ) => handleTypeChange(type, index) }
          />
        </PanelRow>
      <PanelRow>
        <TextControl
          label={'Optional YouTube Link URL'}
          type="url"
          onChange={(val) => {
            handleYoutubeLinkChange(val, index);
          }}
          value={item.youtube}
        />
      </PanelRow>
      {
        item.type==="story" || item.type === "profile"?
        <PanelRow>
          <TextControl
            label="Title"
            value={ item.title }
            onChange={ ( val ) => handleTitleChange( val, index ) }
          />
        </PanelRow>:""
      }
      {
        item.type==="story"?
        <PanelRow>
          <TextControl
            label="Tag"
            value={ item.tag }
            onChange={ ( val ) => handleTagChange( val, index ) }
          />
        </PanelRow>:""
      }
      {
        item.type==="quote"  || item.type==="profile"?
        <PanelRow>
          <TextControl
            label="Cite Name"
            value={ item.citeName }
            onChange={ ( val ) => handleCiteNameChange( val, index ) }
          />
        </PanelRow>:""
      }
      {
        item.type==="quote" || item.type==="profile"?
        <PanelRow>
          <TextControl
            label="Cite Title"
            value={ item.citeTitle }
            onChange={ ( val ) => handleCiteTitleChange( val, index ) }
          />
        </PanelRow>:""
      }
      <PanelRow>
        <TextControl
          label="Content"
          value={ item.subtext }
          onChange={ ( val ) => handleSubtextChange( val, index ) }
        />
      </PanelRow>
      {
        item.type!=="profile" && item.youtube==="" ?
      <PanelRow>
        <TextControl
          label={'Link Text #1'}
          onChange={(val) => {
            handleLinkText1Change(val, index);
          }}
          value={item.linkText1}
        />
      </PanelRow>:""}
      {
        item.type!=="profile" &&  item.youtube===""?
      <PanelRow>
        <TextControl
          label={'Link URL #1'}
          type="url"
          onChange={(val) => {
            handleLinkURL1Change(val, index);
          }}
          value={item.linkURL1}
        />
      </PanelRow>:""}
      {
        item.youtube==="" && item.type!="profile"?
      <PanelRow>
        <CheckboxControl
          label="Open link #1 in new tab?"
          checked={item.external1}
          onChange={() => {
            handleExternal1Change(index);
          }}
        />
      </PanelRow>:""}
      {
        item.youtube==="" && item.type!=="profile"?
        <PanelRow>
          <SelectControl
            label="Choose a button color"
            value={ item.color1 }
            options={ [
              { label: 'Gold', value: 'gold' },
              { label: 'Black', value: 'black' },
            ] }
            onChange={(color) => {
              handleColor1Change(color, index);
            }}
          />
        </PanelRow>:""}
      {
       item.type !== "profile" && item.linkURL1 && item.youtube===""?
        <PanelRow>
        <TextControl
          label={'Link Text #2'}
          onChange={(val) => {
            handleLinkText2Change(val, index);
          }}
          value={item.linkText2}
        />
      </PanelRow>:""
      }
      {
         item.type !== "profile" && item.linkURL1 && item.youtube===""?
         <PanelRow>
          <TextControl
            label={'Link URL #2'}
            type="url"
            onChange={(val) => {
              handleLinkURL2Change(val, index);
            }}
            value={item.linkURL2}
          />
        </PanelRow>:""
      }
      {
         item.type !== "profile" && item.linkURL1 && item.youtube===""?
         <PanelRow>
          <CheckboxControl
            label="Open link #2 in new tab?"
            checked={item.external2}
            onChange={() => {
              handleExternal2Change(index);
            }}
          />
        </PanelRow>:""
      }
      {
        item.type !== "profile" && item.linkURL1 && item.youtube===""?
        <PanelRow>
          <SelectControl
            label="Choose a button color"
            value={ item.color2 }
            options={ [
              { label: 'Gold', value: 'gold' },
              { label: 'Black', value: 'black' },
            ] }
            onChange={(color) => {
              handleColor2Change(color, index);
            }}
          />
        </PanelRow>:""
      }
      <Button
        style={{ marginTop: '5px' }}
        isSecondary
        onClick={() => {
          removeCard(item.id);
        }}
      >
        Remove Card
      </Button>
    </PanelBody>
  );
})
function getVideoId(url) {
  const regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|&v=)([^#&?]*).*/;
  const match = url?.match(regExp);

  return (match && match[2].length === 11)
    ? match[2]
    : null;
}
  return [
    <InspectorControls key="1">
      <PanelBody>
        <PanelRow>
          <SelectControl
            label="Choose the background"
            value={ background }
            options={ [
              { label: 'None', value: 'none' },
              { label: 'Gold', value: 'gold' },
              { label: 'Black', value: 'black' },
              { label: 'Gray', value: 'gray' },
            ] }
            onChange={ ( background ) => setAttributes( { background } ) }
          />
        </PanelRow>
        <PanelRow>
          <SelectControl
            label="Padding at the top"
            value={ paddingTop }
            options={
              [
                { value: 'has-padding-top-none', label: 'None' },
                { value: 'has-padding-top-small', label: 'Small' },
                { value: '', label: 'Medium' },
                { value: 'has-padding-top-large', label: 'Large' },
              ]
            }
            onChange={ ( paddingTop ) => {
              setAttributes( { paddingTop } )
            } }
          />
        </PanelRow>
        <PanelRow>
          <SelectControl
            label="Padding at the bottom"
            value={ paddingBottom }
            options={
              [
                { value: 'has-padding-bottom-none', label: 'None' },
                { value: 'has-padding-bottom-small', label: 'Small' },
                { value: '', label: 'Medium' },
                { value: 'has-padding-bottom-large', label: 'Large' },
              ]
            }
            onChange={ ( paddingBottom ) => {
              setAttributes( { paddingBottom } )
            } }
          />
        </PanelRow>
        <PanelRow>
          <TextControl
            label="HTML Anchor"
            help="Enter a word without spaces to make a unique web address just for this block, called an “anchor.” It must be unique from any other anchors on the page. Then, you’ll be able to link directly to this section of your page."
            value={ id }
            onChange={ ( id ) => setAttributes( { id } ) }
          />
        </PanelRow>
        </PanelBody>
        <PanelBody title={__('Cards')}>
        <PanelRow>
        <ReactSortable
            list={cards}
            setList={(val) => {
              let ids = [],
                values = [];
                cards.map((item) => ids.push(item.id));
                val.map((item) => values.push(item.id));
                if (_.isEqual(ids, values)) {
                  return;
                }
                setAttributes({
                  cards: val,
                });
            }}
            className="sortable-posts"
          >
          {editorFields}
          </ReactSortable>
        </PanelRow>
        <hr></hr>
        <PanelRow>
          <Button
          isPrimary
            onClick={() => handleAddNew()}
          >
            Add New Card
          </Button>
        </PanelRow>
      </PanelBody>
    </InspectorControls>,
    <div {...blockProps} key="2">
    <div className={`purdue-home-cta-carousel purdue-home-cta-carousel-editor`}>   
        <div className={`section has-${background}-background ${paddingTop?` ${paddingTop}`:''}${paddingBottom?` ${paddingBottom}`:''}`}>  
          <div className={`container`}>
            <div className={`tagged-header-container`}>
                <RichText
                  tagName="h2"
                  value={header}
                  className={`tagged-header${background!=="gold"?" tagged-header--gold":""}`}
                  onChange={(header) => {
                    setAttributes({ header});
                  }}
                  placeholder="Add header"
                ></RichText>
              </div>
              {
                cards && cards.length>0?
                <div className="purdue-home-cta-carousel__cards">
                  <div className={`glide`}>
                  <div className="glide__track" data-glide-el="track">
                  <div className="glide__slides">
                  {cards.map((item, index) => {
                    const videoId = getVideoId(item.youtube);
                    const defaultThumb = `https://img.youtube.com/vi/${videoId}/maxresdefault.jpg`;
                    const mediaURL = item.mediaURL? item.mediaURL:defaultThumb;
                    const backgroundColor = `has-${item.backgroundColor}-background`;
                    let backgroundImage = `"backgroundImage:url(${ item.backgroundURL })"`
                     //style={ { backgroundImage: `url(${ item.backgroundURL })` } }
                    return  <div key={index} className="glide__slide">
                      <div className={`purdue-home-cta-card purdue-home-cta-card--horizontal ${backgroundColor} purdue-home-cta-card-carousel--${item.type}`}
                       style={item.backgroundURL ? { backgroundImage: `url(${item.backgroundURL})` } : undefined}
                      >
                        <div
                          className="purdue-home-cta-carousel__card-image"
                        >
                        <div
                          className="image is-16by9"
                        >
                           {item.mediaType === 'image'?
                            <img
                            className="purdue-home-background-image"
                            src={mediaURL}
                          />:""
                          }
                          {item.mediaType === 'video'?
                            <Disabled>
                              <video muted playsinline="" title={item.mediaTitle} src={mediaURL}>
                              </video>
                            </Disabled>
                          :""}
                          {item.youtube ?
                            <div className="flex-container--align-center">
                              <span className="cta-link purdue-home-cta-card__link">Watch Video</span>
                              <i className="fa-regular fa-circle-play cta-icon"></i>
                          </div>:""}
                      </div>
                      </div>
                      <div className="purdue-home-cta-carousel__card-content">

                          {
                            item.type==="quote"?
                            <div className="purdue-home-cta-carousel__card-tag">
                              {
                               item.citeName?
                                <span className="purdue-home-cta-carousel__cite-name">{item.citeName}</span>:""
                              }
                              {
                                item.citeTitle?
                                <span className="purdue-home-cta-carousel__cite-title">{item.citeTitle}</span>:""
                              }
                            </div>:""
                          }
                          {
                            item.type==="story" && item.tag?
                            <div className="purdue-home-cta-carousel__card-tag">
                              <span className="purdue-home-cta-carousel__cite-name">{item.tag}</span>
                            </div>:""
                          }
                          {
                            item.type==="story"?
                            <div className="purdue-home-cta-carousel__story-wrap">
                              {
                               item.title?
                                <p className="purdue-home-cta-carousel__story-title">{item.title}</p>:""
                              }
                              {
                                item.subtext?
                                <p className="purdue-home-cta-carousel__story-content">{item.subtext}</p>:""
                              }
                            </div>:""
                          }
                          {
                            item.type==="quote"&&item.subtext?
                              <p className="purdue-home-cta-carousel__quote-content">{item.subtext}</p>:""
                          }

                          {
                            item.type==="profile"?
                            <div className="purdue-home-cta-carousel__story-wrap cta-profile">
                              {
                               item.title?
                                <p className="purdue-home-cta-carousel__story-title">{item.title}</p>:""
                              }
                              {
                                item.subtext?
                                <p className="purdue-home-cta-carousel__story-content">{item.subtext}</p>:""
                              }
                            </div>:""
                          }
                          
                          {
                            item.type === "profile" ?
                            <div className="purdue-home-cta-carousel__card-tag">
                              {
                               item.citeName?
                                <span className="purdue-home-cta-carousel__cite-name">{item.citeName}</span>:""
                              }
                              {
                                item.citeTitle?
                                <><br /><span className="purdue-home-cta-carousel__cite-title">{item.citeTitle}</span></>:""
                              }
                            </div>:""
                          }

                          {
                            item.type !== "profile" && item.linkURL1 && item.youtube===""?
                            <ul className="purdue-home-button-list">
                              <li><a className={`purdue-home-button${item.color1==="black"?" purdue-home-button--black":""}`} href={item.linkURL1} target={`${item.external1?"_blank":"_self"}`}>{item.linkText1.trim()}</a></li>
                              {
                                item.linkURL2&& item.youtube===""?
                                <li><a className={`purdue-home-button${item.color2==="black"?" purdue-home-button--black":""}`} href={item.linkURL2} target={`${item.external2?"_blank":"_self"}`}>{item.linkText2.trim()}</a></li>
                                :""
                              }
                            </ul>:""                                
                          }
                        </div>
                     </div>
                  </div>
                  })
                }
                </div>
                </div>
                </div>
              </div>:""
              }

          </div>
        </div>
    </div>
    </div>
  ];
};

export default edit;