import { __ } from '@wordpress/i18n';
import {
  PanelBody,
  PanelRow,
  CheckboxControl,
  TextControl,
  SelectControl,
  Button,
} from '@wordpress/components';
import { InspectorControls, MediaUploadCheck, MediaUpload, InnerBlocks, RichText, useBlockProps } from '@wordpress/block-editor';
import { ReactSortable } from 'react-sortablejs';
const BLOCKS_TEMPLATE = [
  [ 'core/paragraph', { placeholder: 'Body content copy' } ],
];

const edit = ( props )=>{
  const { className, setAttributes } = props;
  const { background, header, cards, id} = props.attributes;
  const blockProps = useBlockProps();
  const removeCard= (identifier) => {
    const newCards = cards.filter((item) => {
      return item.title!== identifier;
    });
    setAttributes({ cards: newCards });
  };
  const initialCards={
    mediaId:0,
    mediaURL:'',
    mediaAlt:'',
    title:'',
    subtext:'',
    linkURL:'',
    external:true,
  }
  if(cards && cards.length ===0){
    setAttributes({cards:[initialCards]})
  }
  const handleAddNew = ()=>{
    let newCards=[...cards];
    newCards.push(initialCards);
    setAttributes({ cards: newCards });
  }
  const handleCardChangeImage = ( img, index ) => {
    let newCards=[...cards];
    newCards[ index ].mediaId = img.id;
    newCards[ index ].mediaURL = img.url;
    newCards[ index ].mediaAlt = img.alt;
    setAttributes({ cards: newCards });
};
  const handleTitleChange = (title, index)=>{
    let newCards=[...cards];
    newCards[index].title=title;
    setAttributes({ cards: newCards });
  }
  const handleSubtextChange = (subtext, index)=>{
    let newCards=[...cards];
    newCards[index].subtext=subtext;
    setAttributes({ cards: newCards });
  }
  const handleLinkURLChange = (url, index)=>{
    let newCards=[...cards];
    newCards[index].linkURL=url;
    setAttributes({ cards: newCards });
  }
  const handleExternalChange = (index)=>{
    let newCards=[...cards];
    newCards[index].external=!newCards[index].external;
    setAttributes({ cards: newCards });
  }
let editorFields;

editorFields = cards.map((item, index) => {   
  return (
    <PanelBody initialOpen={false} key={index} title={item.title?item.title:`Card ${index+1}`}>
        <PanelRow>
          <MediaUploadCheck>
            <MediaUpload
              onSelect={ ( img ) => handleCardChangeImage (img, index)}
              render={ ( { open } ) => {
                return item.mediaURL !== '' ? (
                  <div>
                      <img src={item.mediaURL} />
                    <Button
                      isSecondary                        
                      onClick={ open }
                    >
                      Select a new image
                    </Button>
                  </div>
                ) : (
                    <Button
                    isSecondary
                      onClick={ open }
                    >
                      Select an image
                    </Button>);
              } }
            />
          </MediaUploadCheck>
      </PanelRow>
      <PanelRow>
        <TextControl
          label="Title"
          value={ item.title }
          onChange={ ( val ) => handleTitleChange( val, index ) }
        />
      </PanelRow>
      <PanelRow>
        <TextControl
          label="Subtext"
          value={ item.subtext }
          onChange={ ( val ) => handleSubtextChange( val, index ) }
        />
      </PanelRow>
      <PanelRow>
        <TextControl
          label={'Link URL'}
          type="url"
          onChange={(val) => {
            handleLinkURLChange(val, index);
          }}
          value={item.linkURL}
        />
      </PanelRow>
      <PanelRow>
        <CheckboxControl
          label="Open link in new tab?"
          checked={item.external}
          onChange={() => {
            handleExternalChange(index);
          }}
        />
      </PanelRow>
      <Button
        style={{ marginTop: '5px' }}
        isSecondary
        onClick={() => {
          removeCard(item.title);
        }}
      >
        Remove Card
      </Button>
    </PanelBody>
  );
})
  return [
    <InspectorControls key="1">
      <PanelBody>
      <PanelRow>
          <SelectControl
            label="Choose the background"
            value={ background }
            options={ [
              { label: 'None', value: 'none' },
              { label: 'Gold', value: 'gold' },
              { label: 'Black', value: 'black' },
              { label: 'Gray', value: 'gray' },
            ] }
            onChange={ ( background ) => setAttributes( { background } ) }
          />
        </PanelRow>
        <PanelRow>
          <TextControl
            label="HTML Anchor"
            help="Enter a word without spaces to make a unique web address just for this block, called an “anchor.” It must be unique from any other anchors on the page. Then, you’ll be able to link directly to this section of your page."
            value={ id }
            onChange={ ( id ) => setAttributes( { id } ) }
          />
        </PanelRow>
        </PanelBody>
        <PanelBody title={__('Cards')}>
        <PanelRow>
        <ReactSortable

            list={cards}
            setList={(val) => {
              let titles = [],
                values = [];
                cards.map((item) => titles.push(item.title));
                val.map((item) => values.push(item.title));
                if (_.isEqual(titles, values)) {
                  return;
                }
                setAttributes({
                  cards: val,
                });
            }}
            className="sortable-posts"
          >
          {editorFields}
          </ReactSortable>
        </PanelRow>
        <hr></hr>
        <PanelRow>
          <Button
            isPrimary
            onClick={() => handleAddNew()}
          >
            Add New Card
          </Button>
        </PanelRow>
      </PanelBody>
    </InspectorControls>,
    <div {...blockProps} key="2">
      <div className={`purdue-home-cta-stack purdue-home-cta-stack-editor has-${background}-background`}>   
          <div className={`section has-padding-top-large has-padding-bottom-large`}>  
            <div className={`container`}>
              <div className="purdue-home-cta-stack__intro">
                <RichText
                  tagName='h2'
                  value={header}
                  className={`purdue-home-intro-text__header header-font-united purdue-home-cta-stack__header`}
                  onChange={(header) => {
                    setAttributes({ header});
                  }}
                  placeholder="Add header"
                ></RichText>
                <div className='purdue-home-cta-stack__content'>
                  <InnerBlocks
                    template={ BLOCKS_TEMPLATE }
                    templateLock={ false }
                  />
                </div>
              </div>
                {
                  cards && cards.length>0?
                  <div className="purdue-home-cta-stack__cards">
                    <div className="columns">
                    {cards.map((item, index) => {
                      return  <div key={index} className="column">
                        <div className={`purdue-home-cta-card purdue-home-cta-card--horizontal`}>
                          <div
                            className="image"
                          >
                            {item.mediaURL?
                              <img
                              className="purdue-home-background-image"
                              src={item.mediaURL}
                            />:""
                            }

                        </div>
                        <div className="flex-container--align-center">
                          <p className="purdue-home-cta-stack__card-title">{item.title}</p>
                          <p className="purdue-home-cta-stack__card-subtext">{item.subtext}</p>
                        </div>
                      </div>
                    </div>
                    })
                  }
                  </div>
                </div>:""
                }

            </div>
          </div>
      </div>
    </div>,
  ];
}
export default edit;