import {CustomActiveClass, check_resize} from '../../../src/js/front-end/slider';
import Glide from '@glidejs/glide';

const hotspot_buttons=document.querySelectorAll('.hot-spot-button')
if(hotspot_buttons && hotspot_buttons.length>0){
    hotspot_buttons.forEach((button)=>{
        const target = document.getElementById(button.dataset.target);
        button.addEventListener("click", (event)=>{
			if(event.target.classList.contains('is-active')){
                event.target.classList.remove('is-active')
				target.classList.remove('is-active')
            }else{
            	event.target.classList.add('is-active')
				target.classList.add('is-active')
            }

        })
		
        if(button.parentElement.parentElement.querySelector('.image')){
            button.parentElement.parentElement.querySelector('.image').addEventListener("click", ()=>{
                target.classList.remove('is-active');
                button.classList.remove('is-active');
            })
        }

        if(button.parentElement.previousElementSibling){
            button.parentElement.previousElementSibling.addEventListener("click", ()=>{
                target.classList.remove('is-active');
                button.classList.remove('is-active');
            })
        }
        if(button.parentElement.nextElementSibling){
            button.parentElement.nextElementSibling.addEventListener("click", ()=>{
                target.classList.remove('is-active');
                button.classList.remove('is-active');
            })
        }
    })
}


//desktop hot spot
const hs_desktop = document.querySelectorAll('.purdue-home-slide__hot-spot-desktop');

if(hs_desktop && hs_desktop.length>0){
	for (let i = 0; i < hs_desktop.length; i++) {
	let glide = new Glide(hs_desktop[i], {
		type: 'carousel',
		perView: 1
	});
	const nextButton = hs_desktop[i].querySelector('.arrow--left');
	const prevButton = hs_desktop[i].querySelector('.arrow--right');
	nextButton.addEventListener('click', function (event) {
		event.preventDefault();	  
		glide.go('<');
	})
	
	prevButton.addEventListener('click', function (event) {
		event.preventDefault();	  
		glide.go('>');
	})
  glide.slides_count = hs_desktop[i].querySelectorAll('.glide__slide').length;
  glide.controls = hs_desktop[i].querySelector('.slider-controls');
  glide.on('resize', () => {
    check_resize(glide);
  });
  glide.on('run', function() {
    const hotspot_buttons=hs_desktop[i].querySelectorAll('.hot-spot-button');
    if(hotspot_buttons && hotspot_buttons.length>0){
      hotspot_buttons.forEach((button)=>{
          const modal = button.dataset.target;
          const target = document.getElementById(modal);
          target.classList.remove('is-active');
          button.classList.remove('is-active');
      })
  }
  })
  glide.mount({CustomActiveClass,});
  check_resize(glide);
}}

//mobile hot spot
const hs_mobile = document.querySelectorAll('.purdue-home-slide__hot-spot-mobile');

if(hs_mobile && hs_mobile.length>0){
	for (let i = 0; i < hs_mobile.length; i++) {
	let glide = new Glide(hs_mobile[i], {
		type: 'carousel',
		perView: 1
	});
	const nextButton = hs_mobile[i].querySelector('.arrow--left');
	const prevButton = hs_mobile[i].querySelector('.arrow--right');
	nextButton.addEventListener('click', function (event) {
		event.preventDefault();	  
		glide.go('<');
	})
	
	prevButton.addEventListener('click', function (event) {
		event.preventDefault();	  
		glide.go('>');
	})
  glide.slides_count = hs_mobile[i].querySelectorAll('.glide__slide').length;
  glide.controls = hs_mobile[i].querySelector('.slider-controls');
  glide.on('resize', () => {
    check_resize(glide);
  });
  glide.mount({CustomActiveClass});
  check_resize(glide);
}}