<?php
$id = $attributes['id'] != "" ? ' id="' . $attributes['id'] . '"' : "";
$blockclass = 'purdue-home-image-slider section';
$blockclass .= ' has-' . $attributes['background'] . '-background';

if ($attributes['paddingTop']) {
    $blockclass .= ' ' . $attributes['paddingTop'];
}

if ($attributes['paddingBottom']) {
    $blockclass .= ' ' . $attributes['paddingBottom'];
}

if ($attributes['removeSidePadding']) {
    $blockclass .= ' has-no-sidepadding';
}

if ($attributes['type'] == "imageText") {
    $blockclass .= ' purdue-home-image-slider--has-text';
}
if (array_key_exists("loopSlider", $attributes) && $attributes['loopSlider'] == false) {
    $blockclass .= ' no-loop';
}
if ( isset( $attributes['align'] ) && ! empty( $attributes['align'] ) ) {
	$blockclass.= ' align' . $attributes['align'];
}
$blockclass .= ' ' . $attributes['className'];

// Start generating HTML
?>
<div <?= $id ?> class="<?= $blockclass ?>" data-columns="<?= $attributes['columns'] ?>">
    <div class="container">
        <div class="glide">
            <div class="glide__track" data-glide-el="track">
                <div class="glide__slides">

                    <?php if ($attributes['type'] == "image") { ?>
                        <?php foreach ($attributes['imgs'] as $img) { ?>
                            <?php if ($attributes['linkImg']) { ?>
                                <a class="glide__slide" href="<?= $img["url"] ?>" target="_blank">
                                    <figure class="image is-16by9">
                            <?php } else { ?>
                                <div class="glide__slide">
                                    <figure  class="image is-16by9">
                            <?php } ?>

                            <img src="<?= $img["url"] ?>" alt="<?= $img["alt"] ?>" />
                            <figcaption><?= $img["caption"] ?></figcaption>

                            <?php if ($attributes['linkImg']) { ?>
                                    </figure>
                                </a>
                            <?php } else { ?>
                                    </figure>
                                </div>
                            <?php } ?>
                        <?php } ?>
                    <?php } else { ?>
                        <?php foreach ($attributes['cards'] as $card) { ?>
                            <div class="glide__slide">
                                <div class="purdue-home-cta-card purdue-home-image-slider__card">
                                    <div class="purdue-home-image-slider__card-image">
                                        <figure class="image is-16by9">
                                            <img src="<?= $card["mediaURL"] ?>" alt="<?= $card["mediaAlt"] ?>" />
                                        </figure>
                                    </div>
                                    <div class="flex-container flex-container--align-bottom">
                                        <?php if ($card["title"]) { ?>
                                            <p class="purdue-home-image-slider__card-title"><?= $card["title"] ?></p>
                                        <?php } ?>
                                        <?php if ($card["subtext"]) { ?>
                                            <p class="purdue-home-image-slider__card-subtext"><?= $card["subtext"] ?></p>
                                        <?php } ?>
                                        <?php if ($card["linkURL"]) {
                                            $target = $card["external"] ? "_blank" : "_self";
                                        ?>
                                            <a class="purdue-home-button" href="<?= $card["linkURL"] ?>" target="<?= $target ?>"><?= $card["linkText"] ?></a>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    <?php } ?>

                </div>
            </div>
            <div class="slider-controls">
                <button class="glide__arrow arrow--left">prev</button>
                <div class="glide__bullets" data-glide-el="controls[nav]">

                    <?php if ($attributes['type'] == "image") { ?>
                        <?php foreach ($attributes['imgs'] as $key => $card) {
                            $num = $key + 1;
                        ?>
                            <button class="glide__bullet slider__bullet" data-glide-dir="=<?= $key ?>" aria-label="slide <?= $num ?>"></button>
                        <?php } ?>
                    <?php } else { ?>
                        <?php foreach ($attributes['cards'] as $key => $card) {
                            $num = $key + 1;
                        ?>
                            <button class="glide__bullet slider__bullet" data-glide-dir="=<?= $key ?>" aria-label="slide <?= $num ?>"></button>
                        <?php } ?>
                    <?php } ?>

                </div>
                <button class="glide__arrow arrow--right">next</button>
            </div>
        </div>
    </div>
</div>
