import { __ } from "@wordpress/i18n";
import {
  PanelBody,
  PanelRow,
  CheckboxControl,
  TextControl,
  RangeControl,
  TextareaControl,
  SelectControl,
  RadioControl,
  Button,
  Disabled
} from "@wordpress/components"
import { InspectorControls, MediaUploadCheck, MediaUpload, useBlockProps } from "@wordpress/block-editor";
import { ReactSortable } from 'react-sortablejs';

const Edit = ( props )=>{
  const { className, setAttributes } = props;
  const { header, slides, id} = props.attributes;
  const blockProps = useBlockProps();
  const removeSlides = (identifier) => {
    const newSlides = slides.filter((item) => {
      return item.mediaId!== identifier;
    });
    setAttributes({ slides: newSlides });
  };
  const initialSlides ={
    addLink1: false,
    link1_tag:'',
    link1_title:'',
    link1_content:'',
    link1_linkText:'Learn More',
    link1_linkURL:'',
    link1_external:true,
    link1_X:0,
    link1_Y:0,
    link1_mediaURL:'',
    link1_mediaAlt:'',
    addLink2: false,
    link2_tag:'',
    link2_title:'',
    link2_content:'',
    link2_linkText:'Learn More',
    link2_linkURL:'',
    link2_external:true,
    link2_X:0,
    link2_Y:0,
    link2_mediaURL:'',
    link2_mediaAlt:'',
    mediaId:0,
    mediaURL:'',
    mediaAlt:'',
    mediaCaption:''
  }
  if(slides.length ===0){
    setAttributes({slides:[initialSlides]})
  }
  const handleAddNewSlide = ()=>{
    let newSlides=[...slides];
    newSlides.push(initialSlides);
    setAttributes({slides: newSlides});
  }
  const handleSlideChangeLinkImage1 = ( img, index ) => {
    let newSlides=[...slides];
    newSlides[ index ].link1_mediaURL = img.url;
    newSlides[ index ].link1_mediaAlt = img.alt;
    setAttributes({slides: newSlides});
};
const handleSlideChangeLinkImage2 = ( img, index ) => {
  let newSlides=[...slides];
  newSlides[ index ].link2_mediaURL = img.url;
  newSlides[ index ].link2_mediaAlt = img.alt;
  setAttributes({slides: newSlides});
};

const handleSlideLinkTitle1Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link1_title=text;
  setAttributes({slides: newSlides});
}
const handleSlideLinkTitle2Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link2_title=text;
  setAttributes({slides: newSlides});
}
const handleSlideLinkTag1Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link1_tag=text;
  setAttributes({slides: newSlides});
}
const handleSlideLinkTag2Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link2_tag=text;
  setAttributes({slides: newSlides});
}
const handleSlideLinkURL1Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link1_linkURL=text;
  setAttributes({slides: newSlides});
}
const handleSlideLinkText1Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link1_linkText=text;
  setAttributes({slides: newSlides});
}
const handleSlideLinkContent1Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link1_content=text;
  setAttributes({slides: newSlides});
}
const handleSlideLinkURL2Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link2_linkURL=text;
  setAttributes({slides: newSlides});
}
const handleSlideLinkText2Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link2_linkText=text;
  setAttributes({slides: newSlides});
}
const handleSlideLinkContent2Change = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link2_content=text;
  setAttributes({slides: newSlides});
}
const handleSlideLink1ExternalChange = (index)=>{
  let newSlides=[...slides];
  newSlides[index].link1_external=!newSlides[index].link1_external;
  setAttributes({slides: newSlides});
}
const handleSlideLink2ExternalChange = (index)=>{
  let newSlides=[...slides];
  newSlides[index].link2_external=!newSlides[index].link2_external;
  setAttributes({slides: newSlides});
}
const handleSlideAddLink1 = (index)=>{
  let newSlides=[...slides];
  newSlides[index].addLink1=!newSlides[index].addLink1;
  setAttributes({slides: newSlides});
}
const handleSlideAddLink2 = (index)=>{
  let newSlides=[...slides];
  newSlides[index].addLink2=!newSlides[index].addLink2;
  setAttributes({slides: newSlides});
}
const handleSlideLink1XChange = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link1_X=text;
  setAttributes({slides: newSlides});
}
const handleSlideLink2XChange = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link2_X=text;
  setAttributes({slides: newSlides});
}
const handleSlideLink1YChange = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link1_Y=text;
  setAttributes({slides: newSlides});
}
const handleSlideLink2YChange = (text, index)=>{
  let newSlides=[...slides];
  newSlides[index].link2_Y=text;
  setAttributes({slides: newSlides});
}
const handleSlideChangeImage = ( img, index ) => {
    let newSlides=[...slides];
    newSlides[ index ].mediaId = img.id;
    newSlides[ index ].mediaURL = img.url;
    newSlides[ index ].mediaAlt = img.alt;
    newSlides[ index ].mediaCaption = img.caption;
    setAttributes({slides: newSlides});
};
const handleImgCaption = (index)=>{
  let newSlides=[...slides];
  newSlides[index].showCaption=!newSlides[index].showCaption;
  setAttributes({slides: newSlides});
}

let slideEditorFields;
slideEditorFields = slides.map((item, index) => {   
  return (
    <PanelBody initialOpen={false} key={index} title={`Slide ${index+1}`}>
          <PanelRow>
            <MediaUploadCheck>
              <MediaUpload
                onSelect={ ( img ) => handleSlideChangeImage (img, index)}
                allowedTypes={ ['image'] }
                render={ ( { open } ) => {
                  return item.mediaURL !== '' ? (
                    <div>
                      <img src={item.mediaURL} />
                      <Button
                        isSecondary                        
                        onClick={ open }
                      >
                        Select a New Media
                      </Button>
                    </div>
                  ) : (
                      <Button
                      isSecondary
                        onClick={ open }
                      >
                        Open Media Library
                      </Button>);
                } }
              />
            </MediaUploadCheck>            
        </PanelRow>
        <PanelRow>
          <CheckboxControl
            label="Show image caption?"
            checked={ item.showCaption}
            onChange={ () => handleImgCaption( index ) }
          />
        </PanelRow>
        <PanelRow>
          <CheckboxControl
            label="Add a hot spot?"
            checked={item.addLink1}
            onChange={() => {
              handleSlideAddLink1(index);
            }}
          />
        </PanelRow>
        {item.addLink1 ?
        <PanelRow>
          <TextControl
            label="Location for hot spot 1"
            value={ item.link1_tag }
            onChange={ ( val ) => handleSlideLinkTag1Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 ?
        <PanelRow>
          <TextControl
            label="Designate Spot for hot spot 1"
            value={ item.link1_title }
            onChange={ ( val ) => handleSlideLinkTitle1Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 ?
        <PanelRow>
          <TextareaControl
            label="Additional Info for hot spot 1"
            value={ item.link1_content }
            onChange={ ( val ) => handleSlideLinkContent1Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 ?
        <PanelRow>
          <TextControl
            label="Link Text for hot spot 1"
            value={ item.link1_linkText }
            onChange={ ( val ) => handleSlideLinkText1Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 ?
        <PanelRow>
          <TextControl
            label="Link for hot spot 1"
            value={ item.link1_linkURL }
            onChange={ ( val ) => handleSlideLinkURL1Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 ?
        <PanelRow>
          <CheckboxControl
            label="Open link in new tab?"
            checked={ item.link1_external }
            onChange={ () => handleSlideLink1ExternalChange( index ) }
          />
        </PanelRow>:""}
        {item.addLink1 ?
        <PanelRow>
            <MediaUploadCheck>
              <MediaUpload
                onSelect={ ( img ) => handleSlideChangeLinkImage1 (img, index)}
                allowedTypes={ ['image'] }
                render={ ( { open } ) => {
                  return item.link1_mediaURL !== '' ? (
                    <div>
                      <img src={item.link1_mediaURL} />
                      <Button
                        isSecondary                        
                        onClick={ open }
                      >
                        Select a New Media
                      </Button>
                    </div>
                  ) : (
                      <Button
                      isSecondary
                        onClick={ open }
                      >
                        Open Media Library
                      </Button>);
                } }
              />
            </MediaUploadCheck>
        </PanelRow>:""}
        {item.addLink1 ?
        <PanelRow>
          <RangeControl
              label="X position for hot spot 1"
              value={ item.link1_X }
              onChange={ ( value ) => handleSlideLink1XChange(value, index) }
              min={ 0 }
              max={ 100 }
          />
        </PanelRow>
        :""}
      {item.addLink1 ?
        <PanelRow>
          <RangeControl
              label="Y position for hot spot 1"
              value={ item.link1_Y }
              onChange={ ( value ) => handleSlideLink1YChange(value, index) }
              min={ 0 }
              max={ 100 }
          />
        </PanelRow>
        :""}
        {item.addLink1 ?
        <PanelRow>
          <CheckboxControl
            label="Add another hot spot?"
            checked={item.addLink2}
            onChange={() => {
              handleSlideAddLink2(index);
            }}
          />
        </PanelRow>
        :""}
      {item.addLink1 && item.addLink2 ?
        <PanelRow>
          <TextControl
            label="Location for hot spot 2"
            value={ item.link2_tag }
            onChange={ ( val ) => handleSlideLinkTag2Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 && item.addLink2 ?
        <PanelRow>
          <TextControl
            label="Designated Spot for hot spot 2"
            value={ item.link2_title }
            onChange={ ( val ) => handleSlideLinkTitle2Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 && item.addLink2  ?
        <PanelRow>
          <TextareaControl
            label="Additional Info for hot spot 2"
            value={ item.link2_content }
            onChange={ ( val ) => handleSlideLinkContent2Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 && item.addLink2  ?
        <PanelRow>
          <TextControl
            label="Link Text for hot spot 2"
            value={ item.link2_linkText }
            onChange={ ( val ) => handleSlideLinkText2Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 && item.addLink2 ?
        <PanelRow>
          <TextControl
            label="Link for hot spot 2"
            value={ item.link2_linkURL }
            onChange={ ( val ) => handleSlideLinkURL2Change( val, index ) }
          />
        </PanelRow>:""}
        {item.addLink1 && item.addLink2 ?
        <PanelRow>
          <CheckboxControl
            label="Open link in new tab?"
            checked={ item.link2_external }
            onChange={ () => handleSlideLink2ExternalChange( index ) }
          />
        </PanelRow>:""}
        {item.addLink1 && item.addLink2 ?
        <PanelRow>
            <MediaUploadCheck>
              <MediaUpload
                onSelect={ ( img ) => handleSlideChangeLinkImage2 (img, index)}
                allowedTypes={ ['image'] }
                render={ ( { open } ) => {
                  return item.link2_mediaURL !== '' ? (
                    <div>
                      <img src={item.link2_mediaURL} />
                      <Button
                        isSecondary                        
                        onClick={ open }
                      >
                        Select a New Media
                      </Button>
                    </div>
                  ) : (
                      <Button
                      isSecondary
                        onClick={ open }
                      >
                        Open Media Library
                      </Button>);
                } }
              />
            </MediaUploadCheck>
        </PanelRow>:""}
        {item.addLink1 && item.addLink2 ?
        <PanelRow>
          <RangeControl
              label="X position for hot spot 2"
              value={ item.link2_X }
              onChange={ ( value ) => handleSlideLink2XChange(value, index) }
              min={ 0 }
              max={ 100 }
          />
        </PanelRow>
        :""}
        {item.addLink1 && item.addLink2 ?
        <PanelRow>
          <RangeControl
              label="Y position for hot spot 2"
              value={ item.link2_Y }
              onChange={ ( value ) => handleSlideLink2YChange(value, index) }
              min={ 0 }
              max={ 100 }
          />
        </PanelRow>
        :""}
     
      <Button
        style={{ marginTop: '5px' }}
        isSecondary
        onClick={() => {
          removeSlides(item.mediaId);
        }}
      >
        Remove Item
      </Button>
    </PanelBody>
  );
})
  return [
    <InspectorControls key="1">
      <PanelBody>
        <PanelRow>
          <TextControl
            label="Add a header"
            value={ header }
            onChange={ ( header ) => setAttributes( { header } ) }
          />
        </PanelRow>
      </PanelBody>
      <PanelBody>
        <PanelRow>
          <TextControl
            label="HTML Anchor"
            help="Enter a word without spaces to make a unique web address just for this block, called an “anchor.” It must be unique from any other anchors on the page. Then, you’ll be able to link directly to this section of your page."
            value={ id }
            onChange={ ( id ) => setAttributes( { id } ) }
          />
        </PanelRow>
      </PanelBody>
      <PanelBody title={__('Slides')}>
        <PanelRow>
        <ReactSortable
            list={slides}
            setList={(val) => {
              let mediaIds = [],
                values = [];
                slides.map((item) => mediaIds.push(item.mediaId));
                val.map((item) => values.push(item.mediaId));
                if (_.isEqual(mediaIds, values)) {
                  return;
                }
                setAttributes({
                  slides: val,
                });
            }}
            className="sortable-posts"
          >
          {slideEditorFields}
          </ReactSortable>
        </PanelRow>
        <hr></hr>
        <PanelRow>
          <Button
            isPrimary
            onClick={() => handleAddNewSlide()}
          >
            Add New Large Card
          </Button>
        </PanelRow>
      </PanelBody>
    </InspectorControls>,
    <div {...blockProps} key="2">
    <div className={`purdue-home-hot-spot purdue-home-hotspot-editor`}>  
        <h2 className={`purdue-home-hot-spot--header tagged-header`}>{header}</h2>    
        <div className={`glide purdue-home-slide__hot-spot-desktop`}>  
          <div className="glide__track" data-glide-el="track">
            <div className="glide__slides">
              {slides.length===1 && slides[0].mediaId === 0?
              <div style={{textAlign:"center"}}>Please add header and slides using side panel.</div>:""
              }
              {slides.length>0?
                slides.map((item, index) => {
                  return <div key={index} className="glide__slide">
                    <div className="purdue-home-cta-card purdue-home-cta-card--horizontal">
                      <div className="image is-16by9">
                        <img src={item.mediaURL}/>
                      </div>
                      {
                        item.link1_title?
                        <div className="hot-spot" style={{top: `calc(${item.link1_Y}% - 72px)`, left: `calc(${item.link1_X}% - 72px)` }}>
                        <button className="hot-spot-button modal-trigger" data-target={`${item.mediaId}-link-1`}><span className="is-sr-only">Open</span></button>
                        </div>:""
                      }
                      {
                        item.link2_title?
                        <div className="hot-spot" style={{top: `calc(${item.link2_Y}% - 72px)`, left: `calc(${item.link2_X}% - 72px)` }}>
                        <button className="hot-spot-button modal-trigger" data-target={`${item.mediaId}-link-2`}><span className="is-sr-only">Open</span></button>
                        </div>:""
                      }

                    </div>
                    </div>
                }):""
              }
            </div>
          </div>
        </div>
    </div>
    </div>,
  ];
}

export default Edit;