import { __ } from "@wordpress/i18n";
import {
  PanelBody,
  PanelRow,
  CheckboxControl,
  TextControl,
  TextareaControl,
  SelectControl,
  RadioControl,
  Button,
  Disabled,
} from "@wordpress/components";

import {
  InspectorControls,
  MediaUploadCheck,
  MediaUpload,
  useBlockProps,
} from "@wordpress/block-editor";
import { ReactSortable } from "react-sortablejs";
import "./editor.scss";

const edit = (props) => {
  const { className, setAttributes } = props;
  const { smallCards, sliderCards, background, id, paddingTop, paddingBottom } =
    props.attributes;
  const blockProps = useBlockProps();
  const removeSmallCards = (identifier) => {
    const newSmallCards = smallCards.filter((item) => {
      return item.id !== identifier;
    });
    console.log(smallCards);
    setAttributes({ smallCards: newSmallCards });
  };
  const removeSliderCards = (identifier) => {
    const newSliderCards = sliderCards.filter((item) => {
      return item.id !== identifier;
    });
    setAttributes({ sliderCards: newSliderCards });
  };
  const initialSmallCards = {
    id: 0,
    mediaId: 0,
    mediaType: "img",
    mediaURL: "",
    mediaAlt: "",
    mediaTitle: "",
    linkType: "",
    linkText: "",
    linkURL: "",
    external: true,
  };
  const initialSliderCards = {
    id: 0,
    type: "rtb",
    lead: "",
    title: "",
    content: "",
    smallText: "",
    source: "",
    linkURL: "",
    external: true,
    reverseShade: false,
    background: "gold",
    ctaText: "",
    mediaId: 0,
    mediaType: "",
    mediaURL: "",
    mediaAlt: "",
    mediaTitle: "",
  };
  if (smallCards.length === 0) {
    setAttributes({ smallCards: [initialSmallCards] });
  }
  if (sliderCards.length === 0) {
    setAttributes({ sliderCards: [initialSliderCards] });
  }
  const handleAddNewCard = () => {
    let newSmallCards = [...smallCards];
    let newInitial = initialSmallCards;
    newInitial.id = newSmallCards.length;
    newSmallCards.length <= 1 ? newSmallCards.push(newInitial) : "";
    setAttributes({ smallCards: newSmallCards });
  };
  const handleAddNewSlide = () => {
    let newSliderCards = [...sliderCards];
    let newInitial = initialSliderCards;
    newInitial.id = newSliderCards.length;
    newSliderCards.length <= 4 ? newSliderCards.push(newInitial) : "";
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleCardLinkTextChange = (text, index) => {
    let newSmallCards = [...smallCards];
    newSmallCards[index].linkText = text;
    setAttributes({ smallCards: newSmallCards });
  };
  const handleCardLinkTypeChange = (text, index) => {
    let newSmallCards = [...smallCards];
    newSmallCards[index].linkType = text;
    setAttributes({ smallCards: newSmallCards });
  };
  const handleCardLinkURLChange = (url, index) => {
    let newSmallCards = [...smallCards];
    newSmallCards[index].linkURL = url;
    setAttributes({ smallCards: newSmallCards });
  };
  const handleCardExternalChange = (index) => {
    let newSmallCards = [...smallCards];
    newSmallCards[index].external = !newSmallCards[index].external;
    setAttributes({ smallCards: newSmallCards });
  };
  const handleCardChangeImage = (img, index) => {
    let newSmallCards = [...smallCards];
    newSmallCards[index].mediaId = img.id;
    newSmallCards[index].mediaType = img.type;
    newSmallCards[index].mediaURL = img.url;
    newSmallCards[index].mediaAlt = img.alt;
    newSmallCards[index].mediaTitle = img.title;
    setAttributes({ smallCards: newSmallCards });
  };
  const handleSlideTypeChange = (type, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].type = type;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideLeadChange = (text, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].lead = text;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideTitleChange = (text, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].title = text;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideSmallTextChange = (text, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].smallText = text;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideSourceChange = (text, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].source = text;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideBackgroundChange = (text, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].background = text;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideCtaTextChange = (text, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].ctaText = text;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideConentChange = (text, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].content = text;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideURLChange = (url, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].linkURL = url;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideExternalChange = (index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].external = !newSliderCards[index].external;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideShadeChange = (index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].reverseShade = !newSliderCards[index].reverseShade;
    setAttributes({ sliderCards: newSliderCards });
  };
  const handleSlideChangeImage = (img, index) => {
    let newSliderCards = [...sliderCards];
    newSliderCards[index].mediaId = img.id;
    newSliderCards[index].mediaType = img.type;
    newSliderCards[index].mediaURL = img.url;
    newSliderCards[index].mediaAlt = img.alt;
    newSliderCards[index].mediaTitle = img.title;
    setAttributes({ sliderCards: newSliderCards });
  };
  let cardEditorFields;
  cardEditorFields = smallCards.map((item, index) => {
    return (
      <PanelBody
        initialOpen={false}
        key={index}
        title={item.linkText ? item.linkText : `Card ${index + 1}`}
      >
        <PanelRow>
          <MediaUploadCheck>
            <MediaUpload
              onSelect={(img) => handleCardChangeImage(img, index)}
              render={({ open }) => {
                return item.mediaURL !== "" ? (
                  <div>
                    {item.mediaType === "image" ? (
                      <img src={item.mediaURL} />
                    ) : (
                      ""
                    )}
                    {item.mediaType === "video" ? (
                      <Disabled>
                        <video
                          muted
                          playsinline=""
                          title={item.mediaTitle}
                          src={item.mediaURL}
                        ></video>
                      </Disabled>
                    ) : (
                      ""
                    )}
                    <Button isSecondary onClick={open}>
                      Select a New Media
                    </Button>
                  </div>
                ) : (
                  <Button isSecondary onClick={open}>
                    Open Media Library
                  </Button>
                );
              }}
            />
          </MediaUploadCheck>
        </PanelRow>
        <PanelRow>
          <RadioControl
            label="Choose the type of this link."
            selected={item.linkType}
            options={[
              { label: "Youtube Video", value: "video" },
              { label: "Link", value: "story" },
              { label: "Image/video clip only", value: "none" },
            ]}
            onChange={(value) => handleCardLinkTypeChange(value, index)}
          />
        </PanelRow>
        {item.linkType !== "none" ? (
          <PanelRow>
            <TextareaControl
              label="Link Text"
              value={item.linkText}
              onChange={(val) => handleCardLinkTextChange(val, index)}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.linkType !== "none" ? (
          <PanelRow>
            <TextControl
              label={"Link URL"}
              type="url"
              onChange={(val) => {
                handleCardLinkURLChange(val, index);
              }}
              value={item.linkURL}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.linkType !== "none" ? (
          <PanelRow>
            <CheckboxControl
              label="Open link in new tab?"
              checked={item.external}
              onChange={() => {
                handleCardExternalChange(index);
              }}
            />
          </PanelRow>
        ) : (
          ""
        )}
        <Button
          style={{ marginTop: "5px" }}
          isSecondary
          onClick={() => {
            removeSmallCards(item.id);
          }}
        >
          Remove Item
        </Button>
      </PanelBody>
    );
  });
  let slideEditorFields;
  slideEditorFields = sliderCards.map((item, index) => {
    return (
      <PanelBody
        initialOpen={false}
        key={index}
        title={item.linkText ? item.linkText : `Card ${index + 1}`}
      >
        <PanelRow>
          <RadioControl
            label="Choose the type of this slide."
            selected={item.type}
            options={[
              { label: "RTB card", value: "rtb" },
              { label: "Story card", value: "story" },
              { label: "Image/video clip only", value: "image" },
              { label: "Text", value: "text" },
              { label: "Youtube Video", value: "video" },
            ]}
            onChange={(value) => handleSlideTypeChange(value, index)}
          />
        </PanelRow>
        {item.type === "rtb" || item.type === "text" ? (
          <PanelRow>
            <RadioControl
              label="Choose the background of this slide."
              selected={item.background}
              options={[
                { label: "Gold", value: "gold" },
                { label: "Black", value: "black" },
                { label: "Gray", value: "gray" },
                { label: "White", value: "white" },
              ]}
              onChange={(value) => handleSlideBackgroundChange(value, index)}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "rtb" ? (
          <PanelRow>
            <TextControl
              label="RTB Lead Text"
              value={item.lead}
              onChange={(val) => handleSlideLeadChange(val, index)}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "rtb" ? (
          <PanelRow>
            <TextControl
              label="RTB Large Text"
              value={item.title}
              onChange={(val) => handleSlideTitleChange(val, index)}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "rtb" ? (
          <PanelRow>
            <TextareaControl
              label="RTB Small Text"
              value={item.smallText}
              onChange={(val) => handleSlideSmallTextChange(val, index)}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "rtb" ? (
          <PanelRow>
            <TextControl
              label="RTB Source Text"
              value={item.source}
              onChange={(val) => handleSlideSourceChange(val, index)}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "story" ||
        item.type === "image" ||
        item.type === "video" ? (
          <PanelRow>
            <MediaUploadCheck>
              <MediaUpload
                onSelect={(img) => handleSlideChangeImage(img, index)}
                render={({ open }) => {
                  return item.mediaURL !== "" ? (
                    <div>
                      {item.mediaType === "image" ? (
                        <img src={item.mediaURL} />
                      ) : (
                        ""
                      )}
                      {item.mediaType === "video" ? (
                        <Disabled>
                          <video
                            muted
                            playsinline=""
                            title={item.mediaTitle}
                            src={item.mediaURL}
                          ></video>
                        </Disabled>
                      ) : (
                        ""
                      )}
                      <Button isSecondary onClick={open}>
                        Select a New Media
                      </Button>
                    </div>
                  ) : (
                    <Button isSecondary onClick={open}>
                      Open Media Library
                    </Button>
                  );
                }}
              />
            </MediaUploadCheck>
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "story" ? (
          <PanelRow>
            <TextControl
              label="CTA Text"
              value={item.ctaText}
              onChange={(val) => handleSlideCtaTextChange(val, index)}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "story" ||
        item.type === "text" ||
        item.type === "video" ? (
          <PanelRow>
            <TextControl
              label="Title"
              value={item.title}
              onChange={(val) => handleSlideTitleChange(val, index)}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "rtb" ||
        item.type === "story" ||
        item.type === "video" ? (
          <PanelRow>
            <TextControl
              label={"Link URL to this card"}
              type="url"
              onChange={(val) => {
                handleSlideURLChange(val, index);
              }}
              value={item.linkURL}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "rtb" ||
        item.type === "story" ||
        item.type === "video" ? (
          <PanelRow>
            <CheckboxControl
              label="Open link in new tab?"
              checked={item.external}
              onChange={() => {
                handleSlideExternalChange(index);
              }}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "story" ? (
          <PanelRow>
            <CheckboxControl
              label="Reverse Shade over the background?"
              help="You can check this box to use white shade over light image."
              checked={item.reverseShade}
              onChange={() => {
                handleSlideShadeChange(index);
              }}
            />
          </PanelRow>
        ) : (
          ""
        )}
        {item.type === "text" ? (
          <PanelRow>
            <TextareaControl
              label={"Add text"}
              onChange={(val) => {
                handleSlideConentChange(val, index);
              }}
              value={item.content}
            />
          </PanelRow>
        ) : (
          ""
        )}
        <Button
          style={{ marginTop: "5px" }}
          isSecondary
          onClick={() => {
            removeSliderCards(item.id);
          }}
        >
          Remove Item
        </Button>
      </PanelBody>
    );
  });
  return [
    <InspectorControls key="1">
      <PanelBody>
        <PanelRow>
          <SelectControl
            label="Choose the background"
            value={background}
            options={[
              { label: "None", value: "none" },
              { label: "Gold", value: "gold" },
              { label: "Black", value: "black" },
              { label: "Gray", value: "gray" },
            ]}
            onChange={(background) => setAttributes({ background })}
          />
        </PanelRow>
        <PanelRow>
          <SelectControl
            label="Padding at the top"
            value={paddingTop}
            options={[
              { value: "has-padding-top-none", label: "None" },
              { value: "has-padding-top-small", label: "Small" },
              { value: "", label: "Medium" },
              { value: "has-padding-top-large", label: "Large" },
            ]}
            onChange={(paddingTop) => {
              setAttributes({ paddingTop });
            }}
          />
        </PanelRow>
        <PanelRow>
          <SelectControl
            label="Padding at the bottom"
            value={paddingBottom}
            options={[
              { value: "has-padding-bottom-none", label: "None" },
              { value: "has-padding-bottom-small", label: "Small" },
              { value: "", label: "Medium" },
              { value: "has-padding-bottom-large", label: "Large" },
            ]}
            onChange={(paddingBottom) => {
              setAttributes({ paddingBottom });
            }}
          />
        </PanelRow>
        <PanelRow>
          <TextControl
            label="HTML Anchor"
            help="Enter a word without spaces to make a unique web address just for this block, called an “anchor.” It must be unique from any other anchors on the page. Then, you’ll be able to link directly to this section of your page."
            value={id}
            onChange={(id) => setAttributes({ id })}
          />
        </PanelRow>
      </PanelBody>
      <PanelBody title={__("Small Cards")}>
        <PanelRow>
          <ReactSortable
            list={smallCards}
            setList={(val) => {
              let ids = [],
                values = [];
              smallCards.map((item) => ids.push(item.id));
              val.map((item) => values.push(item.id));
              if (_.isEqual(ids, values)) {
                return;
              }
              setAttributes({
                smallCards: val,
              });
            }}
            className="sortable-posts"
          >
            {cardEditorFields}
          </ReactSortable>
        </PanelRow>
        <hr></hr>
        {smallCards.length <= 2 ? (
          <PanelRow>
            <Button isPrimary onClick={() => handleAddNewCard()}>
              Add New Small Card
            </Button>
          </PanelRow>
        ) : (
          ""
        )}
      </PanelBody>
      <PanelBody title={__("Large Cards")}>
        <PanelRow>
          <ReactSortable
            list={sliderCards}
            setList={(val) => {
              let ids = [],
                values = [];
              sliderCards.map((item) => ids.push(item.id));
              val.map((item) => values.push(item.id));
              if (_.isEqual(ids, values)) {
                return;
              }
              setAttributes({
                sliderCards: val,
              });
            }}
            className="sortable-posts"
          >
            {slideEditorFields}
          </ReactSortable>
        </PanelRow>
        <hr></hr>
        {sliderCards.length <= 4 ? (
          <PanelRow>
            <Button isPrimary onClick={() => handleAddNewSlide()}>
              Add New Large Card
            </Button>
          </PanelRow>
        ) : (
          ""
        )}
      </PanelBody>
    </InspectorControls>,
    <div {...blockProps} key="2">
      <div
        className={`purdue-home-mixed-rtb purdue-home-mixed-rtb-editor${
          paddingTop ? ` ${paddingTop}` : ""
        }${
          paddingBottom ? ` ${paddingBottom}` : ""
        } has-${background}-background`}
      >
        <div className={`section`}>
          <div className="container">
            <div className="columns">
              {smallCards.length > 0 &&
              (smallCards[0].mediaURL || smallCards[0].linkURL) ? (
                <div className="column">
                  {smallCards.map((item, index) => {
                    return (
                      <div
                        key={index}
                        className={`purdue-home-cta-card purdue-home-cta-card--horizontal${
                          item.linkType === "none"
                            ? " purdue-home-cta-card--nolink"
                            : ""
                        }`}
                      >
                        <div className="image is-16by9">
                          {item.mediaType === "image" ? (
                            <img
                              className="purdue-home-background-image"
                              src={item.mediaURL}
                            />
                          ) : (
                            ""
                          )}
                          {item.mediaType === "video" ? (
                            <video
                              className="purdue-home-background-image"
                              muted
                              playsinline=""
                              src={item.mediaURL}
                            />
                          ) : (
                            ""
                          )}
                        </div>
                        {item.linkType !== "none" ? (
                          <div className="flex-container--align-center">
                            <span className="cta-link purdue-home-cta-card__link">
                              {item.linkText}
                            </span>
                            {item.linkType === "story" ? (
                              <i className="fa-regular fa-circle-right cta-icon"></i>
                            ) : (
                              ""
                            )}
                            {item.linkType === "video" ? (
                              <i className="fa-regular fa-circle-play cta-icon"></i>
                            ) : (
                              ""
                            )}
                          </div>
                        ) : (
                          ""
                        )}
                      </div>
                    );
                  })}
                </div>
              ) : (
                ""
              )}
              {sliderCards.length > 0
                ? sliderCards.map((item, index) => {
                    if (
                        index <= 3
                    )
                      return (
                        <div key={index} className="column">
                          {item.type === "rtb" ? (
                            <div
                              className={`purdue-home-proofpoint has-${item.background}-background`}
                            >
                              <div className="flex-container--align-center">
                                {item.lead ? (
                                  <span className="lead-text purdue-home-proofpoint__lead">
                                    {item.lead}
                                  </span>
                                ) : (
                                  ""
                                )}
                                {item.title ? (
                                  <span className="large-text purdue-home-proofpoint__highlighted">
                                    {item.title}
                                  </span>
                                ) : (
                                  ""
                                )}
                                {item.smallText ? (
                                  <span className="small-text purdue-home-proofpoint__content">
                                    {item.smallText}
                                  </span>
                                ) : (
                                  ""
                                )}
                                {item.source && item.linkURL !== "" ? (
                                  <span className="source purdue-home-proofpoint__source">
                                    {item.source}
                                  </span>
                                ) : (
                                  <span className="source purdue-home-proofpoint__source">
                                    {item.source}
                                  </span>
                                )}
                              </div>
                            </div>
                          ) : (
                            ""
                          )}
                          {item.type === "story" ? (
                            <div
                              key={index}
                              className={`purdue-home-cta-card purdue-home-cta-card--vertical${
                                item.reverseShade ? " has-reverse-shade" : ""
                              }`}
                            >
                              <div className={`image is-4by5`}>
                                {item.mediaType === "image" ? (
                                  <img
                                    className="purdue-home-background-image"
                                    src={item.mediaURL}
                                  />
                                ) : (
                                  ""
                                )}
                                {item.mediaType === "video" ? (
                                  <video
                                    className="purdue-home-background-image"
                                    muted
                                    playsinline=""
                                    src={item.mediaURL}
                                  />
                                ) : (
                                  ""
                                )}
                              </div>
                              <div
                                key={index}
                                className="flex-container--align-vertical-between"
                              >
                                <p className="purdue-home-cta-card__cta-text">
                                  {item.ctaText}
                                </p>
                                <p
                                  className="cta-link purdue-home-cta-card__link"
                                  target={`${
                                    item.external ? "_blank" : "_self"
                                  }`}
                                >
                                  {item.title}
                                </p>
                              </div>
                            </div>
                          ) : (
                            ""
                          )}
                          {item.type === "image" ? (
                            <div
                              key={index}
                              className="purdue-home-cta-card purdue-home-cta-card--vertical purdue-home-cta-card--nolink"
                            >
                              <div className="image">
                                {item.mediaType === "image" ? (
                                  <img
                                    className="purdue-home-background-image"
                                    src={item.mediaURL}
                                  />
                                ) : (
                                  ""
                                )}
                                {item.mediaType === "video" ? (
                                  <video
                                    className="purdue-home-background-image"
                                    muted
                                    playsinline=""
                                    src={item.mediaURL}
                                  />
                                ) : (
                                  ""
                                )}
                              </div>
                            </div>
                          ) : (
                            ""
                          )}
                          {item.type === "text" ? (
                            <div
                              key={index}
                              className={`purdue-home-content-card has-${item.background}-background`}
                            >
                              <p className="purdue-home-content-card__title">
                                {item.title}
                              </p>
                              <p className="purdue-home-content-card__content">
                                {item.content}
                              </p>
                            </div>
                          ) : (
                            ""
                          )}
                          {item.type === "video" ? (
                            <div
                              key={index}
                              className={`purdue-home-cta-card purdue-home-cta-card--horizontal`}
                            >
                              <div className="image is-16by9">
                                {item.mediaType === "image" ? (
                                  <img
                                    className="purdue-home-background-image"
                                    src={item.mediaURL}
                                  />
                                ) : (
                                  ""
                                )}
                                {item.mediaType === "video" ? (
                                  <video
                                    className="purdue-home-background-image"
                                    muted
                                    playsinline=""
                                    src={item.mediaURL}
                                  />
                                ) : (
                                  ""
                                )}
                              </div>

                              <div className="flex-container--align-center">
                                <span className="cta-link purdue-home-cta-card__link">
                                  {item.title}
                                </span>

                                {item.linkType === "video" ? (
                                  <i className="fa-regular fa-circle-play cta-icon"></i>
                                ) : (
                                  ""
                                )}
                              </div>
                            </div>
                          ) : (
                            ""
                          )}
                        </div>
                      );
                  })
                : ""}
            </div>
          </div>
        </div>
      </div>
    </div>,
  ];
};

export default edit;
