const modals = document.querySelectorAll(".modal");
const windowHTML = document.querySelector("html");
const bodyWindow = document.querySelector("body");

function openModal(el) {
  el.classList.add("is-active");
  if (
    el.classList.contains("instagram-feed-modal")
  ) {
    const iframes = el.querySelectorAll("iframe");
    iframes.forEach((iframe) => {
      iframe.src = iframe.dataset.src;
    });
  }
}

function closeModal(el) {
  el.classList.remove("is-active");
  if (
    el.classList.contains("instagram-feed-modal")
  ) {
    const iframes = el.querySelectorAll("iframe");
    iframes.forEach((iframe) => {
      iframe.src = "";
    });
  }
}

function closeAllModals() {
  (modals || []).forEach((modal) => {
    closeModal(modal);
  });
}

// Add a click event on buttons to open a specific modal
(document.querySelectorAll(".modal-trigger") || []).forEach((trigger) => {
  const modal = trigger.dataset.target;

  const target = document.getElementById(modal); 

  trigger.addEventListener("click", (e) => {
    e.preventDefault();
    openModal(target);
    windowHTML.classList.add("no-scroll-page");
  });
});

// Add a click event on various child elements to close the parent modal
(
  document.querySelectorAll(
    ".modal-close, .modal-card-head .delete, .modal-card-foot .button, .modal-background"
  ) || []
).forEach((close) => {
  const target = close.closest(".modal");

  close.addEventListener("click", () => {
    closeModal(target);
    windowHTML.classList.remove("no-scroll-page");
  });
});

// Add a keyboard event to close all modals
document.addEventListener("keydown", (event) => {
  const e = event || window.event;

  if (e.key === "Escape") {
    // Escape key
    closeAllModals();
    windowHTML.classList.remove("no-scroll-page");
  }
});

//Turn off video player on close
let lightboxPlayers = [];
if (modals && modals.length > 0) {
  modals.forEach((t) => {
    const els = t.querySelectorAll(
      ".modal-close, .modal-card-head .delete, .modal-card-foot .button"
    );
    const video = t.querySelector("video");
    if (video) {
      if (els.lenght > 0) {
        els.forEach((el) => {
          el.addEventListener("click", () => {
            video.pause();
          });
        });
      }
    }
    const youtube = t.querySelector(".youtube-video");
    if (youtube) {
      let checkYT = setInterval(function () {
        if (typeof YT !== "undefined" && YT.loaded) {
          let lightboxPlayer = new YT.Player(youtube.id, {
            events: {
              onReady: function (e) {
                if (els.lenght > 0) {
                  els.forEach((el) => {
                    el.addEventListener("click", () => {
                      lightboxPlayer.pauseVideo();
                    });
                  });
                }
              },
            },
          });
          lightboxPlayers.push({
            id: youtube.id,
            player: lightboxPlayer,
          });
          clearInterval(checkYT);
        }
      }, 100);
      checkYT;
    }
  });
}

document.addEventListener("DOMContentLoaded", (event) => {

  let id = window.location.hash;

  if(id){
   let element =  document.querySelector(id);
   let modal = element.dataset.target;
   const target = document.getElementById(modal);
   
   setTimeout(() => {
      openModal(target);
      windowHTML.classList.add("no-scroll-page");
   }, "500");
  
  }
});

